/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.futures;

import com.spotify.futures.CompletableFutures;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Semaphore;

public class ConcurrencyReducer<T> {
    private final BlockingQueue<Job<T>> queue;
    private final Semaphore limit;
    private final int maxQueueSize;
    private final int maxConcurrency;

    private ConcurrencyReducer(int maxConcurrency, int maxQueueSize) {
        this.maxConcurrency = maxConcurrency;
        this.maxQueueSize = maxQueueSize;
        if (maxConcurrency <= 0) {
            throw new IllegalArgumentException("maxConcurrency must be at least 0");
        }
        if (maxQueueSize <= 0) {
            throw new IllegalArgumentException("maxQueueSize must be at least 0");
        }
        this.queue = new ArrayBlockingQueue<Job<T>>(maxQueueSize);
        this.limit = new Semaphore(maxConcurrency);
    }

    public static <T> ConcurrencyReducer<T> create(int maxConcurrency, int maxQueueSize) {
        return new ConcurrencyReducer<T>(maxConcurrency, maxQueueSize);
    }

    public CompletableFuture<T> add(Callable<? extends CompletionStage<T>> callable) {
        Objects.requireNonNull(callable);
        CompletableFuture response2 = new CompletableFuture();
        Job job2 = new Job(callable, response2);
        if (!this.queue.offer(job2)) {
            String message = "Queue size has reached capacity: " + this.maxQueueSize;
            return CompletableFutures.exceptionallyCompletedFuture(new CapacityReachedException(message));
        }
        this.pump();
        return response2;
    }

    public int numQueued() {
        return this.queue.size();
    }

    public int numActive() {
        return this.maxConcurrency - this.limit.availablePermits();
    }

    public int remainingQueueCapacity() {
        return this.queue.remainingCapacity();
    }

    public int remainingActiveCapacity() {
        return this.limit.availablePermits();
    }

    private Job<T> grabJob() {
        if (!this.limit.tryAcquire()) {
            return null;
        }
        Job job2 = (Job)this.queue.poll();
        if (job2 != null) {
            return job2;
        }
        this.limit.release();
        return null;
    }

    private void pump() {
        Job<T> job2;
        while ((job2 = this.grabJob()) != null) {
            CompletableFuture response2 = ((Job)job2).response;
            if (response2.isCancelled()) {
                this.limit.release();
                continue;
            }
            this.invoke(response2, ((Job)job2).callable);
        }
    }

    private void invoke(CompletableFuture<T> response2, Callable<? extends CompletionStage<T>> callable) {
        CompletionStage<Object> future;
        try {
            future = callable.call();
            if (future == null) {
                this.limit.release();
                response2.completeExceptionally(new NullPointerException());
                return;
            }
        }
        catch (Throwable e) {
            this.limit.release();
            response2.completeExceptionally(e);
            return;
        }
        future.whenComplete((result2, t2) -> {
            if (t2 != null) {
                this.limit.release();
                response2.completeExceptionally((Throwable)t2);
                this.pump();
            } else {
                this.limit.release();
                response2.complete(result2);
                this.pump();
            }
        });
    }

    private static class Job<T> {
        private final Callable<? extends CompletionStage<T>> callable;
        private final CompletableFuture<T> response;

        public Job(Callable<? extends CompletionStage<T>> callable, CompletableFuture<T> response2) {
            this.callable = callable;
            this.response = response2;
        }
    }

    public static class CapacityReachedException
    extends RuntimeException {
        public CapacityReachedException(String errorMessage) {
            super(errorMessage);
        }
    }
}

