/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.internal.ExceptionMapper;
import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.ToolCallBuilder;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.ollama.CompletionRequest;
import dev.langchain4j.model.ollama.CompletionResponse;
import dev.langchain4j.model.ollama.DeleteModelRequest;
import dev.langchain4j.model.ollama.EmbeddingRequest;
import dev.langchain4j.model.ollama.EmbeddingResponse;
import dev.langchain4j.model.ollama.InternalOllamaHelper;
import dev.langchain4j.model.ollama.Message;
import dev.langchain4j.model.ollama.ModelsListResponse;
import dev.langchain4j.model.ollama.OllamaChatRequest;
import dev.langchain4j.model.ollama.OllamaChatResponse;
import dev.langchain4j.model.ollama.OllamaJsonUtils;
import dev.langchain4j.model.ollama.OllamaModelCard;
import dev.langchain4j.model.ollama.OllamaServerSentEventParser;
import dev.langchain4j.model.ollama.OllamaStreamingResponseBuilder;
import dev.langchain4j.model.ollama.RunningModelsListResponse;
import dev.langchain4j.model.ollama.ShowModelInformationRequest;
import dev.langchain4j.model.ollama.ToolCall;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.List;
import java.util.Map;

class OllamaClient {
    private final HttpClient httpClient;
    private final String baseUrl;
    private final Map<String, String> defaultHeaders;

    OllamaClient(Builder builder) {
        HttpClientBuilder httpClientBuilder = Utils.getOrDefault(builder.httpClientBuilder, HttpClientBuilderLoader::loadHttpClientBuilder);
        HttpClient httpClient = httpClientBuilder.connectTimeout(Utils.getOrDefault(Utils.getOrDefault(builder.timeout, httpClientBuilder.connectTimeout()), Duration.ofSeconds(15L))).readTimeout(Utils.getOrDefault(Utils.getOrDefault(builder.timeout, httpClientBuilder.readTimeout()), Duration.ofSeconds(60L))).build();
        this.httpClient = builder.logRequests || builder.logResponses ? new LoggingHttpClient(httpClient, builder.logRequests, builder.logResponses) : httpClient;
        this.baseUrl = ValidationUtils.ensureNotBlank(builder.baseUrl, "baseUrl");
        this.defaultHeaders = Utils.copy(builder.customHeaders);
    }

    static Builder builder() {
        return new Builder();
    }

    CompletionResponse completion(CompletionRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "api/generate").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(request)).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return OllamaJsonUtils.fromJson(successfulHttpResponse.body(), CompletionResponse.class);
    }

    OllamaChatResponse chat(OllamaChatRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "api/chat").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(request)).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return OllamaJsonUtils.fromJson(successfulHttpResponse.body(), OllamaChatResponse.class);
    }

    void streamingCompletion(CompletionRequest request, final StreamingResponseHandler<String> handler) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "api/generate").addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(request)).build();
        this.httpClient.execute(httpRequest, new OllamaServerSentEventParser(), new ServerSentEventListener(){
            final StringBuilder contentBuilder = new StringBuilder();

            @Override
            public void onEvent(ServerSentEvent event) {
                CompletionResponse completionResponse = OllamaJsonUtils.fromJson(event.data(), CompletionResponse.class);
                this.contentBuilder.append(completionResponse.getResponse());
                handler.onNext(completionResponse.getResponse());
                if (Boolean.TRUE.equals(completionResponse.getDone())) {
                    Response<String> response = Response.from(this.contentBuilder.toString(), new TokenUsage(completionResponse.getPromptEvalCount(), completionResponse.getEvalCount()));
                    handler.onComplete(response);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                handler.onError(ExceptionMapper.DEFAULT.mapException(throwable));
            }
        });
    }

    void streamingChat(ChatRequest request, final boolean returnThinking, final StreamingChatResponseHandler handler) {
        ValidationUtils.ensureNotEmpty(request.messages(), "messages");
        OllamaChatRequest ollamaChatRequest = InternalOllamaHelper.toOllamaChatRequest(request, true);
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "api/chat").addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(ollamaChatRequest)).build();
        this.httpClient.execute(httpRequest, new OllamaServerSentEventParser(), new ServerSentEventListener(){
            final ToolCallBuilder toolCallBuilder = new ToolCallBuilder();
            final OllamaStreamingResponseBuilder responseBuilder = new OllamaStreamingResponseBuilder(this.toolCallBuilder, returnThinking);

            @Override
            public void onEvent(ServerSentEvent event) {
                List<ToolCall> toolCalls;
                OllamaChatResponse ollamaChatResponse = OllamaJsonUtils.fromJson(event.data(), OllamaChatResponse.class);
                this.responseBuilder.append(ollamaChatResponse);
                Message message = ollamaChatResponse.getMessage();
                if (message == null) {
                    return;
                }
                String content = message.getContent();
                if (!Utils.isNullOrEmpty(content)) {
                    InternalStreamingChatResponseHandlerUtils.onPartialResponse(handler, content);
                }
                String thinking = message.getThinking();
                if (returnThinking && !Utils.isNullOrEmpty(thinking)) {
                    InternalStreamingChatResponseHandlerUtils.onPartialThinking(handler, thinking);
                }
                if ((toolCalls = message.getToolCalls()) != null) {
                    for (ToolCall toolCall : toolCalls) {
                        int index = Utils.getOrDefault(toolCall.getFunction().getIndex(), 0);
                        if (this.toolCallBuilder.index() != index) {
                            InternalStreamingChatResponseHandlerUtils.onCompleteToolCall(handler, this.toolCallBuilder.buildAndReset());
                            this.toolCallBuilder.updateIndex(index);
                        }
                        this.toolCallBuilder.updateName(toolCall.getFunction().getName());
                        String partialArguments = OllamaJsonUtils.toJsonWithoutIdent(toolCall.getFunction().getArguments());
                        if (!Utils.isNotNullOrEmpty(partialArguments)) continue;
                        this.toolCallBuilder.appendArguments(partialArguments);
                    }
                }
                if (Boolean.TRUE.equals(ollamaChatResponse.getDone())) {
                    if (this.toolCallBuilder.hasRequests()) {
                        InternalStreamingChatResponseHandlerUtils.onCompleteToolCall(handler, this.toolCallBuilder.buildAndReset());
                    }
                    ChatResponse completeResponse = this.responseBuilder.build(ollamaChatResponse);
                    InternalStreamingChatResponseHandlerUtils.onCompleteResponse(handler, completeResponse);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                RuntimeException mappedException = ExceptionMapper.DEFAULT.mapException(throwable);
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError(mappedException));
            }
        });
    }

    EmbeddingResponse embed(EmbeddingRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "api/embed").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(request)).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return OllamaJsonUtils.fromJson(successfulHttpResponse.body(), EmbeddingResponse.class);
    }

    ModelsListResponse listModels() {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.GET).url(this.baseUrl, "api/tags").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return OllamaJsonUtils.fromJson(successfulHttpResponse.body(), ModelsListResponse.class);
    }

    OllamaModelCard showInformation(ShowModelInformationRequest showInformationRequest) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "api/show").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(showInformationRequest)).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return OllamaJsonUtils.fromJson(successfulHttpResponse.body(), OllamaModelCard.class);
    }

    RunningModelsListResponse listRunningModels() {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.GET).url(this.baseUrl, "api/ps").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).build();
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return OllamaJsonUtils.fromJson(successfulHttpResponse.body(), RunningModelsListResponse.class);
    }

    Void deleteModel(DeleteModelRequest deleteModelRequest) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.DELETE).url(this.baseUrl, "api/delete").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).body(OllamaJsonUtils.toJson(deleteModelRequest)).build();
        this.httpClient.execute(httpRequest);
        return null;
    }

    static class Builder {
        private HttpClientBuilder httpClientBuilder;
        private String baseUrl;
        private Duration timeout;
        private boolean logRequests;
        private boolean logResponses;
        private Map<String, String> customHeaders;

        Builder() {
        }

        Builder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this;
        }

        Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        Builder logRequests(Boolean logRequests) {
            if (logRequests == null) {
                logRequests = false;
            }
            this.logRequests = logRequests;
            return this;
        }

        Builder logResponses(Boolean logResponses) {
            if (logResponses == null) {
                logResponses = false;
            }
            this.logResponses = logResponses;
            return this;
        }

        Builder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        OllamaClient build() {
            return new OllamaClient(this);
        }
    }
}

