/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.guardrail.GuardrailRequestParams;
import dev.langchain4j.rag.content.Content;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.List;
import java.util.Map;

@Internal
public class AiServiceTokenStreamParameters {
    private final List<ChatMessage> messages;
    private final List<ToolSpecification> toolSpecifications;
    private final Map<String, ToolExecutor> toolExecutors;
    private final List<Content> retrievedContents;
    private final AiServiceContext context;
    private final Object memoryId;
    private final GuardrailRequestParams commonGuardrailParams;
    private final Object methodKey;

    protected AiServiceTokenStreamParameters(Builder builder) {
        this.messages = builder.messages;
        this.toolSpecifications = builder.toolSpecifications;
        this.toolExecutors = builder.toolExecutors;
        this.retrievedContents = builder.retrievedContents;
        this.context = builder.context;
        this.memoryId = builder.memoryId;
        this.commonGuardrailParams = builder.commonGuardrailParams;
        this.methodKey = builder.methodKey;
    }

    public List<ChatMessage> messages() {
        return this.messages;
    }

    public List<ToolSpecification> toolSpecifications() {
        return this.toolSpecifications;
    }

    public Map<String, ToolExecutor> toolExecutors() {
        return this.toolExecutors;
    }

    public List<Content> gretrievedContents() {
        return this.retrievedContents;
    }

    public AiServiceContext context() {
        return this.context;
    }

    public Object memoryId() {
        return this.memoryId;
    }

    public GuardrailRequestParams commonGuardrailParams() {
        return this.commonGuardrailParams;
    }

    public Object methodKey() {
        return this.methodKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<ChatMessage> messages;
        private List<ToolSpecification> toolSpecifications;
        private Map<String, ToolExecutor> toolExecutors;
        private List<Content> retrievedContents;
        private AiServiceContext context;
        private Object memoryId;
        private GuardrailRequestParams commonGuardrailParams;
        private Object methodKey;

        protected Builder() {
        }

        public Builder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder toolSpecifications(List<ToolSpecification> toolSpecifications) {
            this.toolSpecifications = toolSpecifications;
            return this;
        }

        public Builder toolExecutors(Map<String, ToolExecutor> toolExecutors) {
            this.toolExecutors = toolExecutors;
            return this;
        }

        public Builder retrievedContents(List<Content> retrievedContents) {
            this.retrievedContents = retrievedContents;
            return this;
        }

        public Builder context(AiServiceContext context) {
            this.context = context;
            return this;
        }

        public Builder memoryId(Object memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public Builder commonGuardrailParams(GuardrailRequestParams commonGuardrailParams) {
            this.commonGuardrailParams = commonGuardrailParams;
            return this;
        }

        public Builder methodKey(Object methodKey) {
            this.methodKey = methodKey;
            return this;
        }

        public AiServiceTokenStreamParameters build() {
            return new AiServiceTokenStreamParameters(this);
        }
    }
}

