/*
 * Decompiled with CFR 0.152.
 */
package net.overlordaimod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.text2speech.Narrator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.overlordaimod.ModConfig;

public class ConfigHandler
implements SimpleSynchronousResourceReloadListener {
    public static final class_2960 ID = class_2960.method_60655((String)"overlordaimod", (String)"reload_config");
    public static final String FILE_NAME = "overlordaimod.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static ModConfig CONFIG;

    public static void loadConfig() {
        Path configFile = FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
        if (Files.notExists(configFile, new LinkOption[0])) {
            CONFIG = new ModConfig();
            ConfigHandler.saveConfig();
            Narrator.LOGGER.info("Created default config at {}", (Object)configFile);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(configFile);){
            CONFIG = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            if (CONFIG == null) {
                throw new IOException("Parsed config is null");
            }
            Narrator.LOGGER.info("Loaded config from {}", (Object)configFile);
        }
        catch (Exception e) {
            Narrator.LOGGER.error("Failed to load config, falling back to defaults", (Throwable)e);
            CONFIG = new ModConfig();
        }
    }

    public static void saveConfig() {
        Path configFile = FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
        try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
            GSON.toJson((Object)CONFIG, (Appendable)writer);
            Narrator.LOGGER.info("Saved config to {}", (Object)configFile);
        }
        catch (IOException e) {
            Narrator.LOGGER.error("Could not save config", (Throwable)e);
        }
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(class_3300 manager) {
        ConfigHandler.loadConfig();
    }
}

