/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client;

import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpRequest {
    private final HttpMethod method;
    private final String url;
    private final Map<String, List<String>> headers;
    private final String body;

    public HttpRequest(Builder builder) {
        this.method = ValidationUtils.ensureNotNull(builder.method, "method");
        this.url = ValidationUtils.ensureNotBlank(builder.url, "url");
        this.headers = Utils.copy(builder.headers);
        this.body = builder.body;
    }

    public HttpMethod method() {
        return this.method;
    }

    public String url() {
        return this.url;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String body() {
        return this.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private HttpMethod method;
        private String url;
        private Map<String, List<String>> headers;
        private String body;

        private Builder() {
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder url(String baseUrl, String path) {
            ValidationUtils.ensureNotBlank(baseUrl, "baseUrl");
            ValidationUtils.ensureNotBlank(path, "path");
            if (baseUrl.endsWith("/")) {
                baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            this.url = baseUrl + "/" + path;
            return this;
        }

        public Builder addHeader(String name, String ... values) {
            ValidationUtils.ensureNotBlank(name, "name");
            ValidationUtils.ensureNotEmpty(values, "values");
            if (this.headers == null) {
                this.headers = new HashMap<String, List<String>>();
            }
            this.headers.put(name, Arrays.asList(values));
            return this;
        }

        public Builder addHeaders(Map<String, String> headers) {
            if (Utils.isNullOrEmpty(headers)) {
                return this;
            }
            if (this.headers == null) {
                this.headers = new HashMap<String, List<String>>();
            }
            headers.forEach((name, value) -> this.headers.put((String)name, List.of(value)));
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this);
        }
    }
}

