/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.machine.BlockBeamBase;
import com.hbm.blocks.machine.Spotlight;
import com.hbm.tileentity.TileEntityData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class SpotlightBeam
extends BlockBeamBase {
    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        if (!world.field_72995_K) {
            for (ForgeDirection dir : SpotlightBeam.getDirections(world, x, y, z)) {
                Spotlight.unpropagateBeam(world, x, y, z, dir);
            }
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        if (world.field_72995_K) {
            return;
        }
        if (neighborBlock instanceof SpotlightBeam) {
            return;
        }
        for (ForgeDirection dir : SpotlightBeam.getDirections(world, x, y, z)) {
            Spotlight.backPropagate(world, x, y, z, dir, world.func_72805_g(x, y, z));
        }
    }

    public static List<ForgeDirection> getDirections(World world, int x, int y, int z) {
        TileEntityData te = (TileEntityData)world.func_147438_o(x, y, z);
        if (te == null) {
            return new ArrayList<ForgeDirection>();
        }
        return SpotlightBeam.getDirections(te.metadata);
    }

    public static List<ForgeDirection> getDirections(int metadata) {
        ArrayList<ForgeDirection> directions = new ArrayList<ForgeDirection>(6);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if ((metadata & dir.flag) != dir.flag) continue;
            directions.add(dir);
        }
        return directions;
    }

    public static int setDirection(World world, int x, int y, int z, ForgeDirection dir, boolean state) {
        int transformedMetadata;
        TileEntityData te = (TileEntityData)world.func_147438_o(x, y, z);
        if (te == null) {
            return 0;
        }
        te.metadata = transformedMetadata = SpotlightBeam.applyDirection(te.metadata, dir, state);
        return transformedMetadata;
    }

    public static int applyDirection(int metadata, ForgeDirection direction, boolean state) {
        if (state) {
            return metadata | direction.flag;
        }
        return metadata & ~direction.flag;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityData();
    }
}

