/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.util.TrackerUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public abstract class EntityThrowableNT
extends Entity
implements IProjectile {
    private int stuckBlockX = -1;
    private int stuckBlockY = -1;
    private int stuckBlockZ = -1;
    private Block stuckBlock;
    protected boolean inGround;
    public int throwableShake;
    protected EntityLivingBase thrower;
    private String throwerName;
    public int ticksInGround;
    private int ticksInAir;

    public EntityThrowableNT(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(2, (Object)0);
    }

    public void setStuckIn(int side) {
        this.field_70180_af.func_75692_b(2, (Object)((byte)side));
    }

    public int getStuckIn() {
        return this.field_70180_af.func_75683_a(2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double dist) {
        double perimeter = this.field_70121_D.func_72320_b() * 4.0;
        return dist < (perimeter *= 64.0) * perimeter;
    }

    public EntityThrowableNT(World world, EntityLivingBase thrower) {
        super(world);
        this.thrower = thrower;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(thrower.field_70165_t, thrower.field_70163_u + (double)thrower.func_70047_e(), thrower.field_70161_v, thrower.field_70177_z, thrower.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        float velocity = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * velocity;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * velocity;
        this.field_70181_x = -MathHelper.func_76126_a((float)((this.field_70125_A + this.throwAngle()) / 180.0f * (float)Math.PI)) * velocity;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.throwForce(), 1.0f);
    }

    public EntityThrowableNT(World world, double x, double y, double z) {
        super(world);
        this.ticksInGround = 0;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70107_b(x, y, z);
        this.field_70129_M = 0.0f;
    }

    protected float throwForce() {
        return 1.5f;
    }

    protected double headingForceMult() {
        return 0.0075;
    }

    protected float throwAngle() {
        return 0.0f;
    }

    protected double motionMult() {
        return 1.0;
    }

    public void func_70186_c(double motionX, double motionY, double motionZ, float velocity, float inaccuracy) {
        float throwLen = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        motionX /= (double)throwLen;
        motionY /= (double)throwLen;
        motionZ /= (double)throwLen;
        motionX += this.field_70146_Z.nextGaussian() * this.headingForceMult() * (double)inaccuracy;
        motionY += this.field_70146_Z.nextGaussian() * this.headingForceMult() * (double)inaccuracy;
        motionZ += this.field_70146_Z.nextGaussian() * this.headingForceMult() * (double)inaccuracy;
        this.field_70159_w = motionX *= (double)velocity;
        this.field_70181_x = motionY *= (double)velocity;
        this.field_70179_y = motionZ *= (double)velocity;
        float hyp = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motionY, hyp) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float hyp = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, hyp) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            if (this.field_70170_p.func_147439_a(this.stuckBlockX, this.stuckBlockY, this.stuckBlockZ) == this.stuckBlock) {
                ++this.ticksInGround;
                if (this.groundDespawn() > 0 && this.ticksInGround == this.groundDespawn()) {
                    this.func_70106_y();
                }
                return;
            }
            this.inGround = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
            Vec3 pos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 nextPos = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w * this.motionMult()), (double)(this.field_70163_u + this.field_70181_x * this.motionMult()), (double)(this.field_70161_v + this.field_70179_y * this.motionMult()));
            MovingObjectPosition mop = null;
            if (!this.isSpectral()) {
                mop = this.field_70170_p.func_147447_a(pos, nextPos, false, true, false);
            }
            pos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            nextPos = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w * this.motionMult()), (double)(this.field_70163_u + this.field_70181_x * this.motionMult()), (double)(this.field_70161_v + this.field_70179_y * this.motionMult()));
            if (mop != null) {
                nextPos = Vec3.func_72443_a((double)mop.field_72307_f.field_72450_a, (double)mop.field_72307_f.field_72448_b, (double)mop.field_72307_f.field_72449_c);
            }
            if (!this.field_70170_p.field_72995_K && this.doesImpactEntities()) {
                Entity hitEntity = null;
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w * this.motionMult(), this.field_70181_x * this.motionMult(), this.field_70179_y * this.motionMult()).func_72314_b(1.0, 1.0, 1.0));
                double nearest = 0.0;
                EntityLivingBase thrower = this.getThrower();
                MovingObjectPosition nonPenImpact = null;
                for (int j = 0; j < list.size(); ++j) {
                    double hitbox;
                    AxisAlignedBB aabb;
                    MovingObjectPosition hitMop;
                    Entity entity = (Entity)list.get(j);
                    if (!entity.func_70067_L() || entity == thrower && this.ticksInAir < this.selfDamageDelay() || !entity.func_70089_S() || (hitMop = (aabb = entity.field_70121_D.func_72314_b(hitbox = (double)0.3f, hitbox, hitbox)).func_72327_a(pos, nextPos)) == null) continue;
                    if (this.doesPenetrate()) {
                        this.onImpact(new MovingObjectPosition(entity, hitMop.field_72307_f));
                        continue;
                    }
                    double dist = pos.func_72438_d(hitMop.field_72307_f);
                    if (!(dist < nearest) && nearest != 0.0) continue;
                    hitEntity = entity;
                    nearest = dist;
                    nonPenImpact = hitMop;
                }
                if (!this.doesPenetrate() && hitEntity != null) {
                    mop = new MovingObjectPosition(hitEntity, nonPenImpact.field_72307_f);
                }
            }
            if (mop != null) {
                if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) == Blocks.field_150427_aO) {
                    this.func_70063_aa();
                } else {
                    this.onImpact(mop);
                }
            }
            if (!this.field_70122_E) {
                float hyp = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
                this.field_70125_A = (float)(Math.atan2(this.field_70181_x, hyp) * 180.0 / Math.PI);
                while (this.field_70125_A - this.field_70127_C < -180.0f) {
                    this.field_70127_C -= 360.0f;
                }
                while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                    this.field_70127_C += 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B < -180.0f) {
                    this.field_70126_B -= 360.0f;
                }
                while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                    this.field_70126_B += 360.0f;
                }
                this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
                this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            }
            float drag = this.getAirDrag();
            double gravity = this.getGravityVelocity();
            this.field_70165_t += this.field_70159_w * this.motionMult();
            this.field_70163_u += this.field_70181_x * this.motionMult();
            this.field_70161_v += this.field_70179_y * this.motionMult();
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    float f = 0.25f;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f, this.field_70163_u - this.field_70181_x * (double)f, this.field_70161_v - this.field_70179_y * (double)f, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                drag = this.getWaterDrag();
            }
            this.field_70159_w *= (double)drag;
            this.field_70181_x *= (double)drag;
            this.field_70179_y *= (double)drag;
            this.field_70181_x -= gravity;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public boolean doesImpactEntities() {
        return true;
    }

    public boolean doesPenetrate() {
        return false;
    }

    public boolean isSpectral() {
        return false;
    }

    public int selfDamageDelay() {
        return 5;
    }

    public void getStuck(int x, int y, int z, int side) {
        this.stuckBlockX = x;
        this.stuckBlockY = y;
        this.stuckBlockZ = z;
        this.stuckBlock = this.field_70170_p.func_147439_a(x, y, z);
        this.inGround = true;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.setStuckIn(side);
        TrackerUtil.sendTeleport(this.field_70170_p, this);
    }

    public double getGravityVelocity() {
        return 0.03;
    }

    protected abstract void onImpact(MovingObjectPosition var1);

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74777_a("xTile", (short)this.stuckBlockX);
        nbt.func_74777_a("yTile", (short)this.stuckBlockY);
        nbt.func_74777_a("zTile", (short)this.stuckBlockZ);
        nbt.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.stuckBlock));
        nbt.func_74774_a("shake", (byte)this.throwableShake);
        nbt.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        if ((this.throwerName == null || this.throwerName.length() == 0) && this.thrower != null && this.thrower instanceof EntityPlayer) {
            this.throwerName = this.thrower.func_70005_c_();
        }
        nbt.func_74778_a("ownerName", this.throwerName == null ? "" : this.throwerName);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.stuckBlockX = nbt.func_74765_d("xTile");
        this.stuckBlockY = nbt.func_74765_d("yTile");
        this.stuckBlockZ = nbt.func_74765_d("zTile");
        this.stuckBlock = Block.func_149729_e((int)(nbt.func_74771_c("inTile") & 0xFF));
        this.throwableShake = nbt.func_74771_c("shake") & 0xFF;
        this.inGround = nbt.func_74771_c("inGround") == 1;
        this.throwerName = nbt.func_74779_i("ownerName");
        if (this.throwerName != null && this.throwerName.length() == 0) {
            this.throwerName = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void setThrower(EntityLivingBase thrower) {
        this.thrower = thrower;
    }

    public EntityLivingBase getThrower() {
        if (this.thrower == null && this.throwerName != null && this.throwerName.length() > 0) {
            this.thrower = this.field_70170_p.func_72924_a(this.throwerName);
        }
        return this.thrower;
    }

    protected float getAirDrag() {
        return 0.99f;
    }

    protected float getWaterDrag() {
        return 0.8f;
    }

    protected int groundDespawn() {
        return 1200;
    }
}

