/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.radiation;

import com.hbm.handler.radiation.ChunkRadiationHandler;
import com.hbm.interfaces.Untested;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkRadiationHandler3D
extends ChunkRadiationHandler {
    private Map<World, ThreeDimRadiationPerWorld> perWorld = new HashMap<World, ThreeDimRadiationPerWorld>();
    private static final String NBT_KEY_CHUNK_RADIATION = "hfr_3d_radiation_";

    @Override
    @Untested
    public float getRadiation(World world, int x, int y, int z) {
        ThreeDimRadiationPerWorld radWorld = this.perWorld.get(world);
        if (radWorld != null) {
            ChunkCoordIntPair coords = new ChunkCoordIntPair(x >> 4, z >> 4);
            int yReg = MathHelper.func_76125_a((int)(y >> 4), (int)0, (int)15);
            Float rad = radWorld.radiation.get(coords)[yReg];
            return rad == null ? 0.0f : rad.floatValue();
        }
        return 0.0f;
    }

    @Override
    public void setRadiation(World world, int x, int y, int z, float rad) {
        ThreeDimRadiationPerWorld radWorld = this.perWorld.get(world);
        if (radWorld != null && world.func_72899_e(x, 0, z)) {
            ChunkCoordIntPair coords = new ChunkCoordIntPair(x >> 4, z >> 4);
            int yReg = MathHelper.func_76125_a((int)(y >> 4), (int)0, (int)15);
            if (radWorld.radiation.containsKey(coords)) {
                radWorld.radiation.get((Object)coords)[yReg] = Float.valueOf(rad);
            }
            world.func_72938_d((int)x, (int)z).field_76643_l = true;
        }
    }

    @Override
    public void incrementRad(World world, int x, int y, int z, float rad) {
        this.setRadiation(world, x, y, z, this.getRadiation(world, x, y, z) + rad);
    }

    @Override
    public void decrementRad(World world, int x, int y, int z, float rad) {
        this.setRadiation(world, x, y, z, Math.max(this.getRadiation(world, x, y, z) - rad, 0.0f));
    }

    @Override
    @Untested
    public void updateSystem() {
        for (Map.Entry<World, ThreeDimRadiationPerWorld> entry : this.perWorld.entrySet()) {
            Map<ChunkCoordIntPair, Float[]> radiation = entry.getValue().radiation;
            HashMap<ChunkCoordIntPair, Float[]> buff = new HashMap<ChunkCoordIntPair, Float[]>(radiation);
            radiation.clear();
            for (Map.Entry chunk : buff.entrySet()) {
                ChunkCoordIntPair coord = (ChunkCoordIntPair)chunk.getKey();
                for (int y = 0; y < 16; ++y) {
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                int type = Math.abs(i) + Math.abs(j) + Math.abs(k);
                                if (type == 3) continue;
                                float percent = type == 0 ? 0.6f : (type == 1 ? 0.075f : 0.025f);
                                ChunkCoordIntPair newCoord = new ChunkCoordIntPair(coord.field_77276_a + i, coord.field_77275_b + k);
                                if (!buff.containsKey(newCoord)) continue;
                                int newY = MathHelper.func_76125_a((int)(y + j), (int)0, (int)15);
                                Float[] vals = radiation.get(newCoord);
                                float newRad = vals[newY].floatValue() + ((Float[])chunk.getValue())[newY].floatValue() * percent;
                                vals[newY] = Float.valueOf(Math.max(0.0f, newRad * 0.999f - 0.05f));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void clearSystem(World world) {
        ThreeDimRadiationPerWorld radWorld = this.perWorld.get(world);
        if (radWorld != null) {
            radWorld.radiation.clear();
        }
    }

    @Override
    public void receiveWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            this.perWorld.put(event.world, new ThreeDimRadiationPerWorld());
        }
    }

    @Override
    public void receiveWorldUnload(WorldEvent.Unload event) {
        if (!event.world.field_72995_K) {
            this.perWorld.remove(event.world);
        }
    }

    @Override
    public void receiveChunkLoad(ChunkDataEvent.Load event) {
        ThreeDimRadiationPerWorld radWorld;
        if (!event.world.field_72995_K && (radWorld = this.perWorld.get(event.world)) != null) {
            Float[] vals = new Float[16];
            for (int i = 0; i < 16; ++i) {
                vals[i] = Float.valueOf(event.getData().func_74760_g(NBT_KEY_CHUNK_RADIATION + i));
            }
            radWorld.radiation.put(event.getChunk().func_76632_l(), vals);
        }
    }

    @Override
    public void receiveChunkSave(ChunkDataEvent.Save event) {
        ThreeDimRadiationPerWorld radWorld;
        if (!event.world.field_72995_K && (radWorld = this.perWorld.get(event.world)) != null) {
            Float[] vals = radWorld.radiation.get(event.getChunk().func_76632_l());
            for (int i = 0; i < 16; ++i) {
                float rad = vals[i] == null ? 0.0f : vals[i].floatValue();
                event.getData().func_74776_a(NBT_KEY_CHUNK_RADIATION + i, rad);
            }
        }
    }

    @Override
    public void receiveChunkUnload(ChunkEvent.Unload event) {
        ThreeDimRadiationPerWorld radWorld;
        if (!event.world.field_72995_K && (radWorld = this.perWorld.get(event.world)) != null) {
            radWorld.radiation.remove(event.getChunk());
        }
    }

    public static class ThreeDimRadiationPerWorld {
        public Map<ChunkCoordIntPair, Float[]> radiation = new HashMap<ChunkCoordIntPair, Float[]>();
    }
}

