/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import api.hbm.entity.RadarEntry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.machine.TileEntityMachineRadarNT;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class GUIMachineRadarNT
extends GuiScreen {
    public static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/machine/gui_radar_nt.png");
    protected TileEntityMachineRadarNT radar;
    protected int xSize = 216;
    protected int ySize = 234;
    protected int guiLeft;
    protected int guiTop;
    public int lastMouseX;
    public int lastMouseY;

    public GUIMachineRadarNT(TileEntityMachineRadarNT tile) {
        this.radar = tile;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    protected void func_73864_a(int x, int y, int i) {
        super.func_73864_a(x, y, i);
        String cmd = null;
        if (this.checkClick(x, y, -10, 88, 8, 8)) {
            cmd = "missiles";
        }
        if (this.checkClick(x, y, -10, 98, 8, 8)) {
            cmd = "shells";
        }
        if (this.checkClick(x, y, -10, 108, 8, 8)) {
            cmd = "players";
        }
        if (this.checkClick(x, y, -10, 118, 8, 8)) {
            cmd = "smart";
        }
        if (this.checkClick(x, y, -10, 128, 8, 8)) {
            cmd = "red";
        }
        if (this.checkClick(x, y, -10, 138, 8, 8)) {
            cmd = "map";
        }
        if (this.checkClick(x, y, -10, 158, 8, 8)) {
            cmd = "gui1";
        }
        if (this.checkClick(x, y, -10, 178, 8, 8)) {
            cmd = "clear";
        }
        if (cmd != null) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a(cmd, true);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.radar.field_145851_c, this.radar.field_145848_d, this.radar.field_145849_e));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GL11.glEnable((int)2896);
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    private void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        if (this.checkClick(mouseX, mouseY, 8, 221, 200, 7)) {
            String[] stringArray = new String[1];
            stringArray[0] = BobMathUtil.getShortNumber(this.radar.power) + "/" + BobMathUtil.getShortNumber(TileEntityMachineRadarNT.maxPower) + "HE";
            this.func_146283_a(Arrays.asList(stringArray), mouseX, mouseY);
        }
        if (this.checkClick(mouseX, mouseY, -10, 88, 8, 8)) {
            this.func_146283_a(Arrays.asList(I18nUtil.resolveKeyArray("radar.detectMissiles", new Object[0])), mouseX, mouseY);
        }
        if (this.checkClick(mouseX, mouseY, -10, 98, 8, 8)) {
            this.func_146283_a(Arrays.asList(I18nUtil.resolveKeyArray("radar.detectShells", new Object[0])), mouseX, mouseY);
        }
        if (this.checkClick(mouseX, mouseY, -10, 108, 8, 8)) {
            this.func_146283_a(Arrays.asList(I18nUtil.resolveKeyArray("radar.detectPlayers", new Object[0])), mouseX, mouseY);
        }
        if (this.checkClick(mouseX, mouseY, -10, 118, 8, 8)) {
            this.func_146283_a(Arrays.asList(I18nUtil.resolveKeyArray("radar.smartMode", new Object[0])), mouseX, mouseY);
        }
        if (this.checkClick(mouseX, mouseY, -10, 128, 8, 8)) {
            this.func_146283_a(Arrays.asList(I18nUtil.resolveKeyArray("radar.redMode", new Object[0])), mouseX, mouseY);
        }
        if (this.checkClick(mouseX, mouseY, -10, 138, 8, 8)) {
            this.func_146283_a(Arrays.asList(I18nUtil.resolveKeyArray("radar.showMap", new Object[0])), mouseX, mouseY);
        }
        if (this.checkClick(mouseX, mouseY, -10, 158, 8, 8)) {
            this.func_146283_a(Arrays.asList(I18nUtil.resolveKeyArray("radar.toggleGui", new Object[0])), mouseX, mouseY);
        }
        if (this.checkClick(mouseX, mouseY, -10, 178, 8, 8)) {
            this.func_146283_a(Arrays.asList(I18nUtil.resolveKeyArray("radar.clearMap", new Object[0])), mouseX, mouseY);
        }
        if (!this.radar.entries.isEmpty()) {
            for (RadarEntry m : this.radar.entries) {
                int x = this.guiLeft + (int)((double)(m.posX - this.radar.field_145851_c) / ((double)this.radar.getRange() * 2.0 + 1.0) * 192.0) + 108;
                int z = this.guiTop + (int)((double)(m.posZ - this.radar.field_145849_e) / ((double)this.radar.getRange() * 2.0 + 1.0) * 192.0) + 117;
                if (mouseX + 5 <= x || mouseX - 4 > x || mouseY + 5 <= z || mouseY - 4 > z) continue;
                String[] text = new String[]{I18nUtil.resolveKey(m.unlocalizedName, new Object[0]), m.posX + " / " + m.posZ, "Alt.: " + m.posY};
                this.func_146283_a(Arrays.asList(text), x, z);
                return;
            }
        }
        if (this.checkClick(mouseX, mouseY, 8, 17, 200, 200)) {
            int tX = (int)((double)(this.lastMouseX - this.guiLeft - 108) * ((double)this.radar.getRange() * 2.0 + 1.0) / 192.0 + (double)this.radar.field_145851_c);
            int tZ = (int)((double)(this.lastMouseY - this.guiTop - 117) * ((double)this.radar.getRange() * 2.0 + 1.0) / 192.0 + (double)this.radar.field_145849_e);
            this.func_146283_a(Arrays.asList(tX + " / " + tZ), this.lastMouseX, this.lastMouseY);
        }
    }

    private void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.func_73729_b(this.guiLeft - 14, this.guiTop + 84, 224, 0, 14, 66);
        this.func_73729_b(this.guiLeft - 14, this.guiTop + 154, 224, 66, 14, 36);
        if (this.radar.power > 0L) {
            i = (int)(this.radar.power * 200L / (long)TileEntityMachineRadarNT.maxPower);
            this.func_73729_b(this.guiLeft + 8, this.guiTop + 221, 0, 234, i, 16);
        }
        if (this.radar.scanMissiles ^ (this.radar.jammed && this.radar.func_145831_w().field_73012_v.nextBoolean())) {
            this.func_73729_b(this.guiLeft - 10, this.guiTop + 88, 238, 4, 8, 8);
        }
        if (this.radar.scanShells ^ (this.radar.jammed && this.radar.func_145831_w().field_73012_v.nextBoolean())) {
            this.func_73729_b(this.guiLeft - 10, this.guiTop + 98, 238, 14, 8, 8);
        }
        if (this.radar.scanPlayers ^ (this.radar.jammed && this.radar.func_145831_w().field_73012_v.nextBoolean())) {
            this.func_73729_b(this.guiLeft - 10, this.guiTop + 108, 238, 24, 8, 8);
        }
        if (this.radar.smartMode ^ (this.radar.jammed && this.radar.func_145831_w().field_73012_v.nextBoolean())) {
            this.func_73729_b(this.guiLeft - 10, this.guiTop + 118, 238, 34, 8, 8);
        }
        if (this.radar.redMode ^ (this.radar.jammed && this.radar.func_145831_w().field_73012_v.nextBoolean())) {
            this.func_73729_b(this.guiLeft - 10, this.guiTop + 128, 238, 44, 8, 8);
        }
        if (this.radar.showMap ^ (this.radar.jammed && this.radar.func_145831_w().field_73012_v.nextBoolean())) {
            this.func_73729_b(this.guiLeft - 10, this.guiTop + 138, 238, 54, 8, 8);
        }
        if (this.radar.power < (long)TileEntityMachineRadarNT.consumption) {
            return;
        }
        if (this.radar.jammed) {
            for (i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    this.func_73729_b(this.guiLeft + 8 + i * 40, this.guiTop + 17 + j * 40, 216, 118 + this.radar.func_145831_w().field_73012_v.nextInt(81), 40, 40);
                }
            }
            return;
        }
        if (this.radar.showMap) {
            Tessellator tess = Tessellator.field_78398_a;
            GL11.glDisable((int)3553);
            tess.func_78382_b();
            for (int i2 = 0; i2 < 40000; ++i2) {
                int iX = i2 % 200;
                int iZ = i2 / 200;
                byte b = this.radar.map[i2];
                if (b <= 0) continue;
                int color = (b - 50) * 255 / 78 << 8;
                tess.func_78378_d(color);
                tess.func_78377_a((double)(this.guiLeft + 8 + iX), (double)(this.guiTop + 18 + iZ), (double)this.field_73735_i);
                tess.func_78377_a((double)(this.guiLeft + 9 + iX), (double)(this.guiTop + 18 + iZ), (double)this.field_73735_i);
                tess.func_78377_a((double)(this.guiLeft + 9 + iX), (double)(this.guiTop + 17 + iZ), (double)this.field_73735_i);
                tess.func_78377_a((double)(this.guiLeft + 8 + iX), (double)(this.guiTop + 17 + iZ), (double)this.field_73735_i);
            }
            tess.func_78381_a();
            GL11.glEnable((int)3553);
        }
        Vec3 tr = Vec3.func_72443_a((double)100.0, (double)0.0, (double)0.0);
        Vec3 tl = Vec3.func_72443_a((double)100.0, (double)0.0, (double)0.0);
        Vec3 bl = Vec3.func_72443_a((double)0.0, (double)-5.0, (double)0.0);
        float rot = (float)(-Math.toRadians(this.radar.prevRotation + (this.radar.rotation - this.radar.prevRotation) * f + 180.0f));
        tr.func_72446_c(rot);
        tl.func_72446_c(rot + 0.25f);
        bl.func_72446_c(rot);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78384_a(65280, 0);
        tess.func_78377_a((double)(this.guiLeft + 108), (double)(this.guiTop + 117), (double)this.field_73735_i);
        tess.func_78384_a(65280, 255);
        tess.func_78377_a((double)(this.guiLeft + 108) + tr.field_72450_a, (double)(this.guiTop + 117) + tr.field_72448_b, (double)this.field_73735_i);
        tess.func_78384_a(65280, 0);
        tess.func_78377_a((double)(this.guiLeft + 108) + tl.field_72450_a, (double)(this.guiTop + 117) + tl.field_72448_b, (double)this.field_73735_i);
        tess.func_78384_a(65280, 0);
        tess.func_78377_a((double)(this.guiLeft + 108) + bl.field_72450_a, (double)(this.guiTop + 117) + bl.field_72448_b, (double)this.field_73735_i);
        tess.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glShadeModel((int)7424);
        if (!this.radar.entries.isEmpty()) {
            for (RadarEntry m : this.radar.entries) {
                double x = (double)(m.posX - this.radar.field_145851_c) / ((double)this.radar.getRange() * 2.0 + 1.0) * 192.0 - 4.0;
                double z = (double)(m.posZ - this.radar.field_145849_e) / ((double)this.radar.getRange() * 2.0 + 1.0) * 192.0 - 4.0;
                int t = m.blipLevel;
                this.drawTexturedModalRectDouble((double)(this.guiLeft + 108) + x, (double)(this.guiTop + 117) + z, 216, 8 * t, 8, 8);
            }
        }
    }

    public void drawTexturedModalRectDouble(double x, double y, int sourceX, int sourceY, int sizeX, int sizeY) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x, y + (double)sizeY, (double)this.field_73735_i, (double)((float)(sourceX + 0) * f), (double)((float)(sourceY + sizeY) * f1));
        tessellator.func_78374_a(x + (double)sizeX, y + (double)sizeY, (double)this.field_73735_i, (double)((float)(sourceX + sizeX) * f), (double)((float)(sourceY + sizeY) * f1));
        tessellator.func_78374_a(x + (double)sizeX, y, (double)this.field_73735_i, (double)((float)(sourceX + sizeX) * f), (double)((float)(sourceY + 0) * f1));
        tessellator.func_78374_a(x, y, (double)this.field_73735_i, (double)((float)(sourceX + 0) * f), (double)((float)(sourceY + 0) * f1));
        tessellator.func_78381_a();
    }

    protected boolean checkClick(int x, int y, int left, int top, int sizeX, int sizeY) {
        return this.guiLeft + left <= x && this.guiLeft + left + sizeX > x && this.guiTop + top < y && this.guiTop + top + sizeY >= y;
    }

    protected void func_73869_a(char c, int key) {
        if (key == 1 || key == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (this.checkClick(this.lastMouseX, this.lastMouseY, 8, 17, 200, 200) && c >= '1' && c <= '8') {
            int id = c - 49;
            if (!this.radar.entries.isEmpty()) {
                for (RadarEntry m : this.radar.entries) {
                    int x = this.guiLeft + (int)((double)(m.posX - this.radar.field_145851_c) / ((double)this.radar.getRange() * 2.0 + 1.0) * 192.0) + 108;
                    int z = this.guiTop + (int)((double)(m.posZ - this.radar.field_145849_e) / ((double)this.radar.getRange() * 2.0 + 1.0) * 192.0) + 117;
                    if (this.lastMouseX + 5 <= x || this.lastMouseX - 4 > x || this.lastMouseY + 5 <= z || this.lastMouseY - 4 > z) continue;
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74768_a("launchEntity", m.entityID);
                    data.func_74768_a("link", id);
                    PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.radar.field_145851_c, this.radar.field_145848_d, this.radar.field_145849_e));
                    return;
                }
            }
            int tX = (int)((double)(this.lastMouseX - this.guiLeft - 108) * ((double)this.radar.getRange() * 2.0 + 1.0) / 192.0 + (double)this.radar.field_145851_c);
            int tZ = (int)((double)(this.lastMouseY - this.guiTop - 117) * ((double)this.radar.getRange() * 2.0 + 1.0) / 192.0 + (double)this.radar.field_145849_e);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("launchPosX", tX);
            data.func_74768_a("launchPosZ", tZ);
            data.func_74768_a("link", id);
            PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.radar.field_145851_c, this.radar.field_145848_d, this.radar.field_145849_e));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.field_146297_k.field_71439_g.func_70089_S() || this.field_146297_k.field_71439_g.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }
}

