/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ExposureChamberRecipes
extends SerializableRecipe {
    public static List<ExposureChamberRecipe> recipes = new ArrayList<ExposureChamberRecipe>();

    @Override
    public void registerDefaults() {
        recipes.add(new ExposureChamberRecipe(new RecipesCommon.ComparableStack(ModItems.particle_higgs), new RecipesCommon.OreDictStack(OreDictManager.U.ingot()), new ItemStack(ModItems.ingot_schraranium)));
        recipes.add(new ExposureChamberRecipe(new RecipesCommon.ComparableStack(ModItems.particle_higgs), new RecipesCommon.OreDictStack(OreDictManager.U238.ingot()), new ItemStack(ModItems.ingot_schrabidium)));
        recipes.add(new ExposureChamberRecipe(new RecipesCommon.ComparableStack(ModItems.particle_dark), new RecipesCommon.OreDictStack(OreDictManager.PU.ingot()), new ItemStack(ModItems.ingot_euphemium)));
        recipes.add(new ExposureChamberRecipe(new RecipesCommon.ComparableStack(ModItems.particle_sparkticle), new RecipesCommon.OreDictStack(OreDictManager.SBD.ingot()), new ItemStack(ModItems.ingot_dineutronium)));
    }

    public static ExposureChamberRecipe getRecipe(ItemStack particle, ItemStack input) {
        for (ExposureChamberRecipe recipe : recipes) {
            if (!recipe.particle.matchesRecipe(particle, true) || !recipe.ingredient.matchesRecipe(input, true)) continue;
            return recipe;
        }
        return null;
    }

    public static HashMap getRecipes() {
        HashMap<Object[], ItemStack> recipes = new HashMap<Object[], ItemStack>();
        for (ExposureChamberRecipe recipe : ExposureChamberRecipes.recipes) {
            Object[] array = new Object[2];
            array[1] = recipe.particle;
            RecipesCommon.AStack stack = recipe.ingredient.copy();
            stack.stacksize = 8;
            array[0] = stack;
            ItemStack output = recipe.output.func_77946_l();
            output.field_77994_a = 8;
            recipes.put(array, output);
        }
        return recipes;
    }

    @Override
    public String getFileName() {
        return "hbmExposureChamber.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack particle = ExposureChamberRecipes.readAStack(obj.get("particle").getAsJsonArray());
        RecipesCommon.AStack ingredient = ExposureChamberRecipes.readAStack(obj.get("ingredient").getAsJsonArray());
        ItemStack output = ExposureChamberRecipes.readItemStack(obj.get("output").getAsJsonArray());
        ExposureChamberRecipe rec = new ExposureChamberRecipe(particle, ingredient, output);
        recipes.add(rec);
    }

    @Override
    public void writeRecipe(Object o, JsonWriter writer) throws IOException {
        ExposureChamberRecipe recipe = (ExposureChamberRecipe)o;
        writer.name("particle");
        ExposureChamberRecipes.writeAStack(recipe.particle, writer);
        writer.name("ingredient");
        ExposureChamberRecipes.writeAStack(recipe.ingredient, writer);
        writer.name("output");
        ExposureChamberRecipes.writeItemStack(recipe.output, writer);
    }

    public static class ExposureChamberRecipe {
        public RecipesCommon.AStack particle;
        public RecipesCommon.AStack ingredient;
        public ItemStack output;

        public ExposureChamberRecipe(RecipesCommon.AStack particle, RecipesCommon.AStack ingredient, ItemStack output) {
            this.particle = particle;
            this.ingredient = ingredient;
            this.output = output;
        }
    }
}

