/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class OutgasserRecipes
extends SerializableRecipe {
    public static Map<RecipesCommon.AStack, Tuple.Pair<ItemStack, FluidStack>> recipes = new HashMap<RecipesCommon.AStack, Tuple.Pair<ItemStack, FluidStack>>();

    @Override
    public void registerDefaults() {
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.LI.block()), new Tuple.Pair<Object, FluidStack>(null, new FluidStack(Fluids.TRITIUM, 10000)));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.LI.ingot()), new Tuple.Pair<Object, FluidStack>(null, new FluidStack(Fluids.TRITIUM, 1000)));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.LI.dust()), new Tuple.Pair<Object, FluidStack>(null, new FluidStack(Fluids.TRITIUM, 1000)));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.LI.dustTiny()), new Tuple.Pair<Object, FluidStack>(null, new FluidStack(Fluids.TRITIUM, 100)));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.GOLD.ingot()), new Tuple.Pair<ItemStack, Object>(new ItemStack(ModItems.ingot_au198), null));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.GOLD.nugget()), new Tuple.Pair<ItemStack, Object>(new ItemStack(ModItems.nugget_au198), null));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.GOLD.dust()), new Tuple.Pair<ItemStack, Object>(new ItemStack(ModItems.powder_au198), null));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.TH232.ingot()), new Tuple.Pair<ItemStack, Object>(new ItemStack(ModItems.ingot_thorium_fuel), null));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.TH232.nugget()), new Tuple.Pair<ItemStack, Object>(new ItemStack(ModItems.nugget_thorium_fuel), null));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.TH232.billet()), new Tuple.Pair<ItemStack, Object>(new ItemStack(ModItems.billet_thorium_fuel), null));
        recipes.put(new RecipesCommon.ComparableStack((Block)Blocks.field_150338_P), new Tuple.Pair<ItemStack, Object>(new ItemStack(ModBlocks.mush), null));
        recipes.put(new RecipesCommon.ComparableStack((Block)Blocks.field_150337_Q), new Tuple.Pair<ItemStack, Object>(new ItemStack(ModBlocks.mush), null));
        recipes.put(new RecipesCommon.ComparableStack(Items.field_151009_A), new Tuple.Pair<ItemStack, Object>(new ItemStack(ModItems.glowing_stew), null));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.COAL.gem()), new Tuple.Pair<ItemStack, FluidStack>(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.COAL, 1), new FluidStack(Fluids.SYNGAS, 50)));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.COAL.dust()), new Tuple.Pair<ItemStack, FluidStack>(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.COAL, 1), new FluidStack(Fluids.SYNGAS, 50)));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.COAL.block()), new Tuple.Pair<ItemStack, FluidStack>(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.COAL, 9), new FluidStack(Fluids.SYNGAS, 500)));
        recipes.put(new RecipesCommon.OreDictStack(OreDictManager.PVC.ingot()), new Tuple.Pair<ItemStack, FluidStack>(new ItemStack(ModItems.ingot_c4), new FluidStack(Fluids.COLLOID, 250)));
        recipes.put(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.COAL)), new Tuple.Pair<Object, FluidStack>(null, new FluidStack(Fluids.COALOIL, 100)));
        recipes.put(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.WAX)), new Tuple.Pair<Object, FluidStack>(null, new FluidStack(Fluids.RADIOSOLVENT, 100)));
    }

    public static Tuple.Pair<ItemStack, FluidStack> getOutput(ItemStack input) {
        String[] dictKeys;
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(input).makeSingular();
        if (recipes.containsKey(comp)) {
            return recipes.get(comp);
        }
        for (String key : dictKeys = comp.getDictKeys()) {
            RecipesCommon.OreDictStack dict = new RecipesCommon.OreDictStack(key);
            if (!recipes.containsKey(dict)) continue;
            return recipes.get(dict);
        }
        return null;
    }

    public static HashMap getRecipes() {
        HashMap<RecipesCommon.AStack, Object[]> recipes = new HashMap<RecipesCommon.AStack, Object[]>();
        for (Map.Entry<RecipesCommon.AStack, Tuple.Pair<ItemStack, FluidStack>> entry : OutgasserRecipes.recipes.entrySet()) {
            RecipesCommon.AStack input = entry.getKey();
            ItemStack solidOutput = entry.getValue().getKey();
            FluidStack fluidOutput = entry.getValue().getValue();
            if (solidOutput != null && fluidOutput != null) {
                recipes.put(input, new Object[]{solidOutput, ItemFluidIcon.make(fluidOutput)});
            }
            if (solidOutput != null && fluidOutput == null) {
                recipes.put(input, new Object[]{solidOutput});
            }
            if (solidOutput != null || fluidOutput == null) continue;
            recipes.put(input, new Object[]{ItemFluidIcon.make(fluidOutput)});
        }
        return recipes;
    }

    @Override
    public String getFileName() {
        return "hbmIrradiation.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack input = OutgasserRecipes.readAStack(obj.get("input").getAsJsonArray());
        ItemStack solidOutput = null;
        FluidStack fluidOutput = null;
        if (obj.has("solidOutput")) {
            solidOutput = OutgasserRecipes.readItemStack(obj.get("solidOutput").getAsJsonArray());
        }
        if (obj.has("fluidOutput")) {
            fluidOutput = OutgasserRecipes.readFluidStack(obj.get("fluidOutput").getAsJsonArray());
        }
        if (solidOutput != null || fluidOutput != null) {
            recipes.put(input, new Tuple.Pair<ItemStack, FluidStack>(solidOutput, fluidOutput));
        }
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        writer.name("input");
        OutgasserRecipes.writeAStack((RecipesCommon.AStack)rec.getKey(), writer);
        if (((Tuple.Pair)rec.getValue()).getKey() != null) {
            writer.name("solidOutput");
            OutgasserRecipes.writeItemStack((ItemStack)((Tuple.Pair)rec.getValue()).getKey(), writer);
        }
        if (((Tuple.Pair)rec.getValue()).getValue() != null) {
            writer.name("fluidOutput");
            OutgasserRecipes.writeFluidStack((FluidStack)((Tuple.Pair)rec.getValue()).getValue(), writer);
        }
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }
}

