/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import api.hbm.item.IGasMask;
import com.hbm.items.ModItems;
import com.hbm.render.model.ModelGasMask;
import com.hbm.render.model.ModelM65;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.ArmorUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ArmorGasMask
extends ItemArmor
implements IGasMask {
    @SideOnly(value=Side.CLIENT)
    private ModelGasMask modelGas;
    @SideOnly(value=Side.CLIENT)
    private ModelM65 modelM65;
    private ResourceLocation[] googleBlur = new ResourceLocation[]{new ResourceLocation("hbm:textures/misc/overlay_goggles_0.png"), new ResourceLocation("hbm:textures/misc/overlay_goggles_1.png"), new ResourceLocation("hbm:textures/misc/overlay_goggles_2.png"), new ResourceLocation("hbm:textures/misc/overlay_goggles_3.png"), new ResourceLocation("hbm:textures/misc/overlay_goggles_4.png"), new ResourceLocation("hbm:textures/misc/overlay_goggles_5.png")};
    private ResourceLocation[] maskBlur = new ResourceLocation[]{new ResourceLocation("hbm:textures/misc/overlay_gasmask_0.png"), new ResourceLocation("hbm:textures/misc/overlay_gasmask_1.png"), new ResourceLocation("hbm:textures/misc/overlay_gasmask_2.png"), new ResourceLocation("hbm:textures/misc/overlay_gasmask_3.png"), new ResourceLocation("hbm:textures/misc/overlay_gasmask_4.png"), new ResourceLocation("hbm:textures/misc/overlay_gasmask_5.png")};

    public ArmorGasMask() {
        super(ItemArmor.ArmorMaterial.IRON, 0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this == ModItems.gas_mask && armorSlot == 0) {
            if (this.modelGas == null) {
                this.modelGas = new ModelGasMask();
            }
            return this.modelGas;
        }
        if ((this == ModItems.gas_mask_m65 || this == ModItems.gas_mask_olde || this == ModItems.gas_mask_mono) && armorSlot == 0) {
            if (this.modelM65 == null) {
                this.modelM65 = new ModelM65();
            }
            return this.modelM65;
        }
        return null;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (stack.func_77973_b() == ModItems.gas_mask) {
            return "hbm:textures/models/GasMask.png";
        }
        if (stack.func_77973_b() == ModItems.gas_mask_m65) {
            return "hbm:textures/models/ModelM65.png";
        }
        if (stack.func_77973_b() == ModItems.gas_mask_olde) {
            return "hbm:textures/armor/mask_olde.png";
        }
        if (stack.func_77973_b() == ModItems.gas_mask_mono) {
            return "hbm:textures/models/ModelM65Mono.png";
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        int index;
        ResourceLocation tex = null;
        if (this == ModItems.goggles || this == ModItems.gas_mask_m65) {
            index = (int)((double)stack.func_77960_j() / (double)stack.func_77958_k() * 6.0);
            tex = this.googleBlur[Math.min(index, 5)];
        }
        if (this == ModItems.gas_mask) {
            index = (int)((double)stack.func_77960_j() / (double)stack.func_77958_k() * 6.0);
            tex = this.maskBlur[Math.min(index, 5)];
        }
        if (tex == null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(tex);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)resolution.func_78328_b(), -90.0, 0.0, 1.0);
        tessellator.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), -90.0, 1.0, 1.0);
        tessellator.func_78374_a((double)resolution.func_78326_a(), 0.0, -90.0, 1.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public ArrayList<ArmorRegistry.HazardClass> getBlacklist(ItemStack stack, EntityLivingBase entity) {
        if (this == ModItems.gas_mask_mono) {
            return new ArrayList<ArmorRegistry.HazardClass>(Arrays.asList(ArmorRegistry.HazardClass.GAS_LUNG, ArmorRegistry.HazardClass.GAS_BLISTERING, ArmorRegistry.HazardClass.BACTERIA));
        }
        return new ArrayList<ArmorRegistry.HazardClass>(Arrays.asList(ArmorRegistry.HazardClass.GAS_BLISTERING));
    }

    @Override
    public ItemStack getFilter(ItemStack stack, EntityLivingBase entity) {
        return ArmorUtil.getGasMaskFilter(stack);
    }

    @Override
    public void installFilter(ItemStack stack, EntityLivingBase entity, ItemStack filter) {
        ArmorUtil.installGasMaskFilter(stack, filter);
    }

    @Override
    public void damageFilter(ItemStack stack, EntityLivingBase entity, int damage) {
        ArmorUtil.damageGasMaskFilter(stack, damage);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        ArmorUtil.addGasMaskTooltip(stack, player, list, ext);
        ArrayList<ArmorRegistry.HazardClass> haz = this.getBlacklist(stack, (EntityLivingBase)player);
        if (!haz.isEmpty()) {
            list.add(EnumChatFormatting.RED + I18nUtil.resolveKey("hazard.neverProtects", new Object[0]));
            for (ArmorRegistry.HazardClass clazz : haz) {
                list.add(EnumChatFormatting.DARK_RED + " -" + I18nUtil.resolveKey(clazz.lang, new Object[0]));
            }
        }
    }

    @Override
    public boolean isFilterApplicable(ItemStack stack, EntityLivingBase entity, ItemStack filter) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ItemStack filter;
        if (player.func_70093_af() && (filter = this.getFilter(stack, (EntityLivingBase)player)) != null) {
            ArmorUtil.removeFilter(stack);
            if (!player.field_71071_by.func_70441_a(filter)) {
                player.func_71019_a(filter, true);
            }
            return stack;
        }
        return super.func_77659_a(stack, world, player);
    }
}

