/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.items.ItemEnumMulti;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.render.icon.RGBMutatorInterpolatedComponentRemap;
import com.hbm.render.icon.TextureAtlasSpriteMutatable;
import com.hbm.util.EnumUtil;
import com.hbm.util.function.Function;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemWatzPellet
extends ItemEnumMulti {
    public ItemWatzPellet() {
        super(EnumWatzType.class, true, true);
        this.func_77625_d(16);
        this.func_77637_a(MainRegistry.controlTab);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        Enum[] enums = (Enum[])this.theEnum.getEnumConstants();
        this.icons = new IIcon[enums.length];
        if (reg instanceof TextureMap) {
            TextureMap map = (TextureMap)reg;
            for (int i = 0; i < EnumWatzType.values().length; ++i) {
                EnumWatzType type = EnumWatzType.values()[i];
                String placeholderName = this.func_111208_A() + "-" + type.name() + this.func_77658_a();
                int light = this == ModItems.watz_pellet_depleted ? ItemWatzPellet.desaturate(type.colorLight) : type.colorLight;
                int dark = this == ModItems.watz_pellet_depleted ? ItemWatzPellet.desaturate(type.colorDark) : type.colorDark;
                TextureAtlasSpriteMutatable mutableIcon = new TextureAtlasSpriteMutatable(placeholderName, new RGBMutatorInterpolatedComponentRemap(0xD2D2D2, 0x333333, light, dark));
                map.setTextureEntry(placeholderName, (TextureAtlasSprite)mutableIcon);
                this.icons[i] = mutableIcon;
            }
        }
        this.field_77791_bV = reg.func_94245_a(this.func_111208_A());
    }

    public static int desaturate(int color) {
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        int avg = (r + g + b) / 3;
        double approach = 0.9;
        double mult = 0.75;
        r = (int)((double)r - (double)(r - avg) * approach);
        g = (int)((double)g - (double)(g - avg) * approach);
        b = (int)((double)b - (double)(b - avg) * approach);
        r = (int)((double)r * mult);
        g = (int)((double)g * mult);
        b = (int)((double)b * mult);
        return r << 16 | g << 8 | b;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        IIcon icon = super.func_77617_a(meta);
        return icon == null ? this.field_77791_bV : icon;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (this != ModItems.watz_pellet) {
            return;
        }
        EnumWatzType num = (EnumWatzType)((Object)EnumUtil.grabEnumSafely(EnumWatzType.class, stack.func_77960_j()));
        list.add(EnumChatFormatting.GREEN + "Depletion: " + String.format(Locale.US, "%.1f", this.getDurabilityForDisplay(stack) * 100.0) + "%");
        String color = EnumChatFormatting.GOLD + "";
        String reset = EnumChatFormatting.RESET + "";
        if (num.passive > 0.0) {
            list.add(color + "Base fission rate: " + reset + num.passive);
            list.add(EnumChatFormatting.RED + "Self-igniting!");
        }
        if (num.heatEmission > 0.0) {
            list.add(color + "Heat per flux: " + reset + num.heatEmission + " TU");
        }
        if (num.burnFunc != null) {
            list.add(color + "Reaction function: " + reset + num.burnFunc.getLabelForFuel());
            list.add(color + "Fuel type: " + reset + num.burnFunc.getDangerFromFuel());
        }
        if (num.heatDiv != null) {
            list.add(color + "Thermal multiplier: " + reset + num.heatDiv.getLabelForFuel() + " TU\u207b\u00b9");
        }
        if (num.absorbFunc != null) {
            list.add(color + "Flux capture: " + reset + num.absorbFunc.getLabelForFuel());
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this == ModItems.watz_pellet && this.getDurabilityForDisplay(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemWatzPellet.getEnrichment(stack);
    }

    public static double getEnrichment(ItemStack stack) {
        EnumWatzType num = (EnumWatzType)((Object)EnumUtil.grabEnumSafely(EnumWatzType.class, stack.func_77960_j()));
        return ItemWatzPellet.getYield(stack) / num.yield;
    }

    public static double getYield(ItemStack stack) {
        return ItemWatzPellet.getDouble(stack, "yield");
    }

    public static void setYield(ItemStack stack, double yield) {
        ItemWatzPellet.setDouble(stack, "yield", yield);
    }

    public static void setDouble(ItemStack stack, String key, double yield) {
        if (!stack.func_77942_o()) {
            ItemWatzPellet.setNBTDefaults(stack);
        }
        stack.field_77990_d.func_74780_a(key, yield);
    }

    public static double getDouble(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            ItemWatzPellet.setNBTDefaults(stack);
        }
        return stack.field_77990_d.func_74769_h(key);
    }

    private static void setNBTDefaults(ItemStack stack) {
        EnumWatzType num = (EnumWatzType)((Object)EnumUtil.grabEnumSafely(EnumWatzType.class, stack.func_77960_j()));
        stack.field_77990_d = new NBTTagCompound();
        ItemWatzPellet.setYield(stack, num.yield);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (this != ModItems.watz_pellet) {
            return;
        }
        ItemWatzPellet.setNBTDefaults(stack);
    }

    public static enum EnumWatzType {
        SCHRABIDIUM(0x32FFFF, 23644, 2000.0, 20.0, 0.01, new Function.FunctionLinear(1.5), new Function.FunctionSqrtFalling(10.0), null),
        HES(0x66DCD6, 145715, 1750.0, 20.0, 0.005, new Function.FunctionLinear(1.25), new Function.FunctionSqrtFalling(15.0), null),
        MES(13363935, 2639676, 1500.0, 15.0, 0.0025, new Function.FunctionLinear(1.15), new Function.FunctionSqrtFalling(15.0), null),
        LES(11252904, 790789, 1250.0, 15.0, 0.00125, new Function.FunctionLinear(1.0), new Function.FunctionSqrtFalling(20.0), null),
        HEN(10924710, 200451, 0.0, 10.0, 5.0E-4, new Function.FunctionSqrt(100.0), new Function.FunctionSqrtFalling(10.0), null),
        MEU(12699581, 2830887, 0.0, 10.0, 5.0E-4, new Function.FunctionSqrt(75.0), new Function.FunctionSqrtFalling(10.0), null),
        MEP(10134432, 0x111A17, 0.0, 15.0, 5.0E-4, new Function.FunctionSqrt(150.0), new Function.FunctionSqrtFalling(10.0), null),
        LEAD(10921650, 197391, 0.0, 0.0, 0.0025, null, null, new Function.FunctionSqrt(10.0)),
        BORON(12437714, 2700350, 0.0, 0.0, 0.0025, null, null, new Function.FunctionLinear(10.0)),
        DU(12699581, 2830887, 0.0, 0.0, 0.0025, null, null, new Function.FunctionQuadratic(1.0, 1.0).withDiv(100.0)),
        NQD(0x4B4B4B, 0x121212, 2000.0, 20.0, 0.01, new Function.FunctionLinear(2.0), new Function.FunctionSqrt(0.04).withOff(625.0), null),
        NQR(0x2D2D2D, 723723, 2500.0, 30.0, 0.01, new Function.FunctionLinear(1.5), new Function.FunctionSqrt(0.04).withOff(625.0), null);

        public double yield = 5.0E8;
        public int colorLight;
        public int colorDark;
        public double mudContent;
        public double passive;
        public double heatEmission;
        public Function burnFunc;
        public Function heatDiv;
        public Function absorbFunc;

        private EnumWatzType(int colorLight, int colorDark, double passive, double heatEmission, double mudContent, Function burnFunction, Function heatDivisor, Function absorbFunction) {
            this.colorLight = colorLight;
            this.colorDark = colorDark;
            this.passive = passive;
            this.heatEmission = heatEmission;
            this.mudContent = mudContent / 2.0;
            this.burnFunc = burnFunction;
            this.heatDiv = heatDivisor;
            this.absorbFunc = absorbFunction;
        }
    }
}

