/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.impl;

import com.hbm.items.ICustomizable;
import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.mods.XWeaponModManager;
import com.hbm.util.ChatBuilder;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemGunNI4NI
extends ItemGunBaseNT
implements ICustomizable {
    public static final String KEY_COIN_COUNT = "coincount";
    public static final String KEY_COIN_CHARGE = "coincharge";

    public ItemGunNI4NI(ItemGunBaseNT.WeaponQuality quality, GunConfig ... cfg) {
        super(quality, cfg);
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        super.func_77663_a(stack, world, entity, slot, isHeld);
        if (!world.field_72995_K) {
            int maxCoin = 4;
            if (XWeaponModManager.hasUpgrade(stack, 0, 220)) {
                maxCoin += 2;
            }
            if (XWeaponModManager.hasUpgrade(stack, 0, 221)) {
                maxCoin += 2;
            }
            if (ItemGunNI4NI.getCoinCount(stack) < maxCoin) {
                ItemGunNI4NI.setCoinCharge(stack, ItemGunNI4NI.getCoinCharge(stack) + 1);
                if (ItemGunNI4NI.getCoinCharge(stack) >= 80) {
                    ItemGunNI4NI.setCoinCharge(stack, 0);
                    int newCount = ItemGunNI4NI.getCoinCount(stack) + 1;
                    ItemGunNI4NI.setCoinCount(stack, newCount);
                    if (isHeld) {
                        world.func_72956_a(entity, "hbm:item.techBoop", 1.0f, 1.0f + (float)newCount / (float)maxCoin);
                    }
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        list.add("Now, don't get the wrong idea.");
        list.add("I " + EnumChatFormatting.RED + "fucking hate " + EnumChatFormatting.GRAY + "this game.");
        list.add("I didn't do this for you, I did it for sea.");
        super.func_77624_a(stack, player, list, ext);
    }

    @Override
    public void customize(EntityPlayer player, ItemStack stack, String ... args) {
        if (args.length == 0) {
            ItemGunNI4NI.resetColors(stack);
            player.func_146105_b((IChatComponent)ChatBuilder.start("Colors reset!").color(EnumChatFormatting.GREEN).flush());
            return;
        }
        if (args.length != 3) {
            ItemGunNI4NI.resetColors(stack);
            player.func_146105_b((IChatComponent)ChatBuilder.start("Requires three hexadecimal colors!").color(EnumChatFormatting.RED).flush());
            return;
        }
        try {
            int dark = Integer.parseInt(args[0], 16);
            int light = Integer.parseInt(args[1], 16);
            int grip = Integer.parseInt(args[2], 16);
            if (dark < 0 || dark > 0xFFFFFF || light < 0 || light > 0xFFFFFF || grip < 0 || grip > 0xFFFFFF) {
                player.func_146105_b((IChatComponent)ChatBuilder.start("Colors must range from 0 to FFFFFF!").color(EnumChatFormatting.RED).flush());
                return;
            }
            ItemGunNI4NI.setColors(stack, dark, light, grip);
            player.func_146105_b((IChatComponent)ChatBuilder.start("Colors set!").color(EnumChatFormatting.GREEN).flush());
        }
        catch (Throwable ex) {
            player.func_146105_b((IChatComponent)ChatBuilder.start(ex.getLocalizedMessage()).color(EnumChatFormatting.RED).flush());
        }
    }

    public static void resetColors(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        stack.field_77990_d.func_82580_o("colors");
    }

    public static void setColors(ItemStack stack, int dark, int light, int grip) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74783_a("colors", new int[]{dark, light, grip});
    }

    public static int[] getColors(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.field_77990_d.func_74764_b("colors")) {
            return null;
        }
        int[] colors = stack.field_77990_d.func_74759_k("colors");
        if (colors.length != 3) {
            return null;
        }
        return colors;
    }

    public static int getCoinCount(ItemStack stack) {
        return ItemGunNI4NI.getValueInt(stack, KEY_COIN_COUNT);
    }

    public static void setCoinCount(ItemStack stack, int value) {
        ItemGunNI4NI.setValueInt(stack, KEY_COIN_COUNT, value);
    }

    public static int getCoinCharge(ItemStack stack) {
        return ItemGunNI4NI.getValueInt(stack, KEY_COIN_CHARGE);
    }

    public static void setCoinCharge(ItemStack stack, int value) {
        ItemGunNI4NI.setValueInt(stack, KEY_COIN_CHARGE, value);
    }
}

