/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.main.ModEventHandlerClient;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class ParticleFoam
extends EntityFX {
    private int age;
    public int maxAge;
    private float baseScale = 1.0f;
    private float maxScale = 1.5f;
    private List<TrailPoint> trail = new ArrayList<TrailPoint>();
    private int trailLength = 15;
    private float initialVelocity;
    private float buoyancy = 0.05f;
    private float jitter = 0.15f;
    private float drag = 0.96f;
    private int explosionPhase;

    public ParticleFoam(TextureManager p_i1213_1_, World p_i1218_1_, double p_i1218_2_, double p_i1218_4_, double p_i1218_6_) {
        super(p_i1218_1_, p_i1218_2_, p_i1218_4_, p_i1218_6_);
        this.field_70550_a = ModEventHandlerClient.particleBase;
        this.maxAge = 60 + this.field_70146_Z.nextInt(60);
        this.field_70545_g = 0.005f + this.field_70146_Z.nextFloat() * 0.015f;
        this.initialVelocity = 2.0f + this.field_70146_Z.nextFloat() * 3.0f;
        this.field_70181_x = this.initialVelocity;
        double angle = this.field_70146_Z.nextDouble() * Math.PI * 2.0;
        double strength = this.field_70146_Z.nextDouble() * 0.5;
        this.field_70159_w = Math.cos(angle) * strength;
        this.field_70179_y = Math.sin(angle) * strength;
        this.explosionPhase = 0;
        this.field_70544_f = 0.3f + this.field_70146_Z.nextFloat() * 0.7f;
    }

    public void setBaseScale(float f) {
        this.baseScale = f;
    }

    public void setMaxScale(float f) {
        this.maxScale = f;
    }

    public void setTrailLength(int length) {
        this.trailLength = length;
    }

    public void setBuoyancy(float buoyancy) {
        this.buoyancy = buoyancy;
    }

    public void func_70071_h_() {
        float phaseRatio;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.trail.add(0, new TrailPoint(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_82339_as));
        while (this.trail.size() > this.trailLength) {
            this.trail.remove(this.trail.size() - 1);
        }
        ++this.age;
        if (this.age == this.maxAge) {
            this.func_70106_y();
        }
        if ((phaseRatio = (float)this.age / (float)this.maxAge) < 0.3f) {
            this.explosionPhase = 0;
            this.field_70181_x = phaseRatio < 0.15f ? (this.field_70181_x += (double)(this.buoyancy * 6.0f)) : (this.field_70181_x += (double)(this.buoyancy * (1.0f - phaseRatio / 0.3f) * 2.0f));
            this.field_70544_f = this.baseScale + (this.maxScale - this.baseScale) * (phaseRatio / 0.3f);
        } else if (phaseRatio < 0.6f) {
            this.explosionPhase = 1;
            this.field_70181_x *= (double)0.98f;
            this.field_70544_f = this.maxScale;
        } else {
            this.explosionPhase = 2;
            this.field_70181_x -= (double)this.field_70545_g;
            this.field_70544_f = this.maxScale * (1.0f - (phaseRatio - 0.6f) / 0.4f * 0.7f);
        }
        this.field_82339_as = 0.8f * (1.0f - phaseRatio * phaseRatio);
        this.field_70159_w += (double)((this.field_70146_Z.nextFloat() - 0.5f) * this.jitter);
        this.field_70179_y += (double)((this.field_70146_Z.nextFloat() - 0.5f) * this.jitter);
        this.field_70159_w *= (double)this.drag;
        this.field_70181_x *= (double)this.drag;
        this.field_70179_y *= (double)this.drag;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.field_70122_E || this.field_70134_J) {
            this.func_70106_y();
        }
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_70539_a(Tessellator p_70539_1_, float p_70539_2_, float p_70539_3_, float p_70539_4_, float p_70539_5_, float p_70539_6_, float p_70539_7_) {
        this.renderFoamBubbles(p_70539_1_, p_70539_2_, p_70539_3_, p_70539_4_, p_70539_5_, p_70539_6_, p_70539_7_, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70544_f, this.field_82339_as);
        for (int i = 1; i < this.trail.size(); ++i) {
            TrailPoint point = this.trail.get(i);
            float trailScale = this.field_70544_f * (1.0f - (float)i / (float)this.trailLength);
            float trailAlpha = this.field_82339_as * (1.0f - (float)i / (float)this.trailLength) * 0.7f;
            this.renderFoamBubbles(p_70539_1_, p_70539_2_, p_70539_3_, p_70539_4_, p_70539_5_, p_70539_6_, p_70539_7_, point.x, point.y, point.z, trailScale, trailAlpha);
        }
    }

    private void renderFoamBubbles(Tessellator tessellator, float p_70539_2_, float p_70539_3_, float p_70539_4_, float p_70539_5_, float p_70539_6_, float p_70539_7_, double x, double y, double z, float scale, float alpha) {
        Random urandom = new Random((long)this.func_145782_y() + (long)(x * 100.0) + (long)(y * 10.0) + (long)z);
        int bubbleCount = this.explosionPhase == 0 ? 8 : (this.explosionPhase == 1 ? 6 : 4);
        for (int i = 0; i < bubbleCount; ++i) {
            float whiteness = 0.9f + urandom.nextFloat() * 0.1f;
            tessellator.func_78369_a(whiteness, whiteness, whiteness, alpha);
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            float bubbleScale = scale * (urandom.nextFloat() * 0.5f + 0.75f);
            float offset = this.explosionPhase == 0 ? 0.4f : (this.explosionPhase == 1 ? 0.6f : 0.9f);
            float pX = (float)(x - field_70556_an + urandom.nextGaussian() * (double)offset);
            float pY = (float)(y - field_70554_ao + urandom.nextGaussian() * (double)offset * (double)0.7f);
            float pZ = (float)(z - field_70555_ap + urandom.nextGaussian() * (double)offset);
            tessellator.func_78374_a((double)(pX - p_70539_3_ * bubbleScale - p_70539_6_ * bubbleScale), (double)(pY - p_70539_4_ * bubbleScale), (double)(pZ - p_70539_5_ * bubbleScale - p_70539_7_ * bubbleScale), (double)this.field_70550_a.func_94212_f(), (double)this.field_70550_a.func_94210_h());
            tessellator.func_78374_a((double)(pX - p_70539_3_ * bubbleScale + p_70539_6_ * bubbleScale), (double)(pY + p_70539_4_ * bubbleScale), (double)(pZ - p_70539_5_ * bubbleScale + p_70539_7_ * bubbleScale), (double)this.field_70550_a.func_94212_f(), (double)this.field_70550_a.func_94206_g());
            tessellator.func_78374_a((double)(pX + p_70539_3_ * bubbleScale + p_70539_6_ * bubbleScale), (double)(pY + p_70539_4_ * bubbleScale), (double)(pZ + p_70539_5_ * bubbleScale + p_70539_7_ * bubbleScale), (double)this.field_70550_a.func_94209_e(), (double)this.field_70550_a.func_94206_g());
            tessellator.func_78374_a((double)(pX + p_70539_3_ * bubbleScale - p_70539_6_ * bubbleScale), (double)(pY - p_70539_4_ * bubbleScale), (double)(pZ + p_70539_5_ * bubbleScale - p_70539_7_ * bubbleScale), (double)this.field_70550_a.func_94209_e(), (double)this.field_70550_a.func_94210_h());
        }
    }

    private static class TrailPoint {
        double x;
        double y;
        double z;

        public TrailPoint(double x, double y, double z, float alpha) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

