/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.block.ILaserable;
import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.container.ContainerCoreReceiver;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUICoreReceiver;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityCoreReceiver
extends TileEntityMachineBase
implements IEnergyProviderMK2,
ILaserable,
IFluidStandardReceiver,
SimpleComponent,
IGUIProvider,
IInfoProviderEC,
CompatHandler.OCComponent {
    public long power;
    public long joules;
    public FluidTank tank = new FluidTank(Fluids.CRYOGEL, 64000);

    public TileEntityCoreReceiver() {
        super(0);
    }

    @Override
    public String getName() {
        return "container.dfcReceiver";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.subscribeToAllAround(this.tank.getTankType(), this);
            this.power = this.joules * 5000L;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.tryProvide(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
            if (this.joules > 0L) {
                if (this.tank.getFill() >= 20) {
                    this.tank.setFill(this.tank.getFill() - 20);
                } else {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150356_k);
                    return;
                }
            }
            this.networkPackNT(50);
            this.joules = 0L;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.joules);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.joules = buf.readLong();
        this.tank.deserialize(buf);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN;
    }

    @Override
    public long getMaxPower() {
        return this.power;
    }

    @Override
    public void addEnergy(World world, int x, int y, int z, long energy, ForgeDirection dir) {
        if (dir.getOpposite().ordinal() == this.func_145832_p()) {
            this.joules += energy;
        } else {
            this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 2.5f, true);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.joules = nbt.func_74763_f("joules");
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("joules", this.joules);
        this.tank.writeToNBT(nbt, "tank");
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "dfc_receiver";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.joules, this.getPower()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCryogel(Context context, Arguments args) {
        return new Object[]{this.tank.getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.joules, this.getPower(), this.tank.getFill()};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCoreReceiver(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICoreReceiver(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74780_a("consumption", this.joules > 0L ? 20.0 : 0.0);
        data.func_74780_a("output", (double)(this.joules * 5000L));
    }
}

