/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.tileentity.TileEntityTickingBase;
import com.hbm.tileentity.machine.TileEntityICF;
import com.hbm.util.fauxpointtwelve.BlockPos;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityICFController
extends TileEntityTickingBase
implements IEnergyReceiverMK2 {
    public long power;
    public int laserLength;
    public int cellCount;
    public int emitterCount;
    public int capacitorCount;
    public int turbochargerCount;
    protected List<BlockPos> ports = new ArrayList<BlockPos>();
    public boolean assembled;
    AxisAlignedBB bb = null;

    public void setup(HashSet<BlockPos> ports, HashSet<BlockPos> cells, HashSet<BlockPos> emitters, HashSet<BlockPos> capacitors, HashSet<BlockPos> turbochargers) {
        int j;
        this.cellCount = 0;
        this.emitterCount = 0;
        this.capacitorCount = 0;
        this.turbochargerCount = 0;
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
        BlockPos pos = new BlockPos(0, 0, 0);
        HashSet<BlockPos> validCells = new HashSet<BlockPos>();
        HashSet<BlockPos> validEmitters = new HashSet<BlockPos>();
        HashSet<BlockPos> validCapacitors = new HashSet<BlockPos>();
        for (int i = 0; i < cells.size() && cells.contains(pos.mutate(this.field_145851_c + dir.offsetX * (j = i + 1), this.field_145848_d, this.field_145849_e + dir.offsetZ * j)); ++i) {
            ++this.cellCount;
            validCells.add(pos.clone());
        }
        block1: for (BlockPos emitter : emitters) {
            for (ForgeDirection offset : ForgeDirection.VALID_DIRECTIONS) {
                pos.mutate(emitter.getX() + offset.offsetX, emitter.getY() + offset.offsetY, emitter.getZ() + offset.offsetZ);
                if (!validCells.contains(pos)) continue;
                ++this.emitterCount;
                validEmitters.add(emitter.clone());
                continue block1;
            }
        }
        block3: for (BlockPos capacitor : capacitors) {
            for (ForgeDirection offset : ForgeDirection.VALID_DIRECTIONS) {
                pos.mutate(capacitor.getX() + offset.offsetX, capacitor.getY() + offset.offsetY, capacitor.getZ() + offset.offsetZ);
                if (!validEmitters.contains(pos)) continue;
                ++this.capacitorCount;
                validCapacitors.add(capacitor.clone());
                continue block3;
            }
        }
        block5: for (BlockPos turbo : turbochargers) {
            for (ForgeDirection offset : ForgeDirection.VALID_DIRECTIONS) {
                pos.mutate(turbo.getX() + offset.offsetX, turbo.getY() + offset.offsetY, turbo.getZ() + offset.offsetZ);
                if (!validCapacitors.contains(pos)) continue;
                ++this.turbochargerCount;
                continue block5;
            }
        }
        this.ports.addAll(ports);
    }

    @Override
    public String getInventoryName() {
        return "container.icfController";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.networkPackNT(50);
            if (this.assembled) {
                for (BlockPos pos : this.ports) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        BlockPos portPos = pos.offset(dir);
                        if (this.getMaxPower() <= 0L) continue;
                        this.trySubscribe(this.field_145850_b, portPos.getX(), portPos.getY(), portPos.getZ(), dir);
                    }
                }
                if (this.power > 0L) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
                    for (int i = 1; i < 50; ++i) {
                        TileEntity tile;
                        this.laserLength = i;
                        Block b = this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX * i, this.field_145848_d, this.field_145849_e + dir.offsetZ * i);
                        if (b == ModBlocks.icf && (tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX * (i + 8), this.field_145848_d - 3, this.field_145849_e + dir.offsetZ * (i + 8))) instanceof TileEntityICF) {
                            TileEntityICF icf = (TileEntityICF)tile;
                            icf.laser += this.getPower();
                            icf.maxLaser += this.getMaxPower();
                            break;
                        }
                        if (b.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c + dir.offsetX * i, this.field_145848_d, this.field_145849_e + dir.offsetZ * i)) continue;
                        float hardness = b.func_149638_a(null);
                        if (!(hardness < 6000.0f)) break;
                        this.field_145850_b.func_147480_a(this.field_145851_c + dir.offsetX * i, this.field_145848_d, this.field_145849_e + dir.offsetZ * i, false);
                        break;
                    }
                    double blx = (double)Math.min(this.field_145851_c, this.field_145851_c + dir.offsetX * this.laserLength) + 0.2;
                    double bux = (double)Math.max(this.field_145851_c, this.field_145851_c + dir.offsetX * this.laserLength) + 0.8;
                    double bly = (double)Math.min(this.field_145848_d, this.field_145848_d + dir.offsetY * this.laserLength) + 0.2;
                    double buy = (double)Math.max(this.field_145848_d, this.field_145848_d + dir.offsetY * this.laserLength) + 0.8;
                    double blz = (double)Math.min(this.field_145849_e, this.field_145849_e + dir.offsetZ * this.laserLength) + 0.2;
                    double buz = (double)Math.max(this.field_145849_e, this.field_145849_e + dir.offsetZ * this.laserLength) + 0.8;
                    List list = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)blx, (double)bly, (double)blz, (double)bux, (double)buy, (double)buz));
                    for (Entity e : list) {
                        e.func_70097_a(DamageSource.field_76372_a, 50.0f);
                        e.func_70015_d(5);
                    }
                    this.setPower(0L);
                } else {
                    this.laserLength = 0;
                }
            } else {
                this.laserLength = 0;
            }
        } else if (this.laserLength > 0 && this.field_145850_b.field_73012_v.nextInt(5) == 0) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            double offXZ = this.field_145850_b.field_73012_v.nextDouble() * 0.25 - 0.125;
            double offY = this.field_145850_b.field_73012_v.nextDouble() * 0.25 - 0.125;
            double dist = 0.55;
            this.field_145850_b.func_72869_a("reddust", (double)this.field_145851_c + 0.5 + (double)dir.offsetX * dist + (double)rot.offsetX * offXZ, (double)this.field_145848_d + 0.5 + offY, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * dist + (double)rot.offsetZ * offXZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.capacitorCount);
        buf.writeInt(this.turbochargerCount);
        buf.writeInt(this.laserLength);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.capacitorCount = buf.readInt();
        this.turbochargerCount = buf.readInt();
        this.laserLength = buf.readInt();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.assembled = nbt.func_74767_n("assembled");
        this.cellCount = nbt.func_74762_e("cellCount");
        this.emitterCount = nbt.func_74762_e("emitterCount");
        this.capacitorCount = nbt.func_74762_e("capacitorCount");
        this.turbochargerCount = nbt.func_74762_e("turbochargerCount");
        this.ports.clear();
        int portCount = nbt.func_74762_e("portCount");
        for (int i = 0; i < portCount; ++i) {
            int[] port = nbt.func_74759_k("p" + i);
            this.ports.add(new BlockPos(port[0], port[1], port[2]));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("assembled", this.assembled);
        nbt.func_74768_a("cellCount", this.cellCount);
        nbt.func_74768_a("emitterCount", this.emitterCount);
        nbt.func_74768_a("capacitorCount", this.capacitorCount);
        nbt.func_74768_a("turbochargerCount", this.turbochargerCount);
        nbt.func_74768_a("portCount", this.ports.size());
        for (int i = 0; i < this.ports.size(); ++i) {
            BlockPos pos = this.ports.get(i);
            nbt.func_74783_a("p" + i, new int[]{pos.getX(), pos.getY(), pos.getZ()});
        }
    }

    @Override
    public long getPower() {
        return Math.min(this.power, this.getMaxPower());
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return (long)(Math.sqrt(this.capacitorCount) * 2500000.0 + Math.sqrt(Math.min(this.turbochargerCount, this.capacitorCount)) * 5000000.0);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5 - 50.0), (double)this.field_145848_d, (double)((double)this.field_145849_e + 0.5 - 50.0), (double)((double)this.field_145851_c + 0.5 + 50.0), (double)(this.field_145848_d + 1), (double)((double)this.field_145849_e + 0.5 + 50.0));
        }
        return this.bb;
    }
}

