/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineElectricFurnace;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerElectricFurnace;
import com.hbm.inventory.gui.GUIMachineElectricFurnace;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineElectricFurnace
extends TileEntityMachineBase
implements ISidedInventory,
IEnergyReceiverMK2,
IGUIProvider,
IUpgradeInfoProvider {
    public int progress;
    public long power;
    public static final long maxPower = 100000L;
    public int maxProgress = 100;
    public int consumption = 50;
    private int cooldown = 0;
    private static final int[] slots_io = new int[]{0, 1, 2};
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();

    public TileEntityMachineElectricFurnace() {
        super(4);
    }

    @Override
    public String getName() {
        return "container.electricFurnace";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0) {
            return itemStack.func_77973_b() instanceof IBatteryItem;
        }
        if (i == 1) {
            return FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("progress", this.progress);
    }

    @Override
    public int[] func_94128_d(int side) {
        return slots_io;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (i == 0 && itemStack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == 0L) {
            return true;
        }
        return i == 2;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / this.maxProgress;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public boolean hasPower() {
        return this.power >= (long)this.consumption;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    public boolean canProcess() {
        if (this.slots[1] == null || this.cooldown > 0) {
            return false;
        }
        ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[1]);
        if (itemStack == null) {
            return false;
        }
        if (this.slots[2] == null) {
            return true;
        }
        if (!this.slots[2].func_77969_a(itemStack)) {
            return false;
        }
        if (this.slots[2].field_77994_a < this.func_70297_j_() && this.slots[2].field_77994_a < this.slots[2].func_77976_d()) {
            return true;
        }
        return this.slots[2].field_77994_a < itemStack.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[1]);
            if (this.slots[2] == null) {
                this.slots[2] = itemStack.func_77946_l();
            } else if (this.slots[2].func_77969_a(itemStack)) {
                this.slots[2].field_77994_a += itemStack.field_77994_a;
            }
            for (int i = 1; i < 2; ++i) {
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = new ItemStack(this.slots[i].func_77973_b());
                } else {
                    --this.slots[i].field_77994_a;
                }
                if (this.slots[i].field_77994_a > 0) continue;
                this.slots[i] = null;
            }
        }
    }

    @Override
    public void func_145845_h() {
        boolean markDirty = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000L);
            if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                this.updateConnections();
            }
            this.consumption = 50;
            this.maxProgress = 100;
            this.upgradeManager.checkSlots(this, this.slots, 3, 3);
            int speedLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int powerLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            this.maxProgress -= speedLevel * 25;
            this.consumption += speedLevel * 50;
            this.maxProgress += powerLevel * 10;
            this.consumption -= powerLevel * 15;
            if (!this.hasPower()) {
                this.cooldown = 20;
            }
            if (this.hasPower() && this.canProcess()) {
                ++this.progress;
                this.power -= (long)this.consumption;
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 0.04f);
                }
                if (this.progress >= this.maxProgress) {
                    this.progress = 0;
                    this.processItem();
                    markDirty = true;
                }
            } else {
                this.progress = 0;
            }
            boolean trigger = true;
            if (this.hasPower() && this.canProcess() && this.progress == 0) {
                trigger = false;
            }
            if (trigger) {
                markDirty = true;
                MachineElectricFurnace.updateBlockState(this.progress > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.networkPackNT(50);
            if (markDirty) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.maxProgress);
        buf.writeInt(this.progress);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.maxProgress = buf.readInt();
        this.progress = buf.readInt();
    }

    private void updateConnections() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerElectricFurnace(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineElectricFurnace(player.field_71071_by, this);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_electric_furnace_off));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 100 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 30 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.delay", "+" + level * 10 + "%"));
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        return upgrades;
    }
}

