/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.recipes.AssemblyMachineRecipes;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.module.machine.ModuleMachinePrecAss;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;

public class TileEntityMachinePrecAss
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiverMK2,
IUpgradeInfoProvider,
IControlReceiver {
    public FluidTank inputTank;
    public FluidTank outputTank;
    public long power;
    public long maxPower = 100000L;
    public boolean didProcess = false;
    public boolean frame = false;
    private AudioWrapper audio;
    public ModuleMachinePrecAss assemblerModule;
    public double prevRing;
    public double ring;
    public double ringSpeed;
    public double ringTarget;
    public int ringDelay;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT(this);
    AxisAlignedBB bb = null;

    public TileEntityMachinePrecAss() {
        super(22);
        this.inputTank = new FluidTank(Fluids.NONE, 4000);
        this.outputTank = new FluidTank(Fluids.NONE, 4000);
        this.assemblerModule = new ModuleMachinePrecAss(0, this, this.slots).itemInput(4).itemOutput(13).fluidInput(this.inputTank).fluidOutput(this.outputTank);
    }

    @Override
    public String getName() {
        return "container.machinePrecAss";
    }

    @Override
    public void func_145845_h() {
        if (this.maxPower <= 0L) {
            this.maxPower = 1000000L;
        }
        if (!this.field_145850_b.field_72995_K) {
            GenericRecipe recipe = (GenericRecipe)AssemblyMachineRecipes.INSTANCE.recipeNameMap.get(this.assemblerModule.recipe);
            if (recipe != null) {
                this.maxPower = recipe.power * 100L;
            }
            this.maxPower = BobMathUtil.max(this.power, this.maxPower, 100000L);
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.maxPower);
            this.upgradeManager.checkSlots(this.slots, 2, 3);
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos);
                if (this.inputTank.getTankType() != Fluids.NONE) {
                    this.trySubscribe(this.inputTank.getTankType(), this.field_145850_b, pos);
                }
                if (this.outputTank.getFill() <= 0) continue;
                this.tryProvide(this.outputTank, this.field_145850_b, pos);
            }
            double speed = 1.0;
            double pow = 1.0;
            speed += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) / 3.0;
            pow -= (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3) * 0.25;
            pow += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) * 1.0;
            this.assemblerModule.update(speed += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3), pow += (double)Math.min(this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3) * 10.0 / 3.0, true, this.slots[1]);
            this.didProcess = this.assemblerModule.didProcess;
            if (this.assemblerModule.markDirty) {
                this.func_70296_d();
            }
            this.networkPackNT(100);
        } else {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                boolean bl = this.frame = !this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e).isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e);
            }
            if (this.didProcess && MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 50.0) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.keepAlive();
                this.audio.updatePitch(0.75f);
                this.audio.updateVolume(this.getVolume(0.5f));
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
            this.prevRing = this.ring;
            if (this.didProcess) {
                if (this.ring != this.ringTarget) {
                    double ringDelta = Math.abs(this.ringTarget - this.ring);
                    if (ringDelta <= this.ringSpeed) {
                        this.ring = this.ringTarget;
                    }
                    if (this.ringTarget > this.ring) {
                        this.ring += this.ringSpeed;
                    }
                    if (this.ringTarget < this.ring) {
                        this.ring -= this.ringSpeed;
                    }
                    if (this.ringTarget == this.ring) {
                        if (this.ringTarget >= 360.0) {
                            this.ringTarget -= 360.0;
                            this.ring -= 360.0;
                            this.prevRing -= 360.0;
                        }
                        if (this.ringTarget <= -360.0) {
                            this.ringTarget += 360.0;
                            this.ring += 360.0;
                            this.prevRing += 360.0;
                        }
                        this.ringDelay = 20 + this.field_145850_b.field_73012_v.nextInt(21);
                    }
                } else {
                    if (this.ringDelay > 0) {
                        --this.ringDelay;
                    }
                    if (this.ringDelay <= 0) {
                        this.ringTarget += (this.field_145850_b.field_73012_v.nextDouble() * 2.0 - 1.0) * 135.0;
                        this.ringSpeed = 10.0 + this.field_145850_b.field_73012_v.nextDouble() * 5.0;
                        if (!this.muffled) {
                            MainRegistry.proxy.playSoundClient(this.field_145851_c, this.field_145848_d, this.field_145849_e, "hbm:block.assemblerStart", this.getVolume(0.25f), 1.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.25f);
                        }
                    }
                }
            }
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.motor", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.5f, 15.0f, 0.75f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 0, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 0, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 0, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c + 0, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.inputTank.serialize(buf);
        this.outputTank.serialize(buf);
        buf.writeLong(this.power);
        buf.writeLong(this.maxPower);
        buf.writeBoolean(this.didProcess);
        this.assemblerModule.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        boolean wasProcessing = this.didProcess;
        this.inputTank.deserialize(buf);
        this.outputTank.deserialize(buf);
        this.power = buf.readLong();
        this.maxPower = buf.readLong();
        this.didProcess = buf.readBoolean();
        this.assemblerModule.deserialize(buf);
        if (wasProcessing && !this.didProcess) {
            MainRegistry.proxy.playSoundClient(this.field_145851_c, this.field_145848_d, this.field_145849_e, "hbm:block.assemblerStop", this.getVolume(0.25f), 1.5f);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTank.readFromNBT(nbt, "i");
        this.outputTank.readFromNBT(nbt, "o");
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        this.assemblerModule.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inputTank.writeToNBT(nbt, "i");
        this.outputTank.writeToNBT(nbt, "o");
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("maxPower", this.maxPower);
        this.assemblerModule.writeToNBT(nbt);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return true;
        }
        if (slot == 1 && stack.func_77973_b() == ModItems.blueprints) {
            return true;
        }
        if (slot >= 2 && slot <= 3 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            return true;
        }
        return this.assemblerModule.isItemValid(slot, stack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i >= 13 || this.assemblerModule.isSlotClogged(i);
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.inputTank};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.outputTank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.inputTank, this.outputTank};
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("index") && data.func_74764_b("selection")) {
            int index = data.func_74762_e("index");
            String selection = data.func_74779_i("selection");
            if (index == 0) {
                this.assemblerModule.recipe = selection;
                this.markChanged();
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_assembly_machine));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.speed", "+" + level * 100 / 3 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 50 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 25 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }
}

