/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.albion;

import com.hbm.blocks.BlockDummyable;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerPASource;
import com.hbm.inventory.gui.GUIPASource;
import com.hbm.lib.Library;
import com.hbm.tileentity.IConditionalInvAccess;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.machine.albion.IParticleUser;
import com.hbm.tileentity.machine.albion.TileEntityCooledBase;
import com.hbm.util.EnumUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPASource
extends TileEntityCooledBase
implements IGUIProvider,
IConditionalInvAccess,
IControlReceiver {
    public static final long usage = 100000L;
    public Particle particle;
    public PAState state = PAState.IDLE;
    public int lastSpeed;
    public int debugSpeed;
    public static final BlockPos cheapAss = new BlockPos(0, 0, 0);
    public static final int[] slotsRed = new int[]{1, 3, 4};
    public static final int[] slotsYellow = new int[]{2, 3, 4};
    AxisAlignedBB bb = null;

    public void updateState(PAState state) {
        this.state = state;
    }

    public TileEntityPASource() {
        super(5);
    }

    @Override
    public String getName() {
        return "container.paSource";
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.getMaxPower());
            for (int i = 0; i < 10; ++i) {
                if (this.particle != null) {
                    this.state = PAState.RUNNING;
                    this.steppy();
                    this.debugSpeed = this.particle.momentum;
                    if (!this.particle.invalid) continue;
                    this.particle = null;
                    continue;
                }
                if (this.power < 100000L || this.slots[1] == null || this.slots[2] == null) continue;
                this.tryRun();
                break;
            }
        }
        super.func_145845_h();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void steppy() {
        if (!this.field_145850_b.func_72863_F().func_73149_a(this.particle.x >> 4, this.particle.z >> 4)) {
            this.state = PAState.PAUSE_UNLOADED;
            return;
        }
        Block b = this.field_145850_b.func_147439_a(this.particle.x, this.particle.y, this.particle.z);
        if (!(b instanceof BlockDummyable)) {
            this.particle.crash(PAState.CRASH_DERAIL);
            return;
        }
        int[] pos = ((BlockDummyable)b).findCore(this.field_145850_b, this.particle.x, this.particle.y, this.particle.z);
        if (pos == null) {
            this.particle.crash(PAState.CRASH_DERAIL);
            return;
        }
        TileEntity tile = this.field_145850_b.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(tile instanceof IParticleUser)) {
            this.particle.crash(PAState.CRASH_DERAIL);
            return;
        }
        IParticleUser pa = (IParticleUser)tile;
        if (pa.canParticleEnter(this.particle, this.particle.dir, this.particle.x, this.particle.y, this.particle.z)) {
            pa.onEnter(this.particle, this.particle.dir);
            BlockPos exit = pa.getExitPos(this.particle);
            if (exit == null) return;
            this.particle.move(exit);
            return;
        }
        this.particle.crash(PAState.CRASH_CANNOT_ENTER);
    }

    public void tryRun() {
        if (!this.isCool()) {
            return;
        }
        if (this.slots[1].func_77973_b().hasContainerItem(this.slots[1]) && this.slots[3] != null) {
            return;
        }
        if (this.slots[2].func_77973_b().hasContainerItem(this.slots[2]) && this.slots[4] != null) {
            return;
        }
        if (this.slots[1].func_77973_b().hasContainerItem(this.slots[1])) {
            this.slots[3] = this.slots[1].func_77973_b().getContainerItem(this.slots[1]).func_77946_l();
        }
        if (this.slots[2].func_77973_b().hasContainerItem(this.slots[2])) {
            this.slots[4] = this.slots[2].func_77973_b().getContainerItem(this.slots[2]).func_77946_l();
        }
        this.power -= 100000L;
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        this.particle = new Particle(this, this.field_145851_c + rot.offsetX * 5, this.field_145848_d, this.field_145849_e + rot.offsetZ * 5, rot, this.slots[1], this.slots[2]);
        this.slots[1] = null;
        this.slots[2] = null;
        this.func_70296_d();
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.debugSpeed);
        buf.writeByte((int)((byte)this.state.ordinal()));
        buf.writeInt(this.lastSpeed);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.debugSpeed = buf.readInt();
        this.state = (PAState)((Object)EnumUtil.grabEnumSafely(PAState.class, buf.readByte()));
        this.lastSpeed = buf.readInt();
    }

    @Override
    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2, dir), new DirPos(this.field_145851_c + dir.offsetX * 2 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * 2, dir), new DirPos(this.field_145851_c + dir.offsetX * 2 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 - rot.offsetZ * 2, dir), new DirPos(this.field_145851_c - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 5, this.field_145848_d, this.field_145849_e + rot.offsetZ * 5, rot)};
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 1 || slot == 2;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 3 || slot == 4;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{3, 4};
    }

    @Override
    public boolean isItemValidForSlot(int x, int y, int z, int slot, ItemStack stack) {
        return this.func_94041_b(slot, stack);
    }

    @Override
    public boolean canExtractItem(int x, int y, int z, int slot, ItemStack stack, int side) {
        return this.func_102008_b(slot, stack, side);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        cheapAss.mutate(x, y, z);
        if (cheapAss.compare(this.field_145851_c + dir.offsetX - rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ - rot.offsetZ * 2) || cheapAss.compare(this.field_145851_c - dir.offsetX + rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ + rot.offsetZ * 2)) {
            return slotsYellow;
        }
        if (cheapAss.compare(this.field_145851_c - dir.offsetX - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ - rot.offsetZ * 2) || cheapAss.compare(this.field_145851_c + dir.offsetX + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ + rot.offsetZ * 2)) {
            return slotsRed;
        }
        return this.func_94128_d(side);
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 6));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerPASource(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIPASource(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("cancel")) {
            this.particle = null;
            this.state = PAState.IDLE;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.particle != null) {
            NBTTagCompound particleTag = new NBTTagCompound();
            particleTag.func_74768_a("x", this.particle.x);
            particleTag.func_74768_a("y", this.particle.y);
            particleTag.func_74768_a("z", this.particle.z);
            particleTag.func_74774_a("dir", (byte)this.particle.dir.ordinal());
            particleTag.func_74768_a("momentum", this.particle.momentum);
            particleTag.func_74768_a("defocus", this.particle.defocus);
            particleTag.func_74768_a("dist", this.particle.distanceTraveled);
            NBTTagCompound inputTag1 = new NBTTagCompound();
            NBTTagCompound inputTag2 = new NBTTagCompound();
            this.particle.input1.func_77955_b(inputTag1);
            this.particle.input2.func_77955_b(inputTag2);
            particleTag.func_74782_a("input1", (NBTBase)inputTag1);
            particleTag.func_74782_a("input2", (NBTBase)inputTag2);
            nbt.func_74782_a("particle", (NBTBase)particleTag);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (!nbt.func_74764_b("particle")) {
            return;
        }
        NBTTagCompound particleTag = nbt.func_74775_l("particle");
        int x = particleTag.func_74762_e("x");
        int y = particleTag.func_74762_e("y");
        int z = particleTag.func_74762_e("z");
        ForgeDirection dir = (ForgeDirection)EnumUtil.grabEnumSafely(ForgeDirection.class, particleTag.func_74762_e("dir"));
        ItemStack input1 = ItemStack.func_77949_a((NBTTagCompound)particleTag.func_74775_l("input1"));
        ItemStack input2 = ItemStack.func_77949_a((NBTTagCompound)particleTag.func_74775_l("input2"));
        this.particle = new Particle(this, x, y, z, dir, input1, input2);
        this.particle.momentum = particleTag.func_74762_e("momentum");
        this.particle.defocus = particleTag.func_74762_e("defocus");
        this.particle.distanceTraveled = particleTag.func_74762_e("dist");
    }

    public static class Particle {
        private TileEntityPASource source;
        public int x;
        public int y;
        public int z;
        public ForgeDirection dir;
        public int momentum;
        public int defocus;
        public int distanceTraveled;
        public static final int maxDefocus = 1000;
        public boolean invalid = false;
        public ItemStack input1;
        public ItemStack input2;

        public Particle(TileEntityPASource source, int x, int y, int z, ForgeDirection dir, ItemStack input1, ItemStack input2) {
            this.source = source;
            this.x = x;
            this.y = y;
            this.z = z;
            this.dir = dir;
            this.input1 = input1;
            this.input2 = input2;
        }

        public void crash(PAState state) {
            this.invalid = true;
            this.source.updateState(state);
        }

        public void move(BlockPos pos) {
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.source.lastSpeed = this.momentum;
        }

        public void addDistance(int dist) {
            this.distanceTraveled += dist;
        }

        public void resetDistance() {
            this.distanceTraveled = 0;
        }

        public void defocus(int amount) {
            this.defocus += amount;
            if (this.defocus > 1000) {
                this.crash(PAState.CRASH_DEFOCUS);
            }
        }

        public void focus(int amount) {
            this.defocus -= amount;
            if (this.defocus < 0) {
                this.defocus = 0;
            }
        }
    }

    public static enum PAState {
        IDLE(0x8080FF),
        RUNNING(0xFFFF00),
        SUCCESS(65280),
        PAUSE_UNLOADED(0x808080),
        CRASH_DEFOCUS(0xFF0000),
        CRASH_DERAIL(0xFF0000),
        CRASH_CANNOT_ENTER(0xFF0000),
        CRASH_NOCOOL(0xFF0000),
        CRASH_NOPOWER(0xFF0000),
        CRASH_NOCOIL(0xFF0000),
        CRASH_OVERSPEED(0xFF0000),
        CRASH_UNDERSPEED(0xFF0000),
        CRASH_NORECIPE(0xFF0000);

        public final int color;

        private PAState(int color) {
            this.color = color;
        }
    }
}

