/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.fusion;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerFusionTorus;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIFusionTorus;
import com.hbm.inventory.recipes.FusionRecipe;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.module.machine.ModuleMachineFusion;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.tileentity.machine.albion.TileEntityCooledBase;
import com.hbm.tileentity.machine.fusion.IFusionPowerReceiver;
import com.hbm.tileentity.machine.fusion.TileEntityFusionCollector;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.INetworkProvider;
import com.hbm.uninos.NodeNet;
import com.hbm.uninos.UniNodespace;
import com.hbm.uninos.networkproviders.KlystronNetworkProvider;
import com.hbm.uninos.networkproviders.PlasmaNetworkProvider;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFusionTorus
extends TileEntityCooledBase
implements IGUIProvider,
IControlReceiver {
    public boolean didProcess = false;
    public FluidTank[] tanks;
    public ModuleMachineFusion fusionModule;
    protected GenNode[] klystronNodes = new GenNode[4];
    protected GenNode[] plasmaNodes = new GenNode[4];
    public boolean[] connections = new boolean[4];
    public long klystronEnergy;
    public long plasmaEnergy;
    public double fuelConsumption;
    public float magnet;
    public float prevMagnet;
    public float magnetSpeed;
    public static final float MAGNET_ACCELERATION = 0.25f;
    private AudioWrapper audio;
    public int timeOffset = -1;
    AxisAlignedBB bb = null;

    public TileEntityFusionTorus() {
        super(3);
        this.tanks = new FluidTank[4];
        this.tanks[0] = new FluidTank(Fluids.NONE, 4000);
        this.tanks[1] = new FluidTank(Fluids.NONE, 4000);
        this.tanks[2] = new FluidTank(Fluids.NONE, 4000);
        this.tanks[3] = new FluidTank(Fluids.NONE, 4000);
        this.fusionModule = new ModuleMachineFusion(0, this, this.slots).fluidInput(this.tanks[0], this.tanks[1], this.tanks[2]).fluidOutput(this.tanks[3]).itemOutput(2);
    }

    @Override
    public String getName() {
        return "container.fusionTorus";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            double outputFlux;
            for (int i = 0; i < 4; ++i) {
                if (this.klystronNodes[i] == null || this.klystronNodes[i].expired) {
                    this.klystronNodes[i] = this.createNode(KlystronNetworkProvider.THE_PROVIDER, ForgeDirection.getOrientation((int)(i + 2)));
                }
                if (this.plasmaNodes[i] == null || this.plasmaNodes[i].expired) {
                    this.plasmaNodes[i] = this.createNode(PlasmaNetworkProvider.THE_PROVIDER, ForgeDirection.getOrientation((int)(i + 2)));
                }
                if (this.klystronNodes[i].net != null) {
                    ((NodeNet)this.klystronNodes[i].net).addReceiver((TileEntityFusionTorus)this);
                }
                if (this.plasmaNodes[i].net == null) continue;
                ((NodeNet)this.plasmaNodes[i].net).addProvider((TileEntityFusionTorus)this);
            }
            this.temperature += 2.5f;
            if (this.temperature > 293.0f) {
                this.temperature = 293.0f;
            }
            if (this.temperature > 123.0f) {
                int cyclesTemp = (int)Math.ceil(Math.min(this.temperature - 123.0f, 7.5f) / 0.5f);
                int cyclesCool = this.coolantTanks[0].getFill();
                int cyclesHot = this.coolantTanks[1].getMaxFill() - this.coolantTanks[1].getFill();
                int cycles = BobMathUtil.min(cyclesTemp, cyclesCool, cyclesHot);
                this.coolantTanks[0].setFill(this.coolantTanks[0].getFill() - cycles);
                this.coolantTanks[1].setFill(this.coolantTanks[1].getFill() + cycles);
                this.temperature -= 0.5f * (float)cycles;
            }
            for (DirPos pos : this.getConPos()) {
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    this.trySubscribe(this.field_145850_b, pos);
                    this.trySubscribe(this.coolantTanks[0].getTankType(), this.field_145850_b, pos);
                    if (this.tanks[0].getTankType() != Fluids.NONE) {
                        this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos);
                    }
                    if (this.tanks[1].getTankType() != Fluids.NONE) {
                        this.trySubscribe(this.tanks[1].getTankType(), this.field_145850_b, pos);
                    }
                    if (this.tanks[2].getTankType() != Fluids.NONE) {
                        this.trySubscribe(this.tanks[2].getTankType(), this.field_145850_b, pos);
                    }
                }
                if (this.coolantTanks[1].getFill() > 0) {
                    this.tryProvide(this.coolantTanks[1], this.field_145850_b, pos);
                }
                if (this.tanks[3].getFill() <= 0) continue;
                this.tryProvide(this.tanks[3], this.field_145850_b, pos);
            }
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.getMaxPower());
            int receiverCount = 0;
            int collectors = 0;
            block2: for (int i = 0; i < 4; ++i) {
                this.connections[i] = false;
                if (this.klystronNodes[i] != null && this.klystronNodes[i].hasValidNet() && !((NodeNet)this.klystronNodes[i].net).providerEntries.isEmpty()) {
                    this.connections[i] = true;
                }
                if (!this.connections[i] && this.plasmaNodes[i] != null && this.plasmaNodes[i].hasValidNet() && !((NodeNet)this.plasmaNodes[i].net).receiverEntries.isEmpty()) {
                    this.connections[i] = true;
                }
                if (this.plasmaNodes[i] == null || !this.plasmaNodes[i].hasValidNet() || ((NodeNet)this.plasmaNodes[i].net).receiverEntries.isEmpty()) continue;
                for (Map.Entry o : ((NodeNet)this.plasmaNodes[i].net).receiverEntries.entrySet()) {
                    Map.Entry entry = o;
                    Object thing = entry.getKey();
                    if (thing instanceof TileEntityLoadedBase && !((TileEntityLoadedBase)thing).isLoaded()) continue;
                    if (thing instanceof IFusionPowerReceiver && ((IFusionPowerReceiver)thing).receivesFusionPower()) {
                        ++receiverCount;
                    }
                    if (!(thing instanceof TileEntityFusionCollector)) continue block2;
                    ++collectors;
                    continue block2;
                }
            }
            FusionRecipe recipe = (FusionRecipe)this.fusionModule.getRecipe();
            double powerFactor = TileEntityFusionTorus.getSpeedScaled(this.getMaxPower(), this.power);
            double fuel0Factor = recipe != null && recipe.inputFluid.length > 0 ? TileEntityFusionTorus.getSpeedScaled(this.tanks[0].getMaxFill(), this.tanks[0].getFill()) : 1.0;
            double fuel1Factor = recipe != null && recipe.inputFluid.length > 1 ? TileEntityFusionTorus.getSpeedScaled(this.tanks[1].getMaxFill(), this.tanks[1].getFill()) : 1.0;
            double fuel2Factor = recipe != null && recipe.inputFluid.length > 2 ? TileEntityFusionTorus.getSpeedScaled(this.tanks[2].getMaxFill(), this.tanks[2].getFill()) : 1.0;
            double factor = BobMathUtil.min(powerFactor, fuel0Factor, fuel1Factor, fuel2Factor);
            boolean ignition = recipe != null ? recipe.ignitionTemp <= this.klystronEnergy : true;
            this.plasmaEnergy = 0L;
            this.fuelConsumption = 0.0;
            this.fusionModule.preUpdate(factor, (double)collectors * 0.5);
            this.fusionModule.update(1.0, 1.0, this.isCool() && ignition, this.slots[1]);
            this.didProcess = this.fusionModule.didProcess;
            if (this.fusionModule.markDirty) {
                this.func_70296_d();
            }
            if (this.didProcess && recipe != null) {
                this.plasmaEnergy = (long)Math.ceil((double)recipe.outputTemp * factor);
                this.fuelConsumption = factor;
            }
            double outputIntensity = TileEntityFusionTorus.getOuputIntensity(receiverCount);
            double d = outputFlux = recipe != null ? recipe.neutronFlux * factor : 0.0;
            if (this.plasmaEnergy > 0L) {
                for (int i = 0; i < 4; ++i) {
                    if (this.plasmaNodes[i] == null || !this.plasmaNodes[i].hasValidNet() || ((NodeNet)this.plasmaNodes[i].net).receiverEntries.isEmpty()) continue;
                    for (Map.Entry o : ((NodeNet)this.plasmaNodes[i].net).receiverEntries.entrySet()) {
                        Map.Entry entry = o;
                        if (!(entry.getKey() instanceof IFusionPowerReceiver)) continue;
                        long powerReceived = (long)Math.ceil((double)this.plasmaEnergy * outputIntensity);
                        ((IFusionPowerReceiver)entry.getKey()).receiveFusionPower(powerReceived, outputFlux);
                    }
                }
            }
            this.networkPackNT(150);
            this.klystronEnergy = 0L;
        } else {
            if (this.timeOffset == -1) {
                this.timeOffset = this.field_145850_b.field_73012_v.nextInt(30000);
            }
            double powerFactor = TileEntityFusionTorus.getSpeedScaled(this.getMaxPower(), this.power);
            this.magnetSpeed = this.didProcess ? (this.magnetSpeed += 0.25f) : (this.magnetSpeed -= 0.25f);
            this.magnetSpeed = MathHelper.func_76131_a((float)this.magnetSpeed, (float)0.0f, (float)(30.0f * (float)powerFactor));
            this.prevMagnet = this.magnet;
            this.magnet += this.magnetSpeed;
            if (this.magnet >= 360.0f) {
                this.magnet -= 360.0f;
                this.prevMagnet -= 360.0f;
            }
            if (this.magnetSpeed > 0.0f && MainRegistry.proxy.me().func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 2.5, (double)this.field_145849_e + 0.5) < 2500.0) {
                float speed = this.magnetSpeed / 30.0f;
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.fusionReactorRunning", (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 2.5f, (float)this.field_145849_e + 0.5f, this.getVolume(speed), 30.0f, speed, 20);
                    this.audio.startSound();
                } else {
                    this.audio.updateVolume(this.getVolume(speed));
                    this.audio.updatePitch(speed);
                    this.audio.keepAlive();
                }
            } else if (this.audio != null) {
                if (this.audio.isPlaying()) {
                    this.audio.stopSound();
                }
                this.audio = null;
            }
        }
    }

    public static double getOuputIntensity(int receiverCount) {
        if (receiverCount == 1) {
            return 1.0;
        }
        if (receiverCount == 2) {
            return 0.625;
        }
        if (receiverCount == 3) {
            return 0.5;
        }
        return 0.4375;
    }

    public GenNode createNode(INetworkProvider provider, ForgeDirection dir) {
        GenNode node = UniNodespace.getNode(this.field_145850_b, this.field_145851_c + dir.offsetX * 7, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 7, provider);
        if (node != null) {
            return node;
        }
        node = new GenNode(provider, new BlockPos(this.field_145851_c + dir.offsetX * 7, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 7)).setConnections(new DirPos(this.field_145851_c + dir.offsetX * 8, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 8, dir));
        UniNodespace.createNode(this.field_145850_b, node);
        return node;
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
        if (!this.field_145850_b.field_72995_K) {
            for (GenNode node : this.klystronNodes) {
                if (node == null) continue;
                UniNodespace.destroyNode(this.field_145850_b, node);
            }
            for (GenNode node : this.plasmaNodes) {
                if (node == null) continue;
                UniNodespace.destroyNode(this.field_145850_b, node);
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        int i;
        super.serialize(buf);
        buf.writeBoolean(this.didProcess);
        buf.writeLong(this.klystronEnergy);
        buf.writeLong(this.plasmaEnergy);
        buf.writeDouble(this.fuelConsumption);
        this.fusionModule.serialize(buf);
        for (i = 0; i < 4; ++i) {
            this.tanks[i].serialize(buf);
        }
        for (i = 0; i < 4; ++i) {
            buf.writeBoolean(this.connections[i]);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        int i;
        super.deserialize(buf);
        this.didProcess = buf.readBoolean();
        this.klystronEnergy = buf.readLong();
        this.plasmaEnergy = buf.readLong();
        this.fuelConsumption = buf.readDouble();
        this.fusionModule.deserialize(buf);
        for (i = 0; i < 4; ++i) {
            this.tanks[i].deserialize(buf);
        }
        for (i = 0; i < 4; ++i) {
            this.connections[i] = buf.readBoolean();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].readFromNBT(nbt, "ft" + i);
        }
        this.power = nbt.func_74763_f("power");
        this.fusionModule.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].writeToNBT(nbt, "ft" + i);
        }
        nbt.func_74772_a("power", this.power);
        this.fusionModule.writeToNBT(nbt);
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.coolantTanks[1], this.tanks[3]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.coolantTanks[0], this.tanks[0], this.tanks[1], this.tanks[2]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.coolantTanks[0], this.coolantTanks[1], this.tanks[0], this.tanks[1], this.tanks[2], this.tanks[3]};
    }

    public static double getSpeedScaled(double max, double level) {
        if (max == 0.0) {
            return 0.0;
        }
        if (level >= max * 0.5) {
            return 1.0;
        }
        return level / max * 2.0;
    }

    @Override
    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c + 6, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c + 6, this.field_145848_d + 5, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c + 6, this.field_145848_d - 1, this.field_145849_e + 2, Library.NEG_Y), new DirPos(this.field_145851_c + 6, this.field_145848_d + 5, this.field_145849_e + 2, Library.POS_Y), new DirPos(this.field_145851_c + 6, this.field_145848_d - 1, this.field_145849_e - 2, Library.NEG_Y), new DirPos(this.field_145851_c + 6, this.field_145848_d + 5, this.field_145849_e - 2, Library.POS_Y), new DirPos(this.field_145851_c - 6, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c - 6, this.field_145848_d + 5, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c - 6, this.field_145848_d - 1, this.field_145849_e + 2, Library.NEG_Y), new DirPos(this.field_145851_c - 6, this.field_145848_d + 5, this.field_145849_e + 2, Library.POS_Y), new DirPos(this.field_145851_c - 6, this.field_145848_d - 1, this.field_145849_e - 2, Library.NEG_Y), new DirPos(this.field_145851_c - 6, this.field_145848_d + 5, this.field_145849_e - 2, Library.POS_Y), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e + 6, Library.NEG_Y), new DirPos(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e + 6, Library.POS_Y), new DirPos(this.field_145851_c + 2, this.field_145848_d - 1, this.field_145849_e + 6, Library.NEG_Y), new DirPos(this.field_145851_c + 2, this.field_145848_d + 5, this.field_145849_e + 6, Library.POS_Y), new DirPos(this.field_145851_c - 2, this.field_145848_d - 1, this.field_145849_e + 6, Library.NEG_Y), new DirPos(this.field_145851_c - 2, this.field_145848_d + 5, this.field_145849_e + 6, Library.POS_Y), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e - 6, Library.NEG_Y), new DirPos(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e - 6, Library.POS_Y), new DirPos(this.field_145851_c + 2, this.field_145848_d - 1, this.field_145849_e - 6, Library.NEG_Y), new DirPos(this.field_145851_c + 2, this.field_145848_d + 5, this.field_145849_e - 6, Library.POS_Y), new DirPos(this.field_145851_c - 2, this.field_145848_d - 1, this.field_145849_e - 6, Library.NEG_Y), new DirPos(this.field_145851_c - 2, this.field_145848_d + 5, this.field_145849_e - 6, Library.POS_Y)};
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return true;
        }
        return slot == 1 && stack.func_77973_b() == ModItems.blueprints;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 2;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{2};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 8), (double)this.field_145848_d, (double)(this.field_145849_e - 8), (double)(this.field_145851_c + 9), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 9));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFusionTorus(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIFusionTorus(player.field_71071_by, this);
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 1024.0;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("index") && data.func_74764_b("selection")) {
            int index = data.func_74762_e("index");
            String selection = data.func_74779_i("selection");
            if (index == 0) {
                this.fusionModule.recipe = selection;
                this.markChanged();
            }
        }
    }
}

