/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.uninos;

import com.hbm.uninos.GenNode;
import com.hbm.uninos.INetworkProvider;
import com.hbm.uninos.NodeNet;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class UniNodespace {
    public static HashMap<World, UniNodeWorld> worlds = new HashMap();
    public static Set<NodeNet> activeNodeNets = new HashSet<NodeNet>();

    public static GenNode getNode(World world, int x, int y, int z, INetworkProvider type) {
        UniNodeWorld nodeWorld = worlds.get(world);
        if (nodeWorld != null) {
            return nodeWorld.nodes.get(new Tuple.Pair<BlockPos, INetworkProvider>(new BlockPos(x, y, z), type));
        }
        return null;
    }

    public static void createNode(World world, GenNode node) {
        UniNodeWorld nodeWorld = worlds.get(world);
        if (nodeWorld == null) {
            nodeWorld = new UniNodeWorld();
            worlds.put(world, nodeWorld);
        }
        nodeWorld.pushNode(node);
    }

    public static void destroyNode(World world, int x, int y, int z, INetworkProvider type) {
        GenNode node = UniNodespace.getNode(world, x, y, z, type);
        if (node != null) {
            worlds.get(world).popNode(node);
        }
    }

    public static void destroyNode(World world, GenNode node) {
        if (node != null) {
            worlds.get(world).popNode(node);
        }
    }

    public static void updateNodespace() {
        for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
            UniNodeWorld nodeWorld = worlds.get(world);
            if (nodeWorld == null) continue;
            for (Map.Entry<Tuple.Pair<BlockPos, INetworkProvider>, GenNode> entry : nodeWorld.nodes.entrySet()) {
                GenNode node = entry.getValue();
                INetworkProvider provider = entry.getKey().getValue();
                if (node.hasValidNet() && !node.recentlyChanged) continue;
                UniNodespace.checkNodeConnection((World)world, node, provider);
                node.recentlyChanged = false;
            }
        }
        UniNodespace.updateNetworks();
    }

    private static void updateNetworks() {
        for (NodeNet net : activeNodeNets) {
            net.resetTrackers();
        }
        for (NodeNet net : activeNodeNets) {
            net.update();
        }
    }

    private static void checkNodeConnection(World world, GenNode node, INetworkProvider provider) {
        for (DirPos con : node.connections) {
            GenNode conNode = UniNodespace.getNode(world, con.getX(), con.getY(), con.getZ(), provider);
            if (conNode == null || conNode.hasValidNet() && conNode.net == node.net || !UniNodespace.checkConnection(conNode, con, false)) continue;
            UniNodespace.connectToNode(node, conNode);
        }
        if (node.net == null || !((NodeNet)node.net).isValid()) {
            ((NodeNet)provider.provideNetwork()).joinLink((GenNode)node);
        }
    }

    public static boolean checkConnection(GenNode connectsTo, DirPos connectFrom, boolean skipSideCheck) {
        for (DirPos revCon : connectsTo.connections) {
            if (revCon.getX() - revCon.getDir().offsetX != connectFrom.getX() || revCon.getY() - revCon.getDir().offsetY != connectFrom.getY() || revCon.getZ() - revCon.getDir().offsetZ != connectFrom.getZ() || revCon.getDir() != connectFrom.getDir().getOpposite() && !skipSideCheck) continue;
            return true;
        }
        return false;
    }

    private static void connectToNode(GenNode origin, GenNode connection) {
        if (origin.hasValidNet() && connection.hasValidNet()) {
            if (((NodeNet)origin.net).links.size() > ((NodeNet)connection.net).links.size()) {
                ((NodeNet)origin.net).joinNetworks((NodeNet)connection.net);
            } else {
                ((NodeNet)connection.net).joinNetworks((NodeNet)origin.net);
            }
        } else if (!origin.hasValidNet() && connection.hasValidNet()) {
            ((NodeNet)connection.net).joinLink((GenNode)origin);
        } else if (origin.hasValidNet() && !connection.hasValidNet()) {
            ((NodeNet)origin.net).joinLink((GenNode)connection);
        }
    }

    public static class UniNodeWorld {
        public HashMap<Tuple.Pair<BlockPos, INetworkProvider>, GenNode> nodes = new LinkedHashMap<Tuple.Pair<BlockPos, INetworkProvider>, GenNode>();

        public void pushNode(GenNode node) {
            for (BlockPos pos : node.positions) {
                this.nodes.put(new Tuple.Pair<BlockPos, INetworkProvider>(pos, node.networkProvider), node);
            }
        }

        public void popNode(GenNode node) {
            if (node.net != null) {
                ((NodeNet)node.net).destroy();
            }
            for (BlockPos pos : node.positions) {
                this.nodes.remove(new Tuple.Pair<BlockPos, INetworkProvider>(pos, node.networkProvider));
            }
            node.expired = true;
        }
    }
}

