/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.wiaj.cannery;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ModItems;
import com.hbm.main.ResourceManager;
import com.hbm.tileentity.network.TileEntityPipeBaseNT;
import com.hbm.util.i18n.I18nUtil;
import com.hbm.wiaj.JarScene;
import com.hbm.wiaj.JarScript;
import com.hbm.wiaj.WorldInAJar;
import com.hbm.wiaj.actions.ActionCreateActor;
import com.hbm.wiaj.actions.ActionRemoveActor;
import com.hbm.wiaj.actions.ActionSetBlock;
import com.hbm.wiaj.actions.ActionSetTile;
import com.hbm.wiaj.actions.ActionSetZoom;
import com.hbm.wiaj.actions.ActionWait;
import com.hbm.wiaj.actors.ActorFancyPanel;
import com.hbm.wiaj.actors.ActorTileEntity;
import com.hbm.wiaj.actors.ITileActorRenderer;
import com.hbm.wiaj.cannery.CanneryBase;
import com.hbm.wiaj.cannery.Dummies;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class CanneryCentrifuge
extends CanneryBase {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(ModBlocks.machine_gascent);
    }

    @Override
    public String getName() {
        return "cannery.centrifuge";
    }

    @Override
    public JarScript createScript() {
        WorldInAJar world = new WorldInAJar(9, 5, 5);
        JarScript script = new JarScript(world);
        JarScene scene0 = new JarScene(script);
        scene0.add(new ActionSetZoom(2.0, 0));
        for (int x = world.sizeX - 1; x >= 0; --x) {
            for (int z = 0; z < world.sizeZ; ++z) {
                scene0.add(new ActionSetBlock(x, 0, z, Blocks.field_150336_V));
            }
            if (x == 7) {
                scene0.add(new ActionSetTile(7, 1, 2, new Dummies.JarDummyConnector()));
                scene0.add(new ActionSetBlock(7, 1, 2, ModBlocks.barrel_tcalloy));
            }
            if (x == 6) {
                TileEntityPipeBaseNT duct = new TileEntityPipeBaseNT();
                duct.setType(Fluids.UF6);
                scene0.add(new ActionSetTile(6, 1, 2, duct));
                scene0.add(new ActionSetBlock(6, 1, 2, ModBlocks.fluid_duct_neo, 0));
            }
            if (x == 5) {
                scene0.add(new ActionSetTile(5, 1, 2, new Dummies.JarDummyConnector()));
                NBTTagCompound cent = new NBTTagCompound();
                cent.func_74780_a("x", 5.0);
                cent.func_74780_a("y", 1.0);
                cent.func_74780_a("z", 2.0);
                cent.func_74768_a("rotation", 2);
                scene0.add(new ActionCreateActor(0, new ActorTileEntity(new ActorGasCent(), cent)));
            }
            scene0.add(new ActionWait(2));
        }
        scene0.add(new ActionCreateActor(1, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, -15, -50, new Object[][]{{I18nUtil.resolveKey("cannery.centrifuge.0", new Object[0])}}, 200).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.BOTTOM)));
        scene0.add(new ActionWait(60));
        scene0.add(new ActionRemoveActor(1));
        JarScene scene1 = new JarScene(script);
        scene1.add(new ActionCreateActor(1, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, -15, 10, new Object[][]{{I18nUtil.resolveKey("cannery.centrifuge.1", new Object[0])}}, 200).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.CENTER)));
        scene1.add(new ActionWait(60));
        scene1.add(new ActionRemoveActor(1));
        scene1.add(new ActionSetZoom(4.0, 20));
        scene1.add(new ActionCreateActor(1, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, 40, new Object[][]{{I18nUtil.resolveKey("cannery.centrifuge.2", new Object[0])}}, 150).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.LEFT)));
        scene1.add(new ActionWait(60));
        scene1.add(new ActionRemoveActor(1));
        scene1.add(new ActionSetZoom(-2.0, 20));
        scene1.add(new ActionWait(20));
        NBTTagCompound c2 = new NBTTagCompound();
        c2.func_74780_a("x", 4.0);
        c2.func_74780_a("y", 1.0);
        c2.func_74780_a("z", 2.0);
        c2.func_74768_a("rotation", 2);
        scene1.add(new ActionCreateActor(1, new ActorTileEntity(new ActorGasCent(), c2)));
        scene1.add(new ActionWait(10));
        scene1.add(new ActionCreateActor(2, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, 0, new Object[][]{{I18nUtil.resolveKey("cannery.centrifuge.3", new Object[0])}}, 200).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.CENTER)));
        scene1.add(new ActionWait(100));
        scene1.add(new ActionRemoveActor(2));
        scene1.add(new ActionSetZoom(-2.0, 20));
        scene1.add(new ActionCreateActor(2, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, 0, new Object[][]{{I18nUtil.resolveKey("cannery.centrifuge.4", new Object[0])}}, 200).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.CENTER)));
        scene1.add(new ActionWait(60));
        scene1.add(new ActionRemoveActor(2));
        NBTTagCompound c3 = new NBTTagCompound();
        c3.func_74780_a("x", 3.0);
        c3.func_74780_a("y", 1.0);
        c3.func_74780_a("z", 2.0);
        c3.func_74768_a("rotation", 2);
        scene1.add(new ActionCreateActor(2, new ActorTileEntity(new ActorGasCent(), c3)));
        scene1.add(new ActionWait(10));
        NBTTagCompound c4 = new NBTTagCompound();
        c4.func_74780_a("x", 2.0);
        c4.func_74780_a("y", 1.0);
        c4.func_74780_a("z", 2.0);
        c4.func_74768_a("rotation", 2);
        scene1.add(new ActionCreateActor(3, new ActorTileEntity(new ActorGasCent(), c4)));
        scene1.add(new ActionWait(10));
        scene1.add(new ActionCreateActor(4, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, 0, new Object[][]{{I18nUtil.resolveKey("cannery.centrifuge.5", new Object[0])}}, 200).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.CENTER)));
        scene1.add(new ActionWait(60));
        scene1.add(new ActionRemoveActor(4));
        scene1.add(new ActionCreateActor(4, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 28, -30, new Object[][]{{new ItemStack(ModItems.upgrade_gc_speed)}}, 0).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.BOTTOM)));
        scene1.add(new ActionCreateActor(5, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 45, 35, new Object[][]{{" = ", new ItemStack(ModItems.nugget_u238, 11), new ItemStack(ModItems.nugget_u235)}}, 0).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.LEFT)));
        script.addScene(scene0).addScene(scene1);
        return script;
    }

    public static class ActorGasCent
    implements ITileActorRenderer {
        @Override
        public void renderActor(WorldInAJar world, int ticks, float interp, NBTTagCompound data) {
            double x = data.func_74769_h("x");
            double y = data.func_74769_h("y");
            double z = data.func_74769_h("z");
            int rotation = data.func_74762_e("rotation");
            GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
            GL11.glEnable((int)2896);
            GL11.glShadeModel((int)7425);
            switch (rotation) {
                case 3: {
                    GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 5: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 2: {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 4: {
                    GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            ITileActorRenderer.bindTexture(ResourceManager.gascent_tex);
            ResourceManager.gascent.renderPart("Centrifuge");
            ResourceManager.gascent.renderPart("Flag");
            GL11.glShadeModel((int)7424);
        }

        @Override
        public void updateActor(int ticks, NBTTagCompound data) {
        }
    }
}

