/*
 * Decompiled with CFR 0.152.
 */
package com.nolly.hopperflow;

import com.nolly.hopperflow.libs.kotlin.Metadata;
import com.nolly.hopperflow.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.nolly.hopperflow.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u0003H\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/nolly/hopperflow/ChunkKey;", "", "world", "", "x", "", "z", "<init>", "(Ljava/lang/String;II)V", "getWorld", "()Ljava/lang/String;", "getX", "()I", "getZ", "toString", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "Companion", "HopperFlowGovernor"})
public final class ChunkKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String world;
    private final int x;
    private final int z;

    public ChunkKey(@NotNull String world, int x, int z) {
        Intrinsics.checkNotNullParameter(world, "world");
        this.world = world;
        this.x = x;
        this.z = z;
    }

    @NotNull
    public final String getWorld() {
        return this.world;
    }

    public final int getX() {
        return this.x;
    }

    public final int getZ() {
        return this.z;
    }

    @NotNull
    public String toString() {
        return this.world + ":" + this.x + "," + this.z;
    }

    @NotNull
    public final String component1() {
        return this.world;
    }

    public final int component2() {
        return this.x;
    }

    public final int component3() {
        return this.z;
    }

    @NotNull
    public final ChunkKey copy(@NotNull String world, int x, int z) {
        Intrinsics.checkNotNullParameter(world, "world");
        return new ChunkKey(world, x, z);
    }

    public static /* synthetic */ ChunkKey copy$default(ChunkKey chunkKey, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = chunkKey.world;
        }
        if ((n3 & 2) != 0) {
            n = chunkKey.x;
        }
        if ((n3 & 4) != 0) {
            n2 = chunkKey.z;
        }
        return chunkKey.copy(string, n, n2);
    }

    public int hashCode() {
        int result = this.world.hashCode();
        result = result * 31 + Integer.hashCode(this.x);
        result = result * 31 + Integer.hashCode(this.z);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChunkKey)) {
            return false;
        }
        ChunkKey chunkKey = (ChunkKey)other;
        if (!Intrinsics.areEqual(this.world, chunkKey.world)) {
            return false;
        }
        if (this.x != chunkKey.x) {
            return false;
        }
        return this.z == chunkKey.z;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/nolly/hopperflow/ChunkKey$Companion;", "", "<init>", "()V", "of", "Lcom/nolly/hopperflow/ChunkKey;", "chunk", "Lorg/bukkit/Chunk;", "loc", "Lorg/bukkit/Location;", "HopperFlowGovernor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChunkKey of(@NotNull Chunk chunk) {
            Intrinsics.checkNotNullParameter(chunk, "chunk");
            String string = chunk.getWorld().getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            return new ChunkKey(string, chunk.getX(), chunk.getZ());
        }

        @NotNull
        public final ChunkKey of(@NotNull Location loc) {
            Intrinsics.checkNotNullParameter(loc, "loc");
            World world = loc.getWorld();
            Intrinsics.checkNotNull(world);
            String string = world.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            return new ChunkKey(string, loc.getChunk().getX(), loc.getChunk().getZ());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

