/*
 * Decompiled with CFR 0.152.
 */
package com.nolly.hopperflow;

import com.nolly.hopperflow.ThrottleManager;
import com.nolly.hopperflow.libs.kotlin.Metadata;
import com.nolly.hopperflow.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/nolly/hopperflow/HopperMoveListener;", "Lorg/bukkit/event/Listener;", "manager", "Lcom/nolly/hopperflow/ThrottleManager;", "<init>", "(Lcom/nolly/hopperflow/ThrottleManager;)V", "onMove", "", "e", "Lorg/bukkit/event/inventory/InventoryMoveItemEvent;", "HopperFlowGovernor"})
public final class HopperMoveListener
implements Listener {
    @NotNull
    private final ThrottleManager manager;

    public HopperMoveListener(@NotNull ThrottleManager manager) {
        Intrinsics.checkNotNullParameter(manager, "manager");
        this.manager = manager;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onMove(@NotNull InventoryMoveItemEvent e) {
        Location location;
        Intrinsics.checkNotNullParameter(e, "e");
        Inventory inventory = e.getInitiator();
        Intrinsics.checkNotNullExpressionValue(inventory, "getInitiator(...)");
        Inventory initiator = inventory;
        InventoryHolder inventoryHolder = initiator.getHolder();
        if (inventoryHolder == null) {
            return;
        }
        InventoryHolder holder = inventoryHolder;
        InventoryHolder inventoryHolder2 = holder;
        if (inventoryHolder2 instanceof BlockState) {
            location = ((BlockState)holder).getLocation();
        } else if (inventoryHolder2 instanceof Entity) {
            location = ((Entity)holder).getLocation();
        } else {
            InventoryHolder src = e.getSource().getHolder();
            InventoryHolder inventoryHolder3 = src;
            if (inventoryHolder3 instanceof BlockState) {
                location = ((BlockState)src).getLocation();
            } else if (inventoryHolder3 instanceof Entity) {
                location = ((Entity)src).getLocation();
            } else {
                return;
            }
        }
        Location location2 = location;
        Intrinsics.checkNotNull(location2);
        Location loc = location2;
        boolean allowed = this.manager.allowMove(holder, loc);
        if (!allowed) {
            e.setCancelled(true);
        }
    }
}

