/*
 * Decompiled with CFR 0.152.
 */
package com.nolly.hopperflow.libs.kotlin.uuid;

import com.nolly.hopperflow.libs.kotlin.Metadata;
import com.nolly.hopperflow.libs.kotlin.SinceKotlin;
import com.nolly.hopperflow.libs.kotlin.jvm.internal.Intrinsics;
import com.nolly.hopperflow.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.nolly.hopperflow.libs.kotlin.uuid.ExperimentalUuidApi;
import com.nolly.hopperflow.libs.kotlin.uuid.SecureRandomHolder;
import com.nolly.hopperflow.libs.kotlin.uuid.Uuid;
import com.nolly.hopperflow.libs.kotlin.uuid.UuidKt;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=5, xi=49, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0001\u001a\f\u0010\u0002\u001a\u00020\u0001*\u00020\u0003H\u0007\u001a\u0014\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u001c\u0010\u0006\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0001H\u0007\u001a\u0014\u0010\u0006\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0001H\u0007\u001a\r\u0010\b\u001a\u00020\t*\u00020\tH\u0080\b\u001a\r\u0010\n\u001a\u00020\u000b*\u00020\u0001H\u0087\b\u001a\r\u0010\f\u001a\u00020\u0001*\u00020\u000bH\u0087\b\u00a8\u0006\r"}, d2={"secureRandomUuid", "Lcom/nolly/hopperflow/libs/kotlin/uuid/Uuid;", "getUuid", "Ljava/nio/ByteBuffer;", "index", "", "putUuid", "uuid", "reverseBytes", "", "toJavaUuid", "Ljava/util/UUID;", "toKotlinUuid", "com.nolly.hopperflow.libs.kotlin-stdlib"}, xs="com/nolly/hopperflow/libs/kotlin/uuid/UuidKt")
@SourceDebugExtension(value={"SMAP\nUuidJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UuidJVM.kt\nkotlin/uuid/UuidKt__UuidJVMKt\n*L\n1#1,226:1\n226#1:227\n226#1:228\n226#1:229\n226#1:230\n226#1:231\n226#1:232\n226#1:233\n226#1:234\n*S KotlinDebug\n*F\n+ 1 UuidJVM.kt\nkotlin/uuid/UuidKt__UuidJVMKt\n*L\n88#1:227\n89#1:228\n133#1:229\n134#1:230\n173#1:231\n174#1:232\n220#1:233\n221#1:234\n*E\n"})
class UuidKt__UuidJVMKt {
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid secureRandomUuid() {
        byte[] randomBytes = new byte[16];
        SecureRandomHolder.INSTANCE.getInstance().nextBytes(randomBytes);
        return UuidKt.uuidFromRandomBytes(randomBytes);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid toKotlinUuid(@NotNull UUID $this$toKotlinUuid) {
        Intrinsics.checkNotNullParameter($this$toKotlinUuid, "<this>");
        boolean $i$f$toKotlinUuid = false;
        return Uuid.Companion.fromLongs($this$toKotlinUuid.getMostSignificantBits(), $this$toKotlinUuid.getLeastSignificantBits());
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final UUID toJavaUuid(@NotNull Uuid $this$toJavaUuid) {
        void leastSignificantBits;
        Intrinsics.checkNotNullParameter($this$toJavaUuid, "<this>");
        boolean $i$f$toJavaUuid = false;
        Uuid uuid = $this$toJavaUuid;
        long l = uuid.getLeastSignificantBits();
        long mostSignificantBits = uuid.getMostSignificantBits();
        boolean bl = false;
        return new UUID(mostSignificantBits, (long)leastSignificantBits);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid getUuid(@NotNull ByteBuffer $this$getUuid) {
        Intrinsics.checkNotNullParameter($this$getUuid, "<this>");
        if ($this$getUuid.position() + 15 >= $this$getUuid.limit()) {
            throw new BufferUnderflowException();
        }
        long msb = $this$getUuid.getLong();
        long lsb = $this$getUuid.getLong();
        if (Intrinsics.areEqual($this$getUuid.order(), ByteOrder.LITTLE_ENDIAN)) {
            long $this$reverseBytes$iv = msb;
            boolean $i$f$reverseBytes = false;
            msb = Long.reverseBytes($this$reverseBytes$iv);
            $this$reverseBytes$iv = lsb;
            $i$f$reverseBytes = false;
            lsb = Long.reverseBytes($this$reverseBytes$iv);
        }
        return Uuid.Companion.fromLongs(msb, lsb);
    }

    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final Uuid getUuid(@NotNull ByteBuffer $this$getUuid, int index) {
        Intrinsics.checkNotNullParameter($this$getUuid, "<this>");
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index + 15 >= $this$getUuid.limit()) {
            throw new IndexOutOfBoundsException("Not enough bytes to read a uuid at index: " + index + ", with limit: " + $this$getUuid.limit() + ' ');
        }
        long msb = $this$getUuid.getLong(index);
        long lsb = $this$getUuid.getLong(index + 8);
        if (Intrinsics.areEqual($this$getUuid.order(), ByteOrder.LITTLE_ENDIAN)) {
            long $this$reverseBytes$iv = msb;
            boolean $i$f$reverseBytes = false;
            msb = Long.reverseBytes($this$reverseBytes$iv);
            $this$reverseBytes$iv = lsb;
            $i$f$reverseBytes = false;
            lsb = Long.reverseBytes($this$reverseBytes$iv);
        }
        return Uuid.Companion.fromLongs(msb, lsb);
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final ByteBuffer putUuid(@NotNull ByteBuffer $this$putUuid, @NotNull Uuid uuid) {
        ByteBuffer byteBuffer;
        void lsb;
        Intrinsics.checkNotNullParameter($this$putUuid, "<this>");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Uuid uuid2 = uuid;
        long l = uuid2.getLeastSignificantBits();
        long msb = uuid2.getMostSignificantBits();
        boolean bl = false;
        if ($this$putUuid.position() + 15 >= $this$putUuid.limit()) {
            throw new BufferOverflowException();
        }
        if (Intrinsics.areEqual($this$putUuid.order(), ByteOrder.BIG_ENDIAN)) {
            $this$putUuid.putLong(msb);
            byteBuffer = $this$putUuid.putLong((long)lsb);
        } else {
            long $this$reverseBytes$iv = msb;
            boolean $i$f$reverseBytes = false;
            $this$putUuid.putLong(Long.reverseBytes($this$reverseBytes$iv));
            $this$reverseBytes$iv = lsb;
            $i$f$reverseBytes = false;
            byteBuffer = $this$putUuid.putLong(Long.reverseBytes($this$reverseBytes$iv));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "toLongs(...)");
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @SinceKotlin(version="2.0")
    @ExperimentalUuidApi
    @NotNull
    public static final ByteBuffer putUuid(@NotNull ByteBuffer $this$putUuid, int index, @NotNull Uuid uuid) {
        ByteBuffer byteBuffer;
        void lsb;
        Intrinsics.checkNotNullParameter($this$putUuid, "<this>");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Uuid uuid2 = uuid;
        long l = uuid2.getLeastSignificantBits();
        long msb = uuid2.getMostSignificantBits();
        boolean bl = false;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        if (index + 15 >= $this$putUuid.limit()) {
            throw new IndexOutOfBoundsException("Not enough capacity to write a uuid at index: " + index + ", with limit: " + $this$putUuid.limit() + ' ');
        }
        if (Intrinsics.areEqual($this$putUuid.order(), ByteOrder.BIG_ENDIAN)) {
            $this$putUuid.putLong(index, msb);
            byteBuffer = $this$putUuid.putLong(index + 8, (long)lsb);
        } else {
            long $this$reverseBytes$iv = msb;
            boolean $i$f$reverseBytes = false;
            $this$putUuid.putLong(index, Long.reverseBytes($this$reverseBytes$iv));
            $this$reverseBytes$iv = lsb;
            $i$f$reverseBytes = false;
            byteBuffer = $this$putUuid.putLong(index + 8, Long.reverseBytes($this$reverseBytes$iv));
        }
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "toLongs(...)");
        return byteBuffer;
    }

    public static final long reverseBytes(long $this$reverseBytes) {
        boolean $i$f$reverseBytes = false;
        return Long.reverseBytes($this$reverseBytes);
    }
}

