/*
 * Decompiled with CFR 0.152.
 */
package com.nolly.hopperflow;

import com.nolly.hopperflow.InitiatorType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000fJ\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003J\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010\u001c\u001a\u00020\u0003J\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00030\u001f2\u0006\u0010\u001c\u001a\u00020\u0003J#\u0010!\u001a\u00020\u00032\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010#J/\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00030\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010%J\u0006\u0010&\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/nolly/hopperflow/ChunkStats;", "", "windowSecondsInit", "", "<init>", "(I)V", "windowSeconds", "moves", "", "", "[[I", "throttles", "lastTouchedTick", "Ljava/util/concurrent/atomic/AtomicLong;", "lastSec", "", "reconfigure", "", "newWindowSeconds", "touchTick", "tick", "recordMove", "nowSec", "t", "Lcom/nolly/hopperflow/InitiatorType;", "recordThrottle", "rotate", "sumMoves", "seconds", "sumThrottles", "sumMovesByType", "", "sumThrottlesByType", "sumArray", "arr", "([[II)I", "sumByType", "([[II)Ljava/util/Map;", "lastTick", "HopperFlowGovernor"})
@SourceDebugExtension(value={"SMAP\nChunkStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkStats.kt\ncom/nolly/hopperflow/ChunkStats\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1279#2,2:88\n1293#2,4:90\n1279#2,2:94\n1293#2,4:96\n*S KotlinDebug\n*F\n+ 1 ChunkStats.kt\ncom/nolly/hopperflow/ChunkStats\n*L\n75#1:88,2\n75#1:90,4\n82#1:94,2\n82#1:96,4\n*E\n"})
public final class ChunkStats {
    private int windowSeconds;
    @NotNull
    private int[][] moves;
    @NotNull
    private int[][] throttles;
    @NotNull
    private final AtomicLong lastTouchedTick;
    private long lastSec;

    public ChunkStats(int windowSecondsInit) {
        int n;
        this.windowSeconds = Math.max(10, windowSecondsInit);
        int n2 = 0;
        int n3 = InitiatorType.getEntries().size();
        int[][] nArrayArray = new int[n3][];
        ChunkStats chunkStats = this;
        while (n2 < n3) {
            n = n2++;
            nArrayArray[n] = new int[this.windowSeconds];
        }
        chunkStats.moves = nArrayArray;
        n2 = 0;
        n3 = InitiatorType.getEntries().size();
        nArrayArray = new int[n3][];
        chunkStats = this;
        while (n2 < n3) {
            n = n2++;
            nArrayArray[n] = new int[this.windowSeconds];
        }
        chunkStats.throttles = nArrayArray;
        this.lastTouchedTick = new AtomicLong(0L);
        this.lastSec = -1L;
    }

    public final void reconfigure(int newWindowSeconds) {
        int n;
        int w = Math.max(10, newWindowSeconds);
        if (w == this.windowSeconds) {
            return;
        }
        this.windowSeconds = w;
        int n2 = 0;
        int n3 = InitiatorType.getEntries().size();
        int[][] nArrayArray = new int[n3][];
        ChunkStats chunkStats = this;
        while (n2 < n3) {
            n = n2++;
            nArrayArray[n] = new int[this.windowSeconds];
        }
        chunkStats.moves = nArrayArray;
        n2 = 0;
        n3 = InitiatorType.getEntries().size();
        nArrayArray = new int[n3][];
        chunkStats = this;
        while (n2 < n3) {
            n = n2++;
            nArrayArray[n] = new int[this.windowSeconds];
        }
        chunkStats.throttles = nArrayArray;
        this.lastSec = -1L;
    }

    public final void touchTick(long tick) {
        this.lastTouchedTick.set(tick);
    }

    public final void recordMove(long nowSec, @NotNull InitiatorType t) {
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        this.rotate(nowSec);
        int[] nArray = this.moves[t.ordinal()];
        int n = (int)(nowSec % (long)this.windowSeconds);
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
    }

    public final void recordThrottle(long nowSec, @NotNull InitiatorType t) {
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        this.rotate(nowSec);
        int[] nArray = this.throttles[t.ordinal()];
        int n = (int)(nowSec % (long)this.windowSeconds);
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
    }

    private final void rotate(long nowSec) {
        if (this.lastSec == -1L) {
            this.lastSec = nowSec;
            return;
        }
        if (nowSec == this.lastSec) {
            return;
        }
        long s = this.lastSec + 1L;
        while (s <= nowSec) {
            int idx = (int)(s % (long)this.windowSeconds);
            int n = ((Collection)InitiatorType.getEntries()).size();
            for (int t = 0; t < n; ++t) {
                this.moves[t][idx] = 0;
                this.throttles[t][idx] = 0;
            }
            long l = s;
            s = l + 1L;
        }
        this.lastSec = nowSec;
    }

    public final int sumMoves(int seconds) {
        return this.sumArray(this.moves, seconds);
    }

    public final int sumThrottles(int seconds) {
        return this.sumArray(this.throttles, seconds);
    }

    @NotNull
    public final Map<InitiatorType, Integer> sumMovesByType(int seconds) {
        return this.sumByType(this.moves, seconds);
    }

    @NotNull
    public final Map<InitiatorType, Integer> sumThrottlesByType(int seconds) {
        return this.sumByType(this.throttles, seconds);
    }

    private final int sumArray(int[][] arr, int seconds) {
        int span = RangesKt.coerceAtMost((int)seconds, (int)this.windowSeconds);
        long end = this.lastSec;
        if (end == -1L) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < span; ++i) {
            long sec = end - (long)i;
            int idx = (int)(sec % (long)this.windowSeconds);
            int n = ((Collection)InitiatorType.getEntries()).size();
            for (int t = 0; t < n; ++t) {
                total += arr[t][idx];
            }
        }
        return total;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<InitiatorType, Integer> sumByType(int[][] arr, int seconds) {
        int span = RangesKt.coerceAtMost((int)seconds, (int)this.windowSeconds);
        long end = this.lastSec;
        if (end == -1L) {
            Iterable $this$associateWith$iv = (Iterable)InitiatorType.getEntries();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                InitiatorType initiatorType = (InitiatorType)((Object)element$iv$iv);
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                Integer n = 0;
                map.put(t, n);
            }
            return result$iv;
        }
        int[] out = new int[InitiatorType.getEntries().size()];
        for (int i = 0; i < span; ++i) {
            long sec = end - (long)i;
            int idx = (int)(sec % (long)this.windowSeconds);
            int n = ((Collection)InitiatorType.getEntries()).size();
            for (int t = 0; t < n; ++t) {
                int it = t;
                out[it] = out[it] + arr[t][idx];
            }
        }
        Iterable $this$associateWith$iv = (Iterable)InitiatorType.getEntries();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            InitiatorType bl = (InitiatorType)((Object)element$iv$iv);
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl2 = false;
            Integer n = out[it.ordinal()];
            map.put(t, n);
        }
        return result$iv;
    }

    public final long lastTick() {
        return this.lastTouchedTick.get();
    }
}

