/*
 * Decompiled with CFR 0.152.
 */
package com.nolly.hopperflow;

import com.nolly.hopperflow.ChunkKey;
import com.nolly.hopperflow.HopperFlowPlugin;
import com.nolly.hopperflow.InitiatorType;
import com.nolly.hopperflow.ThrottleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ5\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J;\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/nolly/hopperflow/HopperFlowCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "plugin", "Lcom/nolly/hopperflow/HopperFlowPlugin;", "manager", "Lcom/nolly/hopperflow/ThrottleManager;", "<init>", "(Lcom/nolly/hopperflow/HopperFlowPlugin;Lcom/nolly/hopperflow/ThrottleManager;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "cmd", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "onTabComplete", "", "command", "alias", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "HopperFlowGovernor"})
@SourceDebugExtension(value={"SMAP\nHopperFlowCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HopperFlowCommand.kt\ncom/nolly/hopperflow/HopperFlowCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n774#2:144\n865#2,2:145\n*S KotlinDebug\n*F\n+ 1 HopperFlowCommand.kt\ncom/nolly/hopperflow/HopperFlowCommand\n*L\n129#1:144\n129#1:145,2\n*E\n"})
public final class HopperFlowCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    private final HopperFlowPlugin plugin;
    @NotNull
    private final ThrottleManager manager;

    public HopperFlowCommand(@NotNull HopperFlowPlugin plugin, @NotNull ThrottleManager manager) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "help": {
                if (!sender.hasPermission("hopperflow.command.help")) {
                    sender.sendMessage(ChatColor.RED + "No permission.");
                    return true;
                }
                sender.sendMessage(ChatColor.GOLD + "HopperFlow Commands:");
                sender.sendMessage(ChatColor.YELLOW + "/" + label + " help " + ChatColor.DARK_GRAY + "- " + ChatColor.GRAY + "Show this help message");
                sender.sendMessage(ChatColor.YELLOW + "/" + label + " reload " + ChatColor.DARK_GRAY + "- " + ChatColor.GRAY + "Reload config");
                sender.sendMessage(ChatColor.YELLOW + "/" + label + " inspect " + ChatColor.DARK_GRAY + "- " + ChatColor.GRAY + "Show summary of hopper activity in your current chunk");
                sender.sendMessage(ChatColor.YELLOW + "/" + label + " detail " + ChatColor.DARK_GRAY + "- " + ChatColor.GRAY + "Show detailed breakdown of hopper activity in your current chunk");
                sender.sendMessage(ChatColor.YELLOW + "/" + label + " where [limit] " + ChatColor.DARK_GRAY + "- " + ChatColor.GRAY + "Show top throttled hopper locations in your current chunk (default limit 10, max 50)");
                sender.sendMessage(ChatColor.YELLOW + "/" + label + " top [limit] " + ChatColor.DARK_GRAY + "- " + ChatColor.GRAY + "Show top throttled chunks server-wide in the last stats window (default limit 10, max 50)");
                bl = true;
                break;
            }
            case "reload": {
                if (!sender.hasPermission("hopperflow.command.reload")) {
                    sender.sendMessage(ChatColor.RED + "No permission.");
                    bl = true;
                    break;
                }
                this.plugin.reloadAll();
                sender.sendMessage(ChatColor.YELLOW + "HopperFlow config reloaded.");
                bl = true;
                break;
            }
            case "inspect": {
                if (!sender.hasPermission("hopperflow.command.inspect")) {
                    sender.sendMessage(ChatColor.RED + "No permission.");
                    bl = true;
                    break;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.RED + "Player-only.");
                    return true;
                }
                Location location = ((Player)sender).getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                ChunkKey key = ChunkKey.Companion.of(location);
                ThrottleManager.InspectData d = this.manager.inspect(key, this.plugin.getConfigModel().getStatsWindowSeconds());
                sender.sendMessage(ChatColor.AQUA + "Chunk " + key.getX() + "," + key.getZ() + " \u2014 " + key.getWorld());
                sender.sendMessage(ChatColor.GRAY + "Moves: " + ChatColor.WHITE + d.getMoved() + " " + ChatColor.GRAY + " Throttled: " + ChatColor.WHITE + d.getThrottled() + " " + ChatColor.DARK_GRAY + "(last " + this.plugin.getConfigModel().getStatsWindowSeconds() + "s)");
                sender.sendMessage(ChatColor.GRAY + "Rate: " + ChatColor.WHITE + d.getRatePerSec() + "/s " + ChatColor.GRAY + "Burst: " + ChatColor.WHITE + d.getBurst());
                bl = true;
                break;
            }
            case "detail": {
                if (!sender.hasPermission("hopperflow.command.detail")) {
                    sender.sendMessage(ChatColor.RED + "No permission.");
                    bl = true;
                    break;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.RED + "Player-only.");
                    return true;
                }
                Location location = ((Player)sender).getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                ChunkKey key = ChunkKey.Companion.of(location);
                ThrottleManager.DetailData d = this.manager.detail(key, this.plugin.getConfigModel().getStatsWindowSeconds());
                sender.sendMessage(ChatColor.GOLD + "Breakdown (last " + this.plugin.getConfigModel().getStatsWindowSeconds() + "s) @ " + key.getWorld() + " " + key.getX() + "," + key.getZ());
                for (InitiatorType t : InitiatorType.getEntries()) {
                    int th;
                    Integer n = d.getMovesByType().get((Object)t);
                    int mv = n != null ? n : 0;
                    Integer n2 = d.getThrottlesByType().get((Object)t);
                    int n3 = th = n2 != null ? n2 : 0;
                    if (mv <= 0 && th <= 0) continue;
                    String string2 = t.name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    sender.sendMessage(ChatColor.GRAY + "- " + string2 + "  " + ChatColor.WHITE + "moves=" + mv + "  " + ChatColor.RED + "throttled=" + th);
                }
                bl = true;
                break;
            }
            case "where": {
                if (!sender.hasPermission("hopperflow.command.where")) {
                    sender.sendMessage(ChatColor.RED + "No permission.");
                    bl = true;
                    break;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(ChatColor.RED + "Player-only.");
                    return true;
                }
                Location location = ((Player)sender).getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                ChunkKey key = ChunkKey.Companion.of(location);
                Object object = (String)ArraysKt.getOrNull((Object[])args, (int)1);
                int limit = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? RangesKt.coerceIn((int)((Integer)object), (int)1, (int)50) : 10;
                List<ThrottleManager.LocationHit> list = this.manager.where(key, limit);
                if (list.isEmpty()) {
                    sender.sendMessage(ChatColor.YELLOW + "No throttled locations recorded for this chunk.");
                } else {
                    sender.sendMessage(ChatColor.GOLD + "Top throttled locations @ " + key.getWorld() + " " + key.getX() + "," + key.getZ() + ":");
                    int i = 1;
                    for (ThrottleManager.LocationHit h : list) {
                        int n = h.getX();
                        int n4 = h.getY();
                        int n5 = h.getZ();
                        String string3 = h.getType().name().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                        sender.sendMessage(ChatColor.GRAY + i + ". " + ChatColor.WHITE + n + "," + n4 + "," + n5 + " " + ChatColor.DARK_GRAY + "(" + string3 + ") " + ChatColor.RED + "throttled=" + h.getThrottledCount());
                        ++i;
                    }
                }
                bl = true;
                break;
            }
            case "top": {
                if (!sender.hasPermission("hopperflow.command.top")) {
                    sender.sendMessage(ChatColor.RED + "No permission.");
                    bl = true;
                    break;
                }
                Object object = (String)ArraysKt.getOrNull((Object[])args, (int)1);
                int limit = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? RangesKt.coerceIn((int)((Integer)object), (int)1, (int)50) : 10;
                List<Pair<ChunkKey, Integer>> list = this.manager.top(this.plugin.getConfigModel().getStatsWindowSeconds(), limit);
                if (list.isEmpty()) {
                    sender.sendMessage(ChatColor.YELLOW + "No throttled chunks in the last " + this.plugin.getConfigModel().getStatsWindowSeconds() + "s.");
                } else {
                    sender.sendMessage(ChatColor.GOLD + "Top throttled chunks (" + this.plugin.getConfigModel().getStatsWindowSeconds() + "s):");
                    int i = 1;
                    for (Pair<ChunkKey, Integer> pair : list) {
                        ChunkKey key = (ChunkKey)pair.component1();
                        int count = ((Number)pair.component2()).intValue();
                        sender.sendMessage(ChatColor.GRAY + i + ". " + ChatColor.WHITE + key.getWorld() + " " + key.getX() + "," + key.getZ() + " " + ChatColor.DARK_GRAY + "- " + ChatColor.RED + count);
                        ++i;
                    }
                }
                bl = true;
                break;
            }
            default: {
                sender.sendMessage(ChatColor.RED + "Unknown subcommand.");
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        switch (args.length) {
            case 0: {
                Object[] objectArray = new String[]{"help", "top", "inspect", "detail", "where", "reload"};
                return CollectionsKt.mutableListOf((Object[])objectArray);
            }
            case 1: {
                void $this$filterTo$iv$iv;
                Object[] objectArray = new String[]{"help", "top", "inspect", "detail", "where", "reload"};
                Iterable $this$filter$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith((String)it, (String)args[0], (boolean)true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            }
            case 2: {
                if (!StringsKt.equals((String)args[0], (String)"top", (boolean)true) && !StringsKt.equals((String)args[0], (String)"where", (boolean)true)) break;
                Object[] objectArray = new String[]{"5", "10", "20", "30", "50"};
                return CollectionsKt.toMutableList((Collection)CollectionsKt.listOf((Object[])objectArray));
            }
        }
        return new ArrayList();
    }
}

