/*
 * Decompiled with CFR 0.152.
 */
package com.nolly.hopperflow;

import com.nolly.hopperflow.ChunkKey;
import com.nolly.hopperflow.ChunkStats;
import com.nolly.hopperflow.InitiatorType;
import com.nolly.hopperflow.PluginConfig;
import com.nolly.hopperflow.TokenBucket;
import com.nolly.hopperflow.WG;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Dropper;
import org.bukkit.block.Hopper;
import org.bukkit.block.TileState;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003>?@B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005J\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u001cJ\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\nJ\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\fH\u0002J\u0010\u0010)\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010*\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\fH\u0002J\u0010\u0010,\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0001H\u0002J(\u0010-\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020#2\u0006\u0010+\u001a\u00020\fH\u0002J\u0018\u00100\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010+\u001a\u00020\fH\u0002J\u0018\u00101\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\n2\u0006\u00102\u001a\u00020&H\u0002J(\u00103\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001305042\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0013J\u0016\u00108\u001a\u0002092\u0006\u0010!\u001a\u00020\n2\u0006\u00106\u001a\u00020\u0013J\u0016\u0010:\u001a\u00020;2\u0006\u0010!\u001a\u00020\n2\u0006\u00106\u001a\u00020\u0013J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020=042\u0006\u0010!\u001a\u00020\n2\u0006\u00107\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/nolly/hopperflow/ThrottleManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "cfg", "Lcom/nolly/hopperflow/PluginConfig;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/nolly/hopperflow/PluginConfig;)V", "perChunkBuckets", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/nolly/hopperflow/ChunkKey;", "Ljava/util/EnumMap;", "Lcom/nolly/hopperflow/InitiatorType;", "Lcom/nolly/hopperflow/TokenBucket;", "stats", "Lcom/nolly/hopperflow/ChunkStats;", "hotspots", "", "", "", "globalBucket", "exemptMetaKey", "exemptPdcKey", "Lorg/bukkit/NamespacedKey;", "tickCounter", "", "wgHook", "applyConfig", "", "newCfg", "onTick", "shutdown", "resetChunk", "key", "allowMove", "", "holder", "loc", "Lorg/bukkit/Location;", "isTypeIncluded", "t", "isExemptByRegion", "isExemptByName", "type", "isExemptByFlag", "record", "move", "throttled", "bumpHotspot", "notifyIfNeeded", "at", "top", "", "Lkotlin/Pair;", "seconds", "limit", "inspect", "Lcom/nolly/hopperflow/ThrottleManager$InspectData;", "detail", "Lcom/nolly/hopperflow/ThrottleManager$DetailData;", "where", "Lcom/nolly/hopperflow/ThrottleManager$LocationHit;", "InspectData", "DetailData", "LocationHit", "HopperFlowGovernor"})
@SourceDebugExtension(value={"SMAP\nThrottleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrottleManager.kt\ncom/nolly/hopperflow/ThrottleManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n216#2,2:250\n1863#3,2:252\n1863#3,2:254\n295#3,2:256\n1557#3:258\n1628#3,3:259\n774#3:262\n865#3,2:263\n1062#3:265\n1062#3:266\n1557#3:267\n1628#3,3:268\n*S KotlinDebug\n*F\n+ 1 ThrottleManager.kt\ncom/nolly/hopperflow/ThrottleManager\n*L\n38#1:250,2\n44#1:252,2\n49#1:254,2\n148#1:256,2\n203#1:258\n203#1:259,3\n203#1:262\n203#1:263,2\n204#1:265\n224#1:266\n224#1:267\n224#1:268,3\n*E\n"})
public final class ThrottleManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private PluginConfig cfg;
    @NotNull
    private final ConcurrentHashMap<ChunkKey, EnumMap<InitiatorType, TokenBucket>> perChunkBuckets;
    @NotNull
    private final ConcurrentHashMap<ChunkKey, ChunkStats> stats;
    @NotNull
    private final ConcurrentHashMap<ChunkKey, Map<String, Integer>> hotspots;
    @NotNull
    private final TokenBucket globalBucket;
    @NotNull
    private final String exemptMetaKey;
    @NotNull
    private final NamespacedKey exemptPdcKey;
    private long tickCounter;
    @Nullable
    private final Object wgHook;

    /*
     * WARNING - void declaration
     */
    public ThrottleManager(@NotNull Plugin plugin, @NotNull PluginConfig cfg) {
        void $this$wgHook_u24lambda_u240;
        boolean installed;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        this.plugin = plugin;
        this.cfg = cfg;
        this.perChunkBuckets = new ConcurrentHashMap();
        this.stats = new ConcurrentHashMap();
        this.hotspots = new ConcurrentHashMap();
        this.globalBucket = new TokenBucket(this.cfg.getMaxGlobalRate(), Math.max(1.0, this.cfg.getMaxGlobalRate()));
        this.exemptMetaKey = "hopperflow.exempt";
        this.exemptPdcKey = new NamespacedKey(this.plugin, "exempt");
        ThrottleManager throttleManager = this;
        ThrottleManager throttleManager2 = this;
        boolean bl = false;
        boolean bl2 = installed = Bukkit.getPluginManager().getPlugin("WorldGuard") != null;
        throttleManager2.wgHook = !installed ? null : WG.INSTANCE.tryInit($this$wgHook_u24lambda_u240.plugin);
    }

    public final void applyConfig(@NotNull PluginConfig newCfg) {
        Map.Entry element$iv;
        Intrinsics.checkNotNullParameter((Object)newCfg, (String)"newCfg");
        this.cfg = newCfg;
        this.globalBucket.configure(this.cfg.getMaxGlobalRate(), Math.max(1.0, this.cfg.getMaxGlobalRate()));
        Object $this$forEach$iv = this.perChunkBuckets;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            EnumMap map = (EnumMap)entry.getValue();
            for (InitiatorType t : InitiatorType.getEntries()) {
                Pair<Double, Double> pair = this.cfg.effectiveLimits(t);
                TokenBucket tokenBucket = (TokenBucket)map.get((Object)t);
                if (tokenBucket == null) continue;
                tokenBucket.configure(((Number)pair.getFirst()).doubleValue(), ((Number)pair.getSecond()).doubleValue());
            }
        }
        Collection<ChunkStats> collection = this.stats.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        $this$forEach$iv = collection;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            ChunkStats it = (ChunkStats)((Object)element$iv);
            boolean bl = false;
            it.reconfigure(this.cfg.getStatsWindowSeconds());
        }
    }

    public final void onTick() {
        long l = this.tickCounter;
        this.tickCounter = l + 1L;
        Collection<EnumMap<InitiatorType, TokenBucket>> collection = this.perChunkBuckets.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EnumMap m = (EnumMap)element$iv;
            boolean bl = false;
            Collection collection2 = m.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
            Iterable $this$forEach$iv2 = collection2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TokenBucket it = (TokenBucket)element$iv2;
                boolean bl2 = false;
                it.refill(1);
            }
        }
        this.globalBucket.refill(1);
        if (this.tickCounter % 600L == 0L) {
            long cutoffTicks = (long)this.cfg.getCleanupAfterMinutes() * 60L * 20L;
            long threshold = this.tickCounter - cutoffTicks;
            this.stats.entrySet().removeIf(arg_0 -> ThrottleManager.onTick$lambda$6(arg_0 -> ThrottleManager.onTick$lambda$5(threshold, arg_0), arg_0));
            ((ConcurrentHashMap.KeySetView)this.perChunkBuckets.keySet()).removeIf(arg_0 -> ThrottleManager.onTick$lambda$8(arg_0 -> ThrottleManager.onTick$lambda$7(this, arg_0), arg_0));
            ((ConcurrentHashMap.KeySetView)this.hotspots.keySet()).removeIf(arg_0 -> ThrottleManager.onTick$lambda$10(arg_0 -> ThrottleManager.onTick$lambda$9(this, arg_0), arg_0));
        }
    }

    public final void shutdown() {
        this.perChunkBuckets.clear();
        this.stats.clear();
        this.hotspots.clear();
    }

    public final void resetChunk(@NotNull ChunkKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.perChunkBuckets.remove(key);
        this.stats.remove(key);
        this.hotspots.remove(key);
    }

    public final boolean allowMove(@NotNull Object holder, @NotNull Location loc) {
        InitiatorType type;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        Object object = holder;
        InitiatorType initiatorType = object instanceof Hopper ? InitiatorType.HOPPER_BLOCK : (object instanceof HopperMinecart ? InitiatorType.HOPPER_MINECART : (object instanceof Dropper ? InitiatorType.DROPPER : (type = object instanceof Dispenser ? InitiatorType.DISPENSER : InitiatorType.OTHER)));
        if (!this.isTypeIncluded(type)) {
            this.record(loc, true, false, type);
            return true;
        }
        World world = loc.getWorld();
        Intrinsics.checkNotNull((Object)world);
        String string = world.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String w = string2;
        if (this.cfg.getExemptWorlds().contains(w) || this.isExemptByRegion(loc) || this.isExemptByName(holder, type) || this.isExemptByFlag(holder)) {
            this.record(loc, true, false, type);
            return true;
        }
        if (!this.globalBucket.tryTake()) {
            this.record(loc, false, true, type);
            this.bumpHotspot(loc, type);
            this.notifyIfNeeded(ChunkKey.Companion.of(loc), loc);
            return false;
        }
        ChunkKey key = ChunkKey.Companion.of(loc);
        EnumMap enumMap = this.perChunkBuckets.computeIfAbsent(key, arg_0 -> ThrottleManager.allowMove$lambda$12(ThrottleManager::allowMove$lambda$11, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)enumMap, (String)"computeIfAbsent(...)");
        EnumMap map = enumMap;
        Pair<Double, Double> pair = this.cfg.effectiveLimits(type);
        double rate = ((Number)pair.component1()).doubleValue();
        double burst = ((Number)pair.component2()).doubleValue();
        TokenBucket bucket = map.computeIfAbsent(type, arg_0 -> ThrottleManager.allowMove$lambda$14(arg_0 -> ThrottleManager.allowMove$lambda$13(rate, burst, arg_0), arg_0));
        boolean allowed = bucket.tryTake();
        this.record(loc, allowed, !allowed, type);
        if (!allowed) {
            this.bumpHotspot(loc, type);
            this.notifyIfNeeded(key, loc);
        }
        return allowed;
    }

    private final boolean isTypeIncluded(InitiatorType t) {
        return switch (WhenMappings.$EnumSwitchMapping$0[t.ordinal()]) {
            case 1 -> this.cfg.getIncludeHopperBlocks();
            case 2 -> this.cfg.getIncludeHopperMinecarts();
            case 3 -> this.cfg.getIncludeDroppers();
            case 4 -> this.cfg.getIncludeDispensers();
            default -> false;
        };
    }

    private final boolean isExemptByRegion(Location loc) {
        boolean bl;
        if (this.wgHook == null || this.cfg.getExemptRegions().isEmpty()) {
            return false;
        }
        try {
            bl = WG.INSTANCE.isInAnyExemptRegion(this.wgHook, loc, this.cfg.getExemptRegions());
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private final boolean isExemptByName(Object holder, InitiatorType type) {
        String name;
        String prefix = this.cfg.prefixFor(type);
        if (((CharSequence)prefix).length() == 0) {
            return false;
        }
        Object object = holder;
        String string = name = object instanceof Hopper ? ((Hopper)holder).getCustomName() : (object instanceof HopperMinecart ? ((HopperMinecart)holder).getCustomName() : (object instanceof Dropper ? ((Dropper)holder).getCustomName() : (object instanceof Dispenser ? ((Dispenser)holder).getCustomName() : null)));
        return string != null ? StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null) : false;
    }

    private final boolean isExemptByFlag(Object holder) {
        if (holder instanceof Hopper) {
            Block block = ((Hopper)holder).getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            Block block2 = block;
            if (block2.hasMetadata(this.exemptMetaKey)) {
                Boolean v;
                Object v2;
                block7: {
                    List list = block2.getMetadata(this.exemptMetaKey);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMetadata(...)");
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        MetadataValue it = (MetadataValue)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getOwningPlugin(), (Object)this.plugin)) continue;
                        v2 = element$iv;
                        break block7;
                    }
                    v2 = null;
                }
                MetadataValue metadataValue = v2;
                Boolean bl = v = metadataValue != null ? Boolean.valueOf(metadataValue.asBoolean()) : null;
                if (Intrinsics.areEqual((Object)v, (Object)true)) {
                    return true;
                }
            }
            BlockState blockState = block2.getState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getState(...)");
            BlockState state = blockState;
            if (state instanceof TileState) {
                PersistentDataContainer persistentDataContainer = ((TileState)state).getPersistentDataContainer();
                Intrinsics.checkNotNullExpressionValue((Object)persistentDataContainer, (String)"getPersistentDataContainer(...)");
                PersistentDataContainer pdc = persistentDataContainer;
                if (pdc.has(this.exemptPdcKey)) {
                    Object object = pdc.getOrDefault(this.exemptPdcKey, PersistentDataType.BYTE, (Object)0);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
                    byte b = ((Number)object).byteValue();
                    if (b != 0) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final void record(Location loc, boolean move, boolean throttled, InitiatorType type) {
        ChunkKey key = ChunkKey.Companion.of(loc);
        long nowSec = System.currentTimeMillis() / 1000L;
        ChunkStats chunkStats = this.stats.computeIfAbsent(key, arg_0 -> ThrottleManager.record$lambda$17(arg_0 -> ThrottleManager.record$lambda$16(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)chunkStats, (String)"computeIfAbsent(...)");
        ChunkStats s = chunkStats;
        s.touchTick(this.tickCounter);
        if (move) {
            s.recordMove(nowSec, type);
        }
        if (throttled) {
            s.recordThrottle(nowSec, type);
        }
    }

    private final void bumpHotspot(Location loc, InitiatorType type) {
        ChunkKey key = ChunkKey.Companion.of(loc);
        Map map = this.hotspots.computeIfAbsent(key, arg_0 -> ThrottleManager.bumpHotspot$lambda$19(ThrottleManager::bumpHotspot$lambda$18, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"computeIfAbsent(...)");
        Map map2 = map;
        String id = loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ() + "|" + type.name();
        map2.merge(id, 1, (arg_0, arg_1) -> ThrottleManager.bumpHotspot$lambda$21(ThrottleManager::bumpHotspot$lambda$20, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private final void notifyIfNeeded(ChunkKey key, Location at) {
        if (!this.cfg.getNotifyPlayers()) {
            return;
        }
        double r2 = this.cfg.getNotifyRadius() * this.cfg.getNotifyRadius();
        int cx = key.getX() * 16 + 8;
        int cz = key.getZ() * 16 + 8;
        World world = at.getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        for (Object e : world2.getPlayers()) {
            double dz;
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Player p = (Player)e;
            double dx = p.getLocation().getX() - (double)cx;
            if (!(dx * dx + (dz = p.getLocation().getZ() - (double)cz) * dz <= r2)) continue;
            if (p.hasPermission("hopperflow.notify")) {
                void $this$notifyIfNeeded_u24lambda_u2422;
                TextComponent textComponent;
                TextComponent textComponent2 = textComponent = new TextComponent("Hoppers throttled here (chunk " + key.getX() + "," + key.getZ() + ")");
                ChatMessageType chatMessageType = ChatMessageType.ACTION_BAR;
                Player.Spigot spigot = p.spigot();
                boolean bl = false;
                $this$notifyIfNeeded_u24lambda_u2422.setColor(ChatColor.RED);
                Unit unit = Unit.INSTANCE;
                spigot.sendMessage(chatMessageType, (BaseComponent)textComponent);
            }
            this.plugin.getLogger().info("\u001b[31mHoppers throttled near player " + p.getName() + " at " + world2.getName() + ":" + at.getBlockX() + "," + at.getBlockY() + "," + at.getBlockZ() + " (chunk " + key.getX() + "," + key.getZ() + ")\u001b[0m");
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<ChunkKey, Integer>> top(int seconds, int limit) {
        void $this$sortedByDescending$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Pair it;
        void $this$mapTo$iv$iv;
        int sec = RangesKt.coerceAtLeast((int)seconds, (int)5);
        Set<Map.Entry<ChunkKey, ChunkStats>> set = this.stats.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), (Object)((ChunkStats)it.getValue()).sumThrottles(sec)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getSecond()).intValue() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getSecond()));
            }
        }), (int)limit);
    }

    @NotNull
    public final InspectData inspect(@NotNull ChunkKey key, int seconds) {
        ChunkStats s;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ChunkStats chunkStats = s = this.stats.get(key);
        int throttled = chunkStats != null ? chunkStats.sumThrottles(seconds) : 0;
        ChunkStats chunkStats2 = s;
        int moved = chunkStats2 != null ? chunkStats2.sumMoves(seconds) : 0;
        Pair<Double, Double> pair = this.cfg.effectiveLimits(InitiatorType.HOPPER_BLOCK);
        double rate = ((Number)pair.component1()).doubleValue();
        double burst = ((Number)pair.component2()).doubleValue();
        return new InspectData(moved, throttled, 0.0, burst, rate, burst);
    }

    @NotNull
    public final DetailData detail(@NotNull ChunkKey key, int seconds) {
        Map<InitiatorType, Integer> map;
        Map<InitiatorType, Integer> moves;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ChunkStats s = this.stats.get(key);
        Object object = s;
        if (object == null || (object = ((ChunkStats)object).sumMovesByType(seconds)) == null) {
            object = moves = MapsKt.emptyMap();
        }
        if ((map = s) == null || (map = ((ChunkStats)((Object)map)).sumThrottlesByType(seconds)) == null) {
            map = MapsKt.emptyMap();
        }
        Map<InitiatorType, Integer> throttles = map;
        return new DetailData(moves, throttles);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocationHit> where(@NotNull ChunkKey key, int limit) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, Integer> map = this.hotspots.get(key);
        if (map == null) {
            return CollectionsKt.emptyList();
        }
        Map<String, Integer> map2 = map;
        Iterable $this$sortedByDescending$iv = map2.entrySet();
        boolean $i$f$sortedByDescending = false;
        Iterable $this$map$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getValue()));
            }
        }), (int)limit);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String k = (String)entry.getKey();
            int count = ((Number)entry.getValue()).intValue();
            char[] cArray = new char[]{'|'};
            List parts = StringsKt.split$default((CharSequence)k, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            char[] cArray2 = new char[]{','};
            List xyz = StringsKt.split$default((CharSequence)((CharSequence)parts.get(0)), (char[])cArray2, (boolean)false, (int)0, (int)6, null);
            InitiatorType type = InitiatorType.valueOf((String)parts.get(1));
            collection.add(new LocationHit(Integer.parseInt((String)xyz.get(0)), Integer.parseInt((String)xyz.get(1)), Integer.parseInt((String)xyz.get(2)), type, count));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean onTick$lambda$5(long $threshold, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((ChunkStats)it.getValue()).lastTick() < $threshold;
    }

    private static final boolean onTick$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean onTick$lambda$7(ThrottleManager this$0, ChunkKey key) {
        return !this$0.stats.containsKey(key);
    }

    private static final boolean onTick$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean onTick$lambda$9(ThrottleManager this$0, ChunkKey key) {
        return !this$0.stats.containsKey(key);
    }

    private static final boolean onTick$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final EnumMap allowMove$lambda$11(ChunkKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new EnumMap(InitiatorType.class);
    }

    private static final EnumMap allowMove$lambda$12(Function1 $tmp0, Object p0) {
        return (EnumMap)$tmp0.invoke(p0);
    }

    private static final TokenBucket allowMove$lambda$13(double $rate, double $burst, InitiatorType it) {
        return new TokenBucket($rate, $burst);
    }

    private static final TokenBucket allowMove$lambda$14(Function1 $tmp0, Object p0) {
        return (TokenBucket)$tmp0.invoke(p0);
    }

    private static final ChunkStats record$lambda$16(ThrottleManager this$0, ChunkKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ChunkStats(this$0.cfg.getStatsWindowSeconds());
    }

    private static final ChunkStats record$lambda$17(Function1 $tmp0, Object p0) {
        return (ChunkStats)$tmp0.invoke(p0);
    }

    private static final Map bumpHotspot$lambda$18(ChunkKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ConcurrentHashMap();
    }

    private static final Map bumpHotspot$lambda$19(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Integer bumpHotspot$lambda$20(Integer a, Integer b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a + b;
    }

    private static final Integer bumpHotspot$lambda$21(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J5\u0010\u000e\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/nolly/hopperflow/ThrottleManager$DetailData;", "", "movesByType", "", "Lcom/nolly/hopperflow/InitiatorType;", "", "throttlesByType", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "getMovesByType", "()Ljava/util/Map;", "getThrottlesByType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "HopperFlowGovernor"})
    public static final class DetailData {
        @NotNull
        private final Map<InitiatorType, Integer> movesByType;
        @NotNull
        private final Map<InitiatorType, Integer> throttlesByType;

        public DetailData(@NotNull Map<InitiatorType, Integer> movesByType, @NotNull Map<InitiatorType, Integer> throttlesByType) {
            Intrinsics.checkNotNullParameter(movesByType, (String)"movesByType");
            Intrinsics.checkNotNullParameter(throttlesByType, (String)"throttlesByType");
            this.movesByType = movesByType;
            this.throttlesByType = throttlesByType;
        }

        @NotNull
        public final Map<InitiatorType, Integer> getMovesByType() {
            return this.movesByType;
        }

        @NotNull
        public final Map<InitiatorType, Integer> getThrottlesByType() {
            return this.throttlesByType;
        }

        @NotNull
        public final Map<InitiatorType, Integer> component1() {
            return this.movesByType;
        }

        @NotNull
        public final Map<InitiatorType, Integer> component2() {
            return this.throttlesByType;
        }

        @NotNull
        public final DetailData copy(@NotNull Map<InitiatorType, Integer> movesByType, @NotNull Map<InitiatorType, Integer> throttlesByType) {
            Intrinsics.checkNotNullParameter(movesByType, (String)"movesByType");
            Intrinsics.checkNotNullParameter(throttlesByType, (String)"throttlesByType");
            return new DetailData(movesByType, throttlesByType);
        }

        public static /* synthetic */ DetailData copy$default(DetailData detailData, Map map, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map = detailData.movesByType;
            }
            if ((n & 2) != 0) {
                map2 = detailData.throttlesByType;
            }
            return detailData.copy(map, map2);
        }

        @NotNull
        public String toString() {
            return "DetailData(movesByType=" + this.movesByType + ", throttlesByType=" + this.throttlesByType + ")";
        }

        public int hashCode() {
            int result = ((Object)this.movesByType).hashCode();
            result = result * 31 + ((Object)this.throttlesByType).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DetailData)) {
                return false;
            }
            DetailData detailData = (DetailData)other;
            if (!Intrinsics.areEqual(this.movesByType, detailData.movesByType)) {
                return false;
            }
            return Intrinsics.areEqual(this.throttlesByType, detailData.throttlesByType);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/nolly/hopperflow/ThrottleManager$InspectData;", "", "moved", "", "throttled", "tokensNow", "", "burst", "ratePerSec", "burstConfigured", "<init>", "(IIDDDD)V", "getMoved", "()I", "getThrottled", "getTokensNow", "()D", "getBurst", "getRatePerSec", "getBurstConfigured", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "HopperFlowGovernor"})
    public static final class InspectData {
        private final int moved;
        private final int throttled;
        private final double tokensNow;
        private final double burst;
        private final double ratePerSec;
        private final double burstConfigured;

        public InspectData(int moved, int throttled, double tokensNow, double burst, double ratePerSec, double burstConfigured) {
            this.moved = moved;
            this.throttled = throttled;
            this.tokensNow = tokensNow;
            this.burst = burst;
            this.ratePerSec = ratePerSec;
            this.burstConfigured = burstConfigured;
        }

        public final int getMoved() {
            return this.moved;
        }

        public final int getThrottled() {
            return this.throttled;
        }

        public final double getTokensNow() {
            return this.tokensNow;
        }

        public final double getBurst() {
            return this.burst;
        }

        public final double getRatePerSec() {
            return this.ratePerSec;
        }

        public final double getBurstConfigured() {
            return this.burstConfigured;
        }

        public final int component1() {
            return this.moved;
        }

        public final int component2() {
            return this.throttled;
        }

        public final double component3() {
            return this.tokensNow;
        }

        public final double component4() {
            return this.burst;
        }

        public final double component5() {
            return this.ratePerSec;
        }

        public final double component6() {
            return this.burstConfigured;
        }

        @NotNull
        public final InspectData copy(int moved, int throttled, double tokensNow, double burst, double ratePerSec, double burstConfigured) {
            return new InspectData(moved, throttled, tokensNow, burst, ratePerSec, burstConfigured);
        }

        public static /* synthetic */ InspectData copy$default(InspectData inspectData, int n, int n2, double d, double d2, double d3, double d4, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = inspectData.moved;
            }
            if ((n3 & 2) != 0) {
                n2 = inspectData.throttled;
            }
            if ((n3 & 4) != 0) {
                d = inspectData.tokensNow;
            }
            if ((n3 & 8) != 0) {
                d2 = inspectData.burst;
            }
            if ((n3 & 0x10) != 0) {
                d3 = inspectData.ratePerSec;
            }
            if ((n3 & 0x20) != 0) {
                d4 = inspectData.burstConfigured;
            }
            return inspectData.copy(n, n2, d, d2, d3, d4);
        }

        @NotNull
        public String toString() {
            return "InspectData(moved=" + this.moved + ", throttled=" + this.throttled + ", tokensNow=" + this.tokensNow + ", burst=" + this.burst + ", ratePerSec=" + this.ratePerSec + ", burstConfigured=" + this.burstConfigured + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.moved);
            result = result * 31 + Integer.hashCode(this.throttled);
            result = result * 31 + Double.hashCode(this.tokensNow);
            result = result * 31 + Double.hashCode(this.burst);
            result = result * 31 + Double.hashCode(this.ratePerSec);
            result = result * 31 + Double.hashCode(this.burstConfigured);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InspectData)) {
                return false;
            }
            InspectData inspectData = (InspectData)other;
            if (this.moved != inspectData.moved) {
                return false;
            }
            if (this.throttled != inspectData.throttled) {
                return false;
            }
            if (Double.compare(this.tokensNow, inspectData.tokensNow) != 0) {
                return false;
            }
            if (Double.compare(this.burst, inspectData.burst) != 0) {
                return false;
            }
            if (Double.compare(this.ratePerSec, inspectData.ratePerSec) != 0) {
                return false;
            }
            return Double.compare(this.burstConfigured, inspectData.burstConfigured) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/nolly/hopperflow/ThrottleManager$LocationHit;", "", "x", "", "y", "z", "type", "Lcom/nolly/hopperflow/InitiatorType;", "throttledCount", "<init>", "(IIILcom/nolly/hopperflow/InitiatorType;I)V", "getX", "()I", "getY", "getZ", "getType", "()Lcom/nolly/hopperflow/InitiatorType;", "getThrottledCount", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "HopperFlowGovernor"})
    public static final class LocationHit {
        private final int x;
        private final int y;
        private final int z;
        @NotNull
        private final InitiatorType type;
        private final int throttledCount;

        public LocationHit(int x, int y, int z, @NotNull InitiatorType type, int throttledCount) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.x = x;
            this.y = y;
            this.z = z;
            this.type = type;
            this.throttledCount = throttledCount;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getZ() {
            return this.z;
        }

        @NotNull
        public final InitiatorType getType() {
            return this.type;
        }

        public final int getThrottledCount() {
            return this.throttledCount;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        public final int component3() {
            return this.z;
        }

        @NotNull
        public final InitiatorType component4() {
            return this.type;
        }

        public final int component5() {
            return this.throttledCount;
        }

        @NotNull
        public final LocationHit copy(int x, int y, int z, @NotNull InitiatorType type, int throttledCount) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new LocationHit(x, y, z, type, throttledCount);
        }

        public static /* synthetic */ LocationHit copy$default(LocationHit locationHit, int n, int n2, int n3, InitiatorType initiatorType, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = locationHit.x;
            }
            if ((n5 & 2) != 0) {
                n2 = locationHit.y;
            }
            if ((n5 & 4) != 0) {
                n3 = locationHit.z;
            }
            if ((n5 & 8) != 0) {
                initiatorType = locationHit.type;
            }
            if ((n5 & 0x10) != 0) {
                n4 = locationHit.throttledCount;
            }
            return locationHit.copy(n, n2, n3, initiatorType, n4);
        }

        @NotNull
        public String toString() {
            return "LocationHit(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", type=" + this.type + ", throttledCount=" + this.throttledCount + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            result = result * 31 + Integer.hashCode(this.z);
            result = result * 31 + this.type.hashCode();
            result = result * 31 + Integer.hashCode(this.throttledCount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LocationHit)) {
                return false;
            }
            LocationHit locationHit = (LocationHit)other;
            if (this.x != locationHit.x) {
                return false;
            }
            if (this.y != locationHit.y) {
                return false;
            }
            if (this.z != locationHit.z) {
                return false;
            }
            if (this.type != locationHit.type) {
                return false;
            }
            return this.throttledCount == locationHit.throttledCount;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InitiatorType.values().length];
            try {
                nArray[InitiatorType.HOPPER_BLOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InitiatorType.HOPPER_MINECART.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InitiatorType.DROPPER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InitiatorType.DISPENSER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

