/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.driver.arch.darwin;

import com.sun.jna.Native;
import java.util.Locale;
import moe.caramel.chat.Main;
import moe.caramel.chat.controller.ScreenController;
import moe.caramel.chat.driver.IController;
import moe.caramel.chat.driver.IOperator;
import moe.caramel.chat.driver.KeyboardStatus;
import moe.caramel.chat.driver.arch.darwin.DarwinOperator;
import moe.caramel.chat.driver.arch.darwin.Driver_Darwin;
import moe.caramel.chat.util.ModLogger;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import net.minecraft.client.gui.screens.Screen;

public final class DarwinController
implements IController {
    private final Driver_Darwin driver;

    public DarwinController() {
        ModLogger.log("[Native] Load the Darwin Controller.", new Object[0]);
        this.driver = (Driver_Darwin)Native.load((String)Main.copyLibrary("libdarwincocoainput.dylib"), Driver_Darwin.class);
        this.driver.initialize(log -> ModLogger.log("[Native|C] " + log, new Object[0]), log -> ModLogger.error("[Native|C] " + log, new Object[0]), log -> ModLogger.debug("[Native|C] " + log, new Object[0]));
    }

    @Override
    public IOperator createOperator(AbstractIMEWrapper wrapper) {
        return new DarwinOperator(this, wrapper);
    }

    @Override
    public void changeFocusedScreen(Screen screen) {
        if (screen instanceof ScreenController) {
            return;
        }
        this.driver.refreshInstance();
    }

    @Override
    public void setFocus(boolean focus) {
    }

    public Driver_Darwin getDriver() {
        return this.driver;
    }

    @Override
    public KeyboardStatus getKeyboardStatus() {
        String imeSource = this.driver.getStatus();
        if (imeSource == null) {
            return null;
        }
        KeyboardStatus.Language source = DarwinController.parseSourceFromString(imeSource.toLowerCase(Locale.ENGLISH));
        return new KeyboardStatus(source, true);
    }

    private static KeyboardStatus.Language parseSourceFromString(String imeSource) {
        if (imeSource.contains("abc")) {
            return KeyboardStatus.Language.ENGLISH;
        }
        if (imeSource.contains("korean")) {
            return KeyboardStatus.Language.KOREAN;
        }
        if (imeSource.contains("kotoeri") || imeSource.contains("japanese")) {
            return KeyboardStatus.Language.JAPANESE;
        }
        if (imeSource.contains("scim")) {
            return KeyboardStatus.Language.CHINESE_SIMPLIFIED;
        }
        if (imeSource.contains("tcim")) {
            return KeyboardStatus.Language.CHINESE_TRADITIONAL;
        }
        return KeyboardStatus.Language.OTHER;
    }
}

