/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.driver.arch.wayland;

import com.mojang.blaze3d.platform.Window;
import com.sun.jna.Native;
import moe.caramel.chat.Main;
import moe.caramel.chat.controller.ScreenController;
import moe.caramel.chat.driver.IController;
import moe.caramel.chat.driver.IOperator;
import moe.caramel.chat.driver.arch.wayland.Driver_Wayland;
import moe.caramel.chat.driver.arch.wayland.WaylandOperator;
import moe.caramel.chat.util.ModLogger;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.lwjgl.glfw.GLFWNativeWayland;

public final class WaylandController
implements IController {
    static WaylandOperator focused;
    private final Driver_Wayland driver;

    public WaylandController() {
        ModLogger.log("[Native] Load the Wayland Controller.", new Object[0]);
        this.driver = (Driver_Wayland)Native.load((String)Main.copyLibrary("libcaramelchatwl.so"), Driver_Wayland.class);
        this.driver.initialize(GLFWNativeWayland.glfwGetWaylandDisplay(), str -> {
            if (focused != null) {
                ModLogger.debug("[Native|Java] Preedit Callback (" + str.toString() + ")", new Object[0]);
                focused.getWrapper().appendPreviewText(str.toString());
            }
        }, () -> {
            if (focused != null) {
                ModLogger.debug("[Native|Java] Preedit Null Callback", new Object[0]);
                focused.getWrapper().appendPreviewText("");
            }
        }, str -> {
            if (focused != null) {
                ModLogger.debug("[Native|Java] Done Callback (" + str.toString() + ")", new Object[0]);
                focused.getWrapper().insertText(str.toString());
            }
        }, rect -> {
            if (focused != null) {
                ModLogger.debug("[Native|Java] Rect Callback", new Object[0]);
                Window window = Minecraft.getInstance().getWindow();
                int osScale = window.getHeight() / window.getScreenHeight();
                float[] buff = focused.getWrapper().getRect().copy();
                float factor = window.getGuiScale();
                buff[0] = buff[0] * factor;
                buff[1] = buff[1] * factor;
                buff[2] = buff[2] * factor;
                buff[3] = buff[3] * factor;
                buff[1] = buff[1] / (float)osScale;
                rect.write(0L, buff, 0, 4);
                return 0;
            }
            return 1;
        }, log -> ModLogger.log("[Native|C] " + log, new Object[0]), log -> ModLogger.error("[Native|C] " + log, new Object[0]), log -> ModLogger.debug("[Native|C] " + log, new Object[0]));
        this.setFocus(false);
    }

    @Override
    public IOperator createOperator(AbstractIMEWrapper wrapper) {
        return new WaylandOperator(this, wrapper);
    }

    @Override
    public void changeFocusedScreen(Screen screen) {
        if (screen instanceof ScreenController) {
            return;
        }
        if (focused != null) {
            focused.setFocused(false);
            focused = null;
        }
    }

    @Override
    public void setFocus(boolean focus) {
        this.driver.setFocus(focus);
    }
}

