/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.driver.arch.win;

import com.sun.jna.Native;
import moe.caramel.chat.Main;
import moe.caramel.chat.controller.ScreenController;
import moe.caramel.chat.driver.IController;
import moe.caramel.chat.driver.IOperator;
import moe.caramel.chat.driver.KeyboardStatus;
import moe.caramel.chat.driver.arch.win.Driver_Win;
import moe.caramel.chat.driver.arch.win.WinOperator;
import moe.caramel.chat.util.ModLogger;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.lwjgl.glfw.GLFWNativeWin32;

public final class WinController
implements IController {
    static WinOperator focused;
    private final Driver_Win driver;

    public WinController() {
        ModLogger.log("[Native] Load the Windows Controller.", new Object[0]);
        this.driver = (Driver_Win)Native.load((String)Main.copyLibrary("libwincocoainput.dll"), Driver_Win.class);
        this.driver.initialize(GLFWNativeWin32.glfwGetWin32Window((long)Minecraft.getInstance().getWindow().handle()), (str, cursor, length) -> {
            if (focused != null) {
                ModLogger.debug("[Native|Java] Preedit Callback (" + str.toString() + ") (" + cursor + ") (" + length + ")", new Object[0]);
                focused.getWrapper().appendPreviewText(str.toString());
            }
        }, str -> {
            if (focused != null) {
                ModLogger.debug("[Native|Java] Done Callback (" + str.toString() + ")", new Object[0]);
                focused.getWrapper().insertText(str.toString());
            }
        }, rect -> {
            if (focused != null) {
                ModLogger.debug("[Native|Java] Rect Callback", new Object[0]);
                float[] buff = focused.getWrapper().getRect().copy();
                float factor = Minecraft.getInstance().getWindow().getGuiScale();
                buff[0] = buff[0] * factor;
                buff[1] = buff[1] * factor;
                buff[2] = buff[2] * factor;
                buff[3] = buff[3] * factor;
                rect.write(0L, buff, 0, 4);
                return 0;
            }
            return 1;
        }, log -> ModLogger.log("[Native|C] " + log, new Object[0]), log -> ModLogger.error("[Native|C] " + log, new Object[0]), log -> ModLogger.debug("[Native|C] " + log, new Object[0]));
    }

    @Override
    public IOperator createOperator(AbstractIMEWrapper wrapper) {
        return new WinOperator(this, wrapper);
    }

    @Override
    public void changeFocusedScreen(Screen screen) {
        if (screen instanceof ScreenController) {
            return;
        }
        if (focused != null) {
            focused.setFocused(false);
            focused = null;
        }
    }

    @Override
    public void setFocus(boolean focus) {
        this.driver.set_focus(focus ? 1 : 0);
    }

    @Override
    public KeyboardStatus getKeyboardStatus() {
        return new KeyboardStatus(Driver_Win.LAYOUT_MAP.getOrDefault(this.driver.getKeyboardLayout(), KeyboardStatus.Language.OTHER), this.driver.getStatus() != 0);
    }
}

