/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.driver.arch.x11;

import moe.caramel.chat.driver.IController;
import moe.caramel.chat.driver.IOperator;
import moe.caramel.chat.driver.arch.x11.X11Controller;
import moe.caramel.chat.util.ModLogger;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;

public final class X11Operator
implements IOperator {
    private final X11Controller controller;
    private final AbstractIMEWrapper wrapper;
    private boolean nowFocused;

    public X11Operator(X11Controller controller, AbstractIMEWrapper wrapper) {
        this.controller = controller;
        this.wrapper = wrapper;
    }

    public AbstractIMEWrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public IController getController() {
        return this.controller;
    }

    @Override
    public void setFocused(boolean focus) {
        if (focus == this.nowFocused) {
            return;
        }
        ModLogger.debug("[Native|Java] Called setFocused: " + focus, new Object[0]);
        this.nowFocused = focus;
        if (focus) {
            X11Controller.focused = this;
            this.controller.setFocus(true);
        } else if (X11Controller.focused == this) {
            this.wrapper.insertText("");
            X11Controller.focused = null;
            this.controller.setFocus(false);
            X11Controller.setupKeyboardEvent();
        }
    }

    @Override
    public boolean isFocused() {
        return this.nowFocused;
    }
}

