/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.mixin;

import java.util.Objects;
import moe.caramel.chat.PlatformProvider;
import moe.caramel.chat.controller.EditBoxController;
import moe.caramel.chat.driver.KeyboardStatus;
import moe.caramel.chat.wrapper.WrapperEditBox;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatScreen.class})
public abstract class MixinChatScreen {
    @Shadow
    protected EditBox input;
    @Shadow
    CommandSuggestions commandSuggestions;
    @Unique
    private static final int TOOLTIP_TIME = 500;
    @Unique
    private static final int FADE_TIME = 250;
    @Unique
    private static final Component MARK_VERSION = Component.translatable((String)"caramelChat v%s", (Object[])new Object[]{PlatformProvider.getProvider().getVersion()}).setStyle(Style.EMPTY.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"caramel.chat.redistribution_warn"))));
    @Unique
    private static final FontDescription.Resource UNIFORM_RESOURCE = new FontDescription.Resource(Minecraft.UNIFORM_FONT);
    @Unique
    private KeyboardStatus.Language caramelChat$lastLanguage;
    @Unique
    private long caramelChat$changeTime;

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    private void render(GuiGraphics helper, int mouseX, int mouseY, float tickDelta, CallbackInfo ci) {
        Screen screen = (Screen)this;
        this.caramelChat$renderMark(screen, helper, mouseX, mouseY, tickDelta);
        this.caramelChat$renderImeStatus(screen, helper, mouseX, mouseY, tickDelta);
    }

    @Unique
    private void caramelChat$renderMark(Screen screen, GuiGraphics helper, int mouseX, int mouseY, float tickDelta) {
        int markStartY = 10;
        Objects.requireNonNull(screen.font);
        int markEndY = 10 + 9;
        int markEndX = screen.width - 10;
        int markStartX = markEndX - screen.font.width((FormattedText)MARK_VERSION);
        helper.drawString(screen.font, MARK_VERSION, markStartX, 10, 0x33FFFFFF, false);
        if (markStartX <= mouseX && mouseX <= markEndX && 10 <= mouseY && mouseY <= markEndY) {
            helper.renderComponentHoverEffect(screen.font, MARK_VERSION.getStyle(), mouseX, mouseY);
        }
    }

    @Unique
    private void caramelChat$renderImeStatus(Screen screen, GuiGraphics helper, int mouseX, int mouseY, float tickDelta) {
        int suggestionWidth;
        int elapsed;
        WrapperEditBox wrapper = EditBoxController.getWrapper(this.input);
        KeyboardStatus status = wrapper.getIme().getController().getKeyboardStatus();
        if (status == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.caramelChat$lastLanguage != status.language()) {
            this.caramelChat$lastLanguage = status.language();
            this.caramelChat$changeTime = currentTime;
        }
        if ((elapsed = (int)(currentTime - this.caramelChat$changeTime)) > 500) {
            return;
        }
        CommandSuggestions suggestions = this.commandSuggestions;
        MutableComponent display = Component.literal((String)status.display()).withStyle(style -> style.withFont((FontDescription)UNIFORM_RESOURCE));
        int borderStartX = 2;
        int borderEndX = borderStartX + Mth.floor((float)(screen.font.getSplitter().stringWidth((FormattedText)display) - status.offset())) + 4;
        int n = suggestionWidth = suggestions.suggestions != null ? suggestions.suggestions.rect.getX() : Integer.MAX_VALUE;
        if (suggestionWidth <= borderEndX) {
            int safeRange = suggestionWidth - borderEndX - 2;
            borderStartX += safeRange;
            borderEndX += safeRange;
        }
        int usageHeight = suggestions.suggestions == null && suggestions.commandUsagePosition == 0 ? 12 * suggestions.commandUsage.size() : 0;
        int borderEndY = screen.height - 14 - usageHeight - 2;
        Objects.requireNonNull(screen.font);
        int borderStartY = borderEndY - 9 - 2;
        int backColor = this.caramelChat$color(Minecraft.getInstance().options.getBackgroundColor(Integer.MIN_VALUE), elapsed);
        int textColor = this.caramelChat$color(-1, elapsed);
        helper.fill(borderStartX, borderStartY, borderEndX, borderEndY, backColor);
        helper.drawString(screen.font, (Component)display, borderStartX + 2, borderStartY + 1, textColor, false);
    }

    @Unique
    private int caramelChat$color(int color, int elapsed) {
        if (elapsed < 250) {
            return color;
        }
        float progress = (float)(500 - elapsed) / 250.0f;
        int initialAlpha = color >> 24 & 0xFF;
        int alpha = (int)(progress * (float)initialAlpha);
        if (alpha < 5) {
            return 0;
        }
        return alpha << 24 | color & 0xFFFFFF;
    }
}

