/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import moe.caramel.chat.controller.EditBoxController;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import moe.caramel.chat.wrapper.WrapperEditBox;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EditBox.class}, priority=0)
public abstract class MixinEditBox
implements EditBoxController {
    @Unique
    private WrapperEditBox caramelChat$wrapper;
    @Unique
    private int caramelChat$cacheCursorPos;
    @Unique
    private int caramelChat$cacheHighlightPos;
    @Shadow
    private boolean canLoseFocus;
    @Shadow
    public int highlightPos;
    @Shadow
    public int cursorPos;
    @Shadow
    public String value;
    @Shadow
    @Final
    private List<EditBox.TextFormatter> formatters;

    @Redirect(method={"<init>(Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/client/gui/components/EditBox;Lnet/minecraft/network/chat/Component;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;setValue(Ljava/lang/String;)V"))
    private void init(EditBox self, String value) {
        this.caramelChat$wrapper = new WrapperEditBox((EditBox)this);
        self.setValue(value);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/client/gui/components/EditBox;Lnet/minecraft/network/chat/Component;)V"}, at={@At(value="TAIL")})
    private void lazyInit(CallbackInfo ci) {
        if (this.caramelChat$wrapper == null) {
            this.caramelChat$wrapper = new WrapperEditBox((EditBox)this);
        }
        this.formatters.add(this.caramelChat$caretFormatter());
    }

    @Override
    public WrapperEditBox caramelChat$wrapper() {
        return this.caramelChat$wrapper;
    }

    @Unique
    private EditBox.TextFormatter caramelChat$caretFormatter() {
        return (original, firstPos) -> {
            if (this.caramelChat$wrapper.getStatus() == AbstractIMEWrapper.InputStatus.NONE) {
                return null;
            }
            if (this.caramelChat$wrapper.blockTyping()) {
                return FormattedCharSequence.forward((String)original, (Style)Style.EMPTY.withColor(ChatFormatting.RED));
            }
            int lastPos = firstPos + original.length();
            if (lastPos <= this.caramelChat$wrapper.getFirstEndPos() || this.caramelChat$wrapper.getSecondStartPos() < firstPos) {
                return null;
            }
            int firstLen = this.caramelChat$wrapper.getFirstEndPos() - firstPos;
            int previewLen = this.caramelChat$wrapper.getSecondStartPos() - this.caramelChat$wrapper.getFirstEndPos();
            int inputEndPoint = Math.min(original.length(), firstLen + previewLen);
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            String first = original.substring(0, firstLen);
            String input = original.substring(firstLen, inputEndPoint);
            String second = original.substring(inputEndPoint);
            list.add(FormattedCharSequence.forward((String)first, (Style)Style.EMPTY));
            list.add(FormattedCharSequence.forward((String)input, (Style)Style.EMPTY.withUnderlined(Boolean.valueOf(true))));
            list.add(FormattedCharSequence.forward((String)second, (Style)Style.EMPTY));
            return FormattedCharSequence.composite(list);
        };
    }

    @Inject(method={"setValue(Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    private void setValueHead(String text, CallbackInfo ci) {
        if (this.caramelChat$wrapper != null && this.caramelChat$wrapper.valueChanged) {
            this.caramelChat$cacheCursorPos = 0;
            this.caramelChat$cacheHighlightPos = 0;
        } else {
            this.caramelChat$setStatusToNone();
        }
    }

    @Redirect(method={"setValue(Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Ljava/util/function/Predicate;test(Ljava/lang/Object;)Z"))
    private boolean setValuePredicateTest(Predicate<String> predicate, Object value) {
        if (this.caramelChat$wrapper != null && this.caramelChat$wrapper.valueChanged) {
            this.caramelChat$cacheCursorPos = this.cursorPos;
            this.caramelChat$cacheHighlightPos = this.highlightPos;
            return true;
        }
        return predicate.test((String)value);
    }

    @Inject(method={"setValue(Ljava/lang/String;)V"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/client/gui/components/EditBox;moveCursorToEnd(Z)V")}, cancellable=true)
    private void setValueInvoke(String text, CallbackInfo ci) {
        if (this.caramelChat$wrapper != null && this.caramelChat$wrapper.valueChanged) {
            ci.cancel();
            this.cursorPos = this.caramelChat$cacheCursorPos;
            this.highlightPos = this.caramelChat$cacheHighlightPos;
            this.caramelChat$wrapper.valueChanged = false;
            return;
        }
        this.caramelChat$forceUpdateOrigin();
    }

    @Inject(method={"insertText(Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    private void insertTextHead(String text, CallbackInfo ci) {
        this.caramelChat$setStatusToNone();
    }

    @Inject(method={"insertText(Ljava/lang/String;)V"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/client/gui/components/EditBox;onValueChange(Ljava/lang/String;)V")})
    private void insertTextInvoke(String text, CallbackInfo ci) {
        this.caramelChat$forceUpdateOrigin();
    }

    @Inject(method={"onValueChange(Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    private void onValueChange(String text, CallbackInfo ci) {
        if (this.caramelChat$wrapper != null) {
            this.value = this.caramelChat$wrapper.getOrigin();
        }
    }

    @Inject(method={"deleteCharsToPos(I)V"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/client/gui/components/EditBox;moveCursorTo(IZ)V")})
    private void deleteChars(int pos, CallbackInfo ci) {
        this.caramelChat$wrapper.setOrigin(this.value);
    }

    @Inject(method={"setFocused(Z)V"}, at={@At(value="TAIL")})
    private void setFocused(boolean focused, CallbackInfo ci) {
        if (this.caramelChat$wrapper != null) {
            this.caramelChat$wrapper.setFocused(focused || !this.canLoseFocus);
        }
    }

    @Inject(method={"setCanLoseFocus(Z)V"}, at={@At(value="HEAD")})
    private void setCanLoseFocus(boolean canLoseFocus, CallbackInfo ci) {
        if (this.caramelChat$wrapper != null && !canLoseFocus) {
            this.caramelChat$wrapper.setFocused(true);
        }
    }

    @Unique
    private void caramelChat$setStatusToNone() {
        if (this.caramelChat$wrapper != null) {
            this.caramelChat$wrapper.setToNoneStatus();
        }
    }

    @Unique
    private void caramelChat$forceUpdateOrigin() {
        if (this.caramelChat$wrapper != null) {
            this.caramelChat$wrapper.setOrigin(this.value);
        }
    }
}

