/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.function.Consumer;
import moe.caramel.chat.controller.ScreenController;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import moe.caramel.chat.wrapper.WrapperSignEditScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.client.input.KeyEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractSignEditScreen.class}, priority=0)
public final class MixinSignEditScreen
implements ScreenController {
    @Unique
    private WrapperSignEditScreen caramelChat$wrapper;
    @Unique
    private boolean caramelChat$lazyInit;
    @Unique
    private int caramelChat$currentRenderLine = -1;
    @Shadow
    @Nullable
    public TextFieldHelper signField;
    @Shadow
    public int line;

    @Inject(method={"init()V"}, at={@At(value="HEAD")})
    private void init(CallbackInfo ci) {
        this.caramelChat$wrapper = new WrapperSignEditScreen((AbstractSignEditScreen)this);
        this.caramelChat$wrapper.setOrigin();
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void lazyInit(CallbackInfo ci) {
        if (!this.caramelChat$lazyInit && this.signField != null) {
            this.caramelChat$lazyInit = true;
            Consumer previous = this.signField.setMessageFn;
            this.signField.setMessageFn = value -> {
                previous.accept(value);
                this.caramelChat$wrapper.setOrigin();
            };
        }
    }

    @Inject(method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/client/gui/font/TextFieldHelper;setCursorToEnd()V"), @At(value="INVOKE", ordinal=1, target="Lnet/minecraft/client/gui/font/TextFieldHelper;setCursorToEnd()V")})
    private void keyPressed(KeyEvent event, CallbackInfoReturnable<Boolean> cir) {
        this.caramelChat$wrapper.setOrigin();
    }

    @Redirect(method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/font/TextFieldHelper;keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"))
    private boolean helperKeyPressed(TextFieldHelper helper, KeyEvent event) {
        boolean result = helper.keyPressed(event);
        if (result) {
            this.caramelChat$wrapper.setToNoneStatus();
        }
        return result;
    }

    @Inject(method={"renderSignText(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="HEAD")})
    private void captureRenderLine(GuiGraphics instance, CallbackInfo ci) {
        this.caramelChat$currentRenderLine = -1;
    }

    @Redirect(method={"renderSignText(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at=@At(value="INVOKE", target="Ljava/lang/String;substring(II)Ljava/lang/String;"))
    private String temporaryFixOverflow(String value, int beginIndex, int endIndex) {
        return value.substring(beginIndex, Math.min(value.length(), endIndex));
    }

    @WrapOperation(method={"renderSignText(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)V", ordinal=0)})
    private void renderCaret(GuiGraphics instance, Font font, String text, int x, int y, int color, boolean dropShadow, Operation<Integer> original) {
        ++this.caramelChat$currentRenderLine;
        if (text.isEmpty() || this.caramelChat$wrapper.getStatus() == AbstractIMEWrapper.InputStatus.NONE) {
            original.call(new Object[]{instance, font, text, x, y, color, dropShadow});
            return;
        }
        if (this.caramelChat$currentRenderLine != this.line || this.caramelChat$wrapper.getSecondStartPos() > text.length()) {
            original.call(new Object[]{instance, font, text, x, y, color, dropShadow});
            return;
        }
        int firstEndPos = this.caramelChat$wrapper.getFirstEndPos();
        int secondStartPos = this.caramelChat$wrapper.getSecondStartPos();
        String first = text.substring(0, firstEndPos);
        String input = text.substring(firstEndPos, secondStartPos);
        String second = text.substring(secondStartPos);
        String result = first + String.valueOf(ChatFormatting.UNDERLINE) + input + String.valueOf(ChatFormatting.RESET) + second;
        original.call(new Object[]{instance, font, result, x, y, color, dropShadow});
    }
}

