/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.wrapper;

import moe.caramel.chat.Main;
import moe.caramel.chat.driver.IOperator;
import moe.caramel.chat.util.ModLogger;
import moe.caramel.chat.util.Rect;

public abstract class AbstractIMEWrapper {
    private final IOperator ime;
    private InputStatus status = InputStatus.NONE;
    private int firstEndPos = -1;
    private int secondStartPos = -1;
    protected String origin;

    protected AbstractIMEWrapper() {
        this("");
    }

    protected AbstractIMEWrapper(String defValue) {
        this.ime = Main.getController().createOperator(this);
        this.origin = defValue;
    }

    public IOperator getIme() {
        return this.ime;
    }

    public final InputStatus getStatus() {
        return this.status;
    }

    public final void setToNoneStatus() {
        this.status = InputStatus.NONE;
        this.setPreviewText(this.origin);
    }

    public final int getFirstEndPos() {
        return this.firstEndPos;
    }

    public final int getSecondStartPos() {
        return this.secondStartPos;
    }

    public final void setFocused(boolean focused) {
        this.ime.setFocused(focused);
    }

    public final String getOrigin() {
        return this.origin;
    }

    public final void setOrigin() {
        this.setOrigin(this.getTextWithPreview());
    }

    public final void setOrigin(String value) {
        this.origin = value;
    }

    public final void appendPreviewText(String typing) {
        if (!this.editable()) {
            return;
        }
        ModLogger.debug("[Preview] Current: ({}) / Preview: ({})", this.origin, typing);
        this.status = InputStatus.PREVIEW;
        int start = Math.min(this.getCursorPos(), this.getHighlightPos());
        int end = Math.max(this.getCursorPos(), this.getHighlightPos());
        boolean samePos = start == end;
        int lastPos = this.origin.length();
        if (lastPos != end && samePos) {
            String first = this.origin.substring(0, end);
            String second = this.origin.substring(end, lastPos);
            this.firstEndPos = first.length();
            this.secondStartPos = this.firstEndPos + typing.length();
            this.setPreviewText(first + typing + second);
        } else if (samePos) {
            String result = this.origin + typing;
            this.firstEndPos = this.origin.length();
            this.secondStartPos = result.length();
            this.setPreviewText(result);
        } else {
            String first = this.origin.substring(0, start);
            String second = this.origin.substring(end, lastPos);
            this.insert("");
            this.origin = this.getTextWithPreview();
            this.firstEndPos = first.length();
            this.secondStartPos = this.firstEndPos + typing.length();
            this.setPreviewText(first + typing + second);
        }
    }

    public final void insertText(String input) {
        if (this.blockTyping() || !this.editable()) {
            return;
        }
        ModLogger.debug("[Complete] Current: ({}) / Preview: ({})", this.origin, input);
        this.status = InputStatus.NONE;
        this.firstEndPos = -1;
        this.secondStartPos = -1;
        this.setPreviewText(this.origin);
        this.insert(input);
        this.origin = this.getTextWithPreview();
    }

    protected abstract void insert(String var1);

    protected abstract int getCursorPos();

    protected abstract int getHighlightPos();

    public boolean editable() {
        return true;
    }

    public abstract boolean blockTyping();

    protected abstract String getTextWithPreview();

    protected abstract void setPreviewText(String var1);

    public abstract Rect getRect();

    public static enum InputStatus {
        NONE,
        PREVIEW;

    }
}

