/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.wrapper;

import java.util.Objects;
import moe.caramel.chat.util.Rect;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;

public final class WrapperMultilineEditBox
extends AbstractIMEWrapper {
    private final MultiLineEditBox wrapped;
    public boolean valueChanged;

    public WrapperMultilineEditBox(MultiLineEditBox textField) {
        super(textField.getValue());
        this.wrapped = textField;
    }

    @Override
    protected void insert(String text) {
        if (this.editable()) {
            this.wrapped.textField.insertText(text);
        }
    }

    @Override
    protected int getCursorPos() {
        return this.wrapped.textField.cursor;
    }

    @Override
    protected int getHighlightPos() {
        return this.wrapped.textField.selectCursor;
    }

    @Override
    public boolean blockTyping() {
        return this.wrapped.textField.overflowsLineLimit("");
    }

    @Override
    protected String getTextWithPreview() {
        return this.wrapped.getValue();
    }

    @Override
    protected void setPreviewText(String text) {
        this.valueChanged = true;
        this.wrapped.textField.value = text;
        this.wrapped.textField.reflowDisplayLines();
    }

    @Override
    public Rect getRect() {
        int yHeight;
        int xWidth;
        int index;
        if (this.getStatus() == AbstractIMEWrapper.InputStatus.NONE) {
            return Rect.EMPTY;
        }
        int editEndPos = this.getSecondStartPos();
        MultilineTextField.StringView stringView = null;
        for (index = 0; index < this.wrapped.textField.displayLines.size() && (editEndPos < (stringView = (MultilineTextField.StringView)this.wrapped.textField.displayLines.get(index)).beginIndex() || editEndPos > stringView.endIndex()); ++index) {
        }
        if (stringView == null) {
            xWidth = 0;
            yHeight = this.wrapped.textField.getLineCount();
        } else {
            String result = this.getTextWithPreview().substring(stringView.beginIndex(), this.getSecondStartPos());
            xWidth = this.wrapped.font.width(result);
            yHeight = index + 1;
        }
        float x = this.wrapped.getInnerLeft() + xWidth;
        int n = this.wrapped.getInnerTop();
        Objects.requireNonNull(this.wrapped.font);
        float y = n + yHeight * 9;
        return new Rect(x, y, this.wrapped.getWidth(), this.wrapped.getHeight());
    }
}

