/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.wrapper;

import moe.caramel.chat.util.Rect;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.client.gui.screens.inventory.HangingSignEditScreen;
import net.minecraft.world.level.block.StandingSignBlock;

public final class WrapperSignEditScreen
extends AbstractIMEWrapper {
    private final AbstractSignEditScreen wrapped;

    public WrapperSignEditScreen(AbstractSignEditScreen screen) {
        this.wrapped = screen;
        this.setFocused(true);
    }

    @Override
    protected void insert(String text) {
        if (this.wrapped.signField != null) {
            this.wrapped.signField.insertText(text);
        }
    }

    @Override
    protected int getCursorPos() {
        if (this.wrapped.signField == null) {
            return 0;
        }
        return this.wrapped.signField.getCursorPos();
    }

    @Override
    protected int getHighlightPos() {
        if (this.wrapped.signField == null) {
            return 0;
        }
        return this.wrapped.signField.getSelectionPos();
    }

    @Override
    public boolean blockTyping() {
        if (this.wrapped.signField == null) {
            return true;
        }
        return !this.wrapped.signField.stringValidator.test(this.origin + "A");
    }

    @Override
    public String getTextWithPreview() {
        return this.wrapped.messages[this.wrapped.line];
    }

    @Override
    protected void setPreviewText(String text) {
        this.wrapped.setMessage(text);
        this.wrapped.messages[this.wrapped.line] = text;
    }

    @Override
    public Rect getRect() {
        if (this.wrapped.signField == null) {
            return Rect.EMPTY;
        }
        String preview = this.getTextWithPreview();
        int xWidth = this.wrapped.font.width(preview.substring(0, Math.min(this.wrapped.signField.getCursorPos(), preview.length())));
        float x = (float)this.wrapped.width / 2.0f + (float)xWidth / 2.0f;
        float yHeight = 90.0f + (float)((this.wrapped.line - 1) * this.wrapped.sign.getTextLineHeight());
        float y = this.wrapped instanceof HangingSignEditScreen || !(this.wrapped.sign.getBlockState().getBlock() instanceof StandingSignBlock) ? yHeight + 35.0f : yHeight;
        return new Rect(x, y, 0.0f, 0.0f);
    }
}

