/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import moe.caramel.chat.driver.IController;
import moe.caramel.chat.driver.arch.unknown.UnknownController;
import moe.caramel.chat.util.ModLogger;
import net.minecraft.client.gui.screens.Screen;

public final class Main {
    public static final boolean DEBUG = false;
    private static Main instance = new Main();
    private final IController controller = IController.getController();

    private Main() {
        if (this.controller instanceof UnknownController) {
            ModLogger.error("caramelChat can't find appropriate Controller in running OS", new Object[0]);
        }
    }

    public static Main getInstance() {
        return instance;
    }

    public static IController getController() {
        return Main.getInstance().controller;
    }

    public static void setScreen(Screen screen) {
        Main.getController().changeFocusedScreen(screen);
    }

    public static String copyLibrary(String name) {
        try {
            URL url = Main.class.getClassLoader().getResource("native/" + name);
            if (url == null) {
                throw new IOException("Native library (" + name + ") not found.");
            }
            File lib = File.createTempFile("caramelchat", Platform.isWindows() ? ".dll" : null, Main.tempDir());
            try (InputStream is = url.openStream();
                 FileOutputStream fos = new FileOutputStream(lib);){
                ModLogger.debug("Extracting library to {}", lib.getAbsolutePath());
                fos.write(is.readAllBytes());
                lib.deleteOnExit();
            }
            ModLogger.log("CocoaInput Driver has copied library to native directory.", new Object[0]);
            return lib.getAbsolutePath();
        }
        catch (Exception exception) {
            ModLogger.error("An error occurred while loading the library.", new Object[0]);
            throw new RuntimeException(exception);
        }
    }

    private static File tempDir() throws IOException {
        try {
            Method method = Native.class.getDeclaredMethod("getTempDir", new Class[0]);
            method.setAccessible(true);
            return (File)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return File.createTempFile("native", "temp");
        }
    }
}

