/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat;

import moe.caramel.chat.util.ModLogger;

public abstract class PlatformProvider {
    public static final String MOD_ID = "caramelchat";
    public static final PlatformProvider DEFAULT;
    private static PlatformProvider provider;

    public static PlatformProvider getProvider() {
        return provider;
    }

    public static void setProvider(PlatformProvider provider) {
        if (PlatformProvider.provider != DEFAULT) {
            throw new UnsupportedOperationException();
        }
        PlatformProvider.provider = provider;
        ModLogger.log("The platform provider has been loaded: {}", provider);
    }

    public abstract String getVersion();

    public abstract String getPlatformName();

    public String toString() {
        return "(" + this.getPlatformName() + " / " + this.getVersion() + ")";
    }

    static {
        provider = DEFAULT = new PlatformProvider(){

            @Override
            public String getVersion() {
                return "UNKNOWN";
            }

            @Override
            public String getPlatformName() {
                return "UNKNOWN";
            }
        };
    }
}

