/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.driver;

import moe.caramel.chat.driver.IOperator;
import moe.caramel.chat.driver.KeyboardStatus;
import moe.caramel.chat.driver.arch.darwin.DarwinController;
import moe.caramel.chat.driver.arch.unknown.UnknownController;
import moe.caramel.chat.driver.arch.wayland.WaylandController;
import moe.caramel.chat.driver.arch.win.WinController;
import moe.caramel.chat.driver.arch.x11.X11Controller;
import moe.caramel.chat.util.ModLogger;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public interface IController {
    public IOperator createOperator(AbstractIMEWrapper var1);

    public void changeFocusedScreen(Screen var1);

    public void setFocus(boolean var1);

    @Nullable
    default public KeyboardStatus getKeyboardStatus() {
        return null;
    }

    public static IController getController() {
        try {
            return switch (GLFW.glfwGetPlatform()) {
                case 393217 -> new WinController();
                case 393218 -> new DarwinController();
                case 393220 -> new X11Controller();
                case 393219 -> new WaylandController();
                default -> throw new UnsupportedOperationException();
            };
        }
        catch (UnsupportedOperationException ignored) {
            ModLogger.error("This platform is not supported by CocoaInput Driver.", new Object[0]);
        }
        catch (Exception exception) {
            ModLogger.error("Error while loading the CocoaInput Driver.", exception);
        }
        return UnknownController.INSTANCE;
    }
}

