/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.driver.arch.darwin;

import com.mojang.blaze3d.platform.Window;
import java.util.UUID;
import moe.caramel.chat.driver.IController;
import moe.caramel.chat.driver.IOperator;
import moe.caramel.chat.driver.arch.darwin.DarwinController;
import moe.caramel.chat.util.ModLogger;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import net.minecraft.client.Minecraft;

public class DarwinOperator
implements IOperator {
    private final DarwinController controller;
    private final AbstractIMEWrapper wrapper;
    private final String uuid;
    private boolean nowFocused;

    public DarwinOperator(DarwinController controller, AbstractIMEWrapper wrapper) {
        this.controller = controller;
        this.wrapper = wrapper;
        this.uuid = UUID.randomUUID().toString();
        ModLogger.debug("[Native|Java] IMEOperator addInstance: " + this.uuid, new Object[0]);
        this.controller.getDriver().addInstance(this.uuid, (str, position, length) -> {
            ModLogger.debug("[Native|Java] Textfield (" + this.uuid + ") received inserted text.", new Object[0]);
            this.wrapper.insertText(str);
        }, (str, position1, length1, position2, length2) -> {
            ModLogger.debug("[Native|Java] MarkedText changed at (" + this.uuid + ").", new Object[0]);
            this.wrapper.appendPreviewText(str);
        }, pointer -> {
            ModLogger.debug("[Native|Java] Called to determine where to draw.", new Object[0]);
            float[] buff = this.wrapper.getRect().copy();
            Window window = Minecraft.getInstance().getWindow();
            float factor = window.getGuiScale();
            buff[0] = buff[0] * factor;
            buff[1] = buff[1] * factor;
            buff[2] = buff[2] * factor;
            buff[3] = buff[3] * factor;
            buff[0] = buff[0] + (float)window.getX();
            buff[1] = buff[1] + (float)window.getY();
            pointer.write(0L, buff, 0, 4);
        });
    }

    @Override
    public IController getController() {
        return this.controller;
    }

    @Override
    public void setFocused(boolean focus) {
        if (focus != this.nowFocused) {
            ModLogger.debug("[Native|Java] IMEOperator.setFocused: " + focus, new Object[0]);
            this.controller.getDriver().setIfReceiveEvent(this.uuid, focus ? 1 : 0);
            this.nowFocused = focus;
        }
    }

    @Override
    public boolean isFocused() {
        return this.nowFocused;
    }
}

