/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.driver.arch.x11;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import moe.caramel.chat.Main;
import moe.caramel.chat.controller.ScreenController;
import moe.caramel.chat.driver.IController;
import moe.caramel.chat.driver.IOperator;
import moe.caramel.chat.driver.arch.x11.Driver_X11;
import moe.caramel.chat.driver.arch.x11.X11Operator;
import moe.caramel.chat.util.ModLogger;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWNativeX11;

public final class X11Controller
implements IController {
    private static final long windowId = Minecraft.getInstance().getWindow().handle();
    static X11Operator focused;
    private final Driver_X11 driver;
    private final Driver_X11.DrawCallback drawCallback = (caret, chg_first, chg_length, length, iswstring, rawstring, rawwstring, primary, secondary, tertiary) -> {
        String string;
        ModLogger.debug("[Native|Java] Draw begin", new Object[0]);
        String string2 = string = iswstring ? rawwstring.toString() : rawstring;
        if (focused != null) {
            GLFW.glfwSetKeyCallback((long)windowId, null);
            focused.getWrapper().appendPreviewText(string);
        }
        ModLogger.debug("[Native|Java] PreEdit: {} {} {} {} {} {} {} {}", caret, chg_first, chg_length, length, primary, secondary, tertiary, string);
        int[] point = new int[]{600, 600};
        Memory memory = new Memory(8L);
        memory.write(0L, point, 0, 2);
        ModLogger.debug("[Native|Java] Draw End", new Object[0]);
        return memory;
    };
    private final Driver_X11.DoneCallback doneCallback = () -> {
        ModLogger.debug("[Native|Java] Preedit Done", new Object[0]);
        if (focused != null) {
            focused.getWrapper().insertText("");
        }
        X11Controller.setupKeyboardEvent();
    };

    public X11Controller() {
        X11Controller.setupKeyboardEvent();
        ModLogger.log("[Native] Load the X11 Controller.", new Object[0]);
        this.driver = (Driver_X11)Native.load((String)Main.copyLibrary("libx11cocoainput.so"), Driver_X11.class);
        long windowId = Minecraft.getInstance().getWindow().handle();
        this.driver.initialize(windowId, GLFWNativeX11.glfwGetX11Window((long)windowId), this.drawCallback, this.doneCallback, log -> ModLogger.log("[Native|C] " + log, new Object[0]), log -> ModLogger.error("[Native|C] " + log, new Object[0]), log -> ModLogger.debug("[Native|C] " + log, new Object[0]));
        this.setFocus(false);
    }

    public static void setupKeyboardEvent() {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.keyboardHandler.setup(minecraft.getWindow());
        GLFW.glfwSetCharModsCallback((long)windowId, (window, codepoint, mods) -> minecraft.execute(() -> {
            if (focused != null) {
                focused.getWrapper().insertText(String.valueOf(Character.toChars(codepoint)));
            } else {
                minecraft.keyboardHandler.charTyped(windowId, new CharacterEvent(codepoint, mods));
            }
        }));
    }

    @Override
    public IOperator createOperator(AbstractIMEWrapper wrapper) {
        return new X11Operator(this, wrapper);
    }

    @Override
    public void changeFocusedScreen(Screen screen) {
        if (screen instanceof ScreenController) {
            return;
        }
        if (focused != null) {
            focused.setFocused(false);
            focused = null;
        }
    }

    @Override
    public void setFocus(boolean focus) {
        this.driver.set_focus(focus ? 1 : 0);
    }
}

