/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.mixin;

import moe.caramel.chat.controller.EditBoxController;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import moe.caramel.chat.wrapper.WrapperEditBox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class MixinCreativeModeInventoryScreen {
    @Shadow
    private EditBox searchBox;

    @Shadow
    public abstract void refreshSearchResults();

    @Shadow
    protected abstract boolean isCreativeSlot(@Nullable Slot var1);

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        WrapperEditBox wrapper = EditBoxController.getWrapper(this.searchBox);
        wrapper.setInsertCallback(() -> {
            if (wrapper.getStatus() == AbstractIMEWrapper.InputStatus.PREVIEW) {
                this.refreshSearchResults();
            }
        });
    }

    @Redirect(method={"slotClicked(Lnet/minecraft/world/inventory/Slot;IILnet/minecraft/world/inventory/ClickType;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen;isCreativeSlot(Lnet/minecraft/world/inventory/Slot;)Z"))
    private boolean slotClicked(CreativeModeInventoryScreen screen, Slot slot) {
        boolean imeFocused = EditBoxController.getWrapper(this.searchBox).getIme().isFocused();
        return this.isCreativeSlot(slot) && (!imeFocused || !this.searchBox.isFocused());
    }
}

