/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.function.Consumer;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import moe.caramel.chat.wrapper.WrapperMultilineEditBox;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={MultiLineEditBox.class})
public final class MixinMultiLineEditBox {
    @Unique
    private WrapperMultilineEditBox caramelChat$wrapper;
    @Unique
    private int caramelChat$viewBeginPos = -1;
    @Unique
    private int caramelChat$viewEndPos = -1;
    @Shadow
    @Final
    public MultilineTextField textField;

    @Inject(method={"<init>(Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/Component;IZIZZ)V"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        this.caramelChat$wrapper = new WrapperMultilineEditBox((MultiLineEditBox)this);
        this.caramelChat$replaceValueListener(this.textField.valueListener);
    }

    @ModifyArgs(method={"renderContents(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Ljava/lang/String;substring(II)Ljava/lang/String;", ordinal=1))
    private void captureLineRenderPositionsMiddle(Args args) {
        this.captureLineRenderPositionsEnd(args);
    }

    @ModifyArgs(method={"renderContents(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Ljava/lang/String;substring(II)Ljava/lang/String;", ordinal=2))
    private void captureLineRenderPositionsEnd(Args args) {
        this.caramelChat$viewBeginPos = (Integer)args.get(0);
        this.caramelChat$viewEndPos = (Integer)args.get(1);
    }

    @WrapOperation(method={"renderContents(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)V", ordinal=1)})
    private void renderCaretMiddle(GuiGraphics instance, Font font, String text, int x, int y, int color, boolean dropShadow, Operation<Integer> original) {
        this.renderCaretEnd(instance, font, text, x, y, color, dropShadow, original);
    }

    @WrapOperation(method={"renderContents(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)V", ordinal=2)})
    private void renderCaretEnd(GuiGraphics instance, Font font, String text, int x, int y, int color, boolean dropShadow, Operation<Integer> original) {
        if (text.isEmpty() || this.caramelChat$wrapper.getStatus() == AbstractIMEWrapper.InputStatus.NONE) {
            original.call(new Object[]{instance, font, text, x, y, color, dropShadow});
            return;
        }
        int firstEnd = this.caramelChat$wrapper.getFirstEndPos();
        int secondStart = this.caramelChat$wrapper.getSecondStartPos();
        if (firstEnd < this.caramelChat$viewEndPos && this.caramelChat$viewBeginPos < secondStart) {
            int localEnd;
            int localStart = Math.max(0, firstEnd - this.caramelChat$viewBeginPos);
            if (localStart >= (localEnd = Math.min(text.length(), secondStart - this.caramelChat$viewBeginPos))) {
                original.call(new Object[]{instance, font, text, x, y, color, dropShadow});
                return;
            }
            String before = text.substring(0, localStart);
            String underlined = text.substring(localStart, localEnd);
            String after = text.substring(localEnd);
            String result = before + String.valueOf(ChatFormatting.UNDERLINE) + underlined + String.valueOf(ChatFormatting.RESET) + after;
            original.call(new Object[]{instance, font, result, x, y, color, dropShadow});
            return;
        }
        original.call(new Object[]{instance, font, text, x, y, color, dropShadow});
    }

    @Inject(method={"setValueListener(Ljava/util/function/Consumer;)V"}, at={@At(value="TAIL")}, cancellable=true)
    private void setValueListener(Consumer<String> valueListener, CallbackInfo ci) {
        ci.cancel();
        this.caramelChat$replaceValueListener(valueListener);
    }

    @Inject(method={"seekCursorScreen(DD)V"}, at={@At(value="TAIL")})
    private void seekCursorScreen(double mouseX, double mouseY, CallbackInfo ci) {
        if (this.caramelChat$wrapper != null) {
            this.caramelChat$wrapper.setOrigin();
            this.caramelChat$wrapper.setToNoneStatus();
        }
    }

    @Inject(method={"setFocused(Z)V"}, at={@At(value="TAIL")})
    private void setFocused(boolean focused, CallbackInfo ci) {
        if (this.caramelChat$wrapper != null) {
            this.caramelChat$wrapper.setFocused(focused);
        }
    }

    @Unique
    private void caramelChat$replaceValueListener(Consumer<String> valueListener) {
        this.textField.setValueListener(value -> {
            if (this.caramelChat$wrapper == null || this.caramelChat$wrapper.getStatus() == AbstractIMEWrapper.InputStatus.NONE) {
                valueListener.accept((String)value);
                this.caramelChat$wrapper.setOrigin((String)value);
            }
        });
    }
}

