/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.chat.wrapper;

import java.util.Objects;
import moe.caramel.chat.util.Rect;
import moe.caramel.chat.wrapper.AbstractIMEWrapper;
import net.minecraft.client.gui.components.EditBox;

public final class WrapperEditBox
extends AbstractIMEWrapper {
    private final EditBox wrapped;
    private Runnable insertCallback;
    public boolean valueChanged;

    public WrapperEditBox(EditBox box) {
        super(box.value);
        this.wrapped = box;
        this.insertCallback = () -> {};
    }

    @Override
    protected void insert(String text) {
        if (this.editable()) {
            this.wrapped.insertText(text);
            this.insertCallback.run();
        }
    }

    @Override
    protected int getCursorPos() {
        return this.wrapped.cursorPos;
    }

    @Override
    protected int getHighlightPos() {
        return this.wrapped.highlightPos;
    }

    @Override
    public boolean editable() {
        return this.wrapped.canConsumeInput();
    }

    @Override
    public boolean blockTyping() {
        if (!this.wrapped.canConsumeInput()) {
            return true;
        }
        int start = Math.min(this.wrapped.cursorPos, this.wrapped.highlightPos);
        int end = Math.max(this.wrapped.cursorPos, this.wrapped.highlightPos);
        int remain = this.wrapped.maxLength - this.wrapped.value.length() - (start - end);
        return remain <= 0;
    }

    @Override
    protected String getTextWithPreview() {
        return this.wrapped.value;
    }

    @Override
    protected void setPreviewText(String text) {
        this.valueChanged = true;
        this.wrapped.setValue(text);
        if (this.wrapped.isFocused()) {
            this.insertCallback.run();
        }
    }

    @Override
    public Rect getRect() {
        int xWidth = this.wrapped.font.width(this.wrapped.value.substring(0, this.wrapped.getCursorPosition()));
        float x = xWidth + this.wrapped.getX() + (this.wrapped.bordered ? 4 : 0);
        Objects.requireNonNull(this.wrapped.font);
        float y = (float)(9 + this.wrapped.getY()) + (this.wrapped.bordered ? (float)(this.wrapped.getHeight() - 8) / 2.0f : 0.0f);
        return new Rect(x, y, this.wrapped.getWidth(), this.wrapped.getHeight());
    }

    public void setInsertCallback(Runnable callback) {
        this.insertCallback = callback;
    }
}

