/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.rewards;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.init.registry.SoundRegistration;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonRewardTypes;
import dev.architectury.hooks.item.ItemStackHooks;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.client.FTBQuestsNetClient;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PokelootReward
extends Reward {
    public int count = 1;
    public boolean playSound = true;
    public LootTier lootTier = LootTier.ONE;

    public PokelootReward(long id, Quest q) {
        super(id, q);
    }

    public RewardType getType() {
        return PokemonRewardTypes.POKELOOT;
    }

    public void claim(ServerPlayer player, boolean notify) {
        if (this.playSound) {
            player.playSound((SoundEvent)SoundRegistration.POKELOOT_OBTAINED.get(), 0.2f, 1.0f);
        }
        if (notify) {
            FTBQuestsNetClient.displayRewardToast((long)this.id, (Component)Component.translatable((String)"ftbquests.reward.pixelmon.pokeloot.toast", (Object[])new Object[]{this.count, Component.translatable((String)("ftbquests.reward.pixelmon.pokeloot." + this.lootTier.name().toLowerCase()))}), (Icon)Icon.getIcon((String)("pixeltweaks:textures/gui/pokeloot/" + (this.lootTier.ordinal() + 1) + ".png")), (boolean)true);
        }
        for (int i = 0; i < this.count; ++i) {
            ItemStackHooks.giveItem((ServerPlayer)player, (ItemStack)((ItemStack)RandomHelper.getRandomElementFromCollection(this.lootTier.getItems())));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        return Icon.getIcon((String)("pixeltweaks:textures/gui/pokeloot/" + (this.lootTier.ordinal() + 1) + ".png"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        return Component.literal((String)(this.count + "x ")).append((Component)Component.translatable((String)"ftbquests.reward.pixelmon.pokeloot.title", (Object[])new Object[]{Component.translatable((String)("ftbquests.reward.pixelmon.pokeloot." + this.lootTier.name().toLowerCase()))}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getButtonText() {
        return this.count > 1 ? "" + this.count : "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addInt("count", this.count, v -> {
            this.count = v;
        }, 1, 1, Integer.MAX_VALUE);
        config.addBool("play_sound", this.playSound, v -> {
            this.playSound = v;
        }, true);
        config.addEnum("loot_tier", (Object)this.lootTier, v -> {
            this.lootTier = v;
        }, NameMap.of((Object)((Object)LootTier.ONE), (Object[])LootTier.values()).nameKey(v -> "ftbquests.reward.pixelmon.pokeloot." + v.name().toLowerCase()).create());
    }

    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putInt("count", this.count);
        nbt.putBoolean("play_sound", this.playSound);
        nbt.putByte("loot_tier", (byte)this.lootTier.ordinal());
    }

    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.count = nbt.getInt("count");
        this.playSound = nbt.getBoolean("play_sound");
        this.lootTier = LootTier.values()[nbt.getByte("loot_tier")];
    }

    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeVarInt(this.count);
        buffer.writeBoolean(this.playSound);
        buffer.writeByte(this.lootTier.ordinal());
    }

    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.count = buffer.readVarInt();
        this.playSound = buffer.readBoolean();
        this.lootTier = LootTier.values()[buffer.readByte()];
    }

    public static enum LootTier {
        ONE(DropItemRegistry.tier1),
        TWO(DropItemRegistry.tier2),
        THREE(DropItemRegistry.tier3),
        FOUR(DropItemRegistry.ultraSpace);

        private List<ItemStack> items;

        private LootTier(List<ItemStack> items) {
            this.items = items;
        }

        public List<ItemStack> getItems() {
            return this.items;
        }
    }
}

