/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.mojang.serialization.DynamicOps;
import com.pixelmonmod.pixelmon.init.registry.ItemRegistration;
import com.pixelmonmod.pixelmon.items.ReviveItem;
import com.pixelmonmod.pixelmon.items.StatusAilmentHealerItem;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTaskTypes;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BattleItemTask
extends PokemonTask {
    public ItemType type = ItemType.REVIVE;
    public ItemStack customItem = ((StatusAilmentHealerItem)ItemRegistration.LAVA_COOKIE.get()).getDefaultInstance();

    public BattleItemTask(long id, Quest q) {
        super(id, q);
    }

    public TaskType getType() {
        return PokemonTaskTypes.BATTLE_ITEM;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putByte("type", (byte)this.type.ordinal());
        if (this.type == ItemType.CUSTOM) {
            ItemStack.SINGLE_ITEM_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.customItem).ifSuccess(t -> nbt.put("custom_item", t));
        }
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.type = ItemType.values()[nbt.getByte("type")];
        if (this.type == ItemType.CUSTOM) {
            ItemStack.SINGLE_ITEM_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("custom_item")).ifSuccess(t -> {
                this.customItem = (ItemStack)t.getFirst();
            });
        }
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeByte(this.type.ordinal());
        if (this.type == ItemType.CUSTOM) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.customItem);
        }
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.type = ItemType.values()[buffer.readByte()];
        if (this.type == ItemType.CUSTOM) {
            this.customItem = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("itemType", (Object)this.type, v -> {
            this.type = v;
        }, NameMap.of((Object)((Object)ItemType.REVIVE), (Object[])ItemType.values()).nameKey(v -> "pixeltweaks.battle_item_type." + v.name().toLowerCase()).icon(v -> {
            switch (v.ordinal()) {
                case 7: {
                    return Icon.getIcon((ResourceLocation)ItemRegistration.REVIVAL_HERB.getId());
                }
                case 5: {
                    return Icon.getIcon((ResourceLocation)ItemRegistration.X_ACCURACY.getId());
                }
                case 1: {
                    return Icon.getIcon((ResourceLocation)ItemRegistration.POTION.getId());
                }
                case 2: {
                    return Icon.getIcon((ResourceLocation)ItemRegistration.REVIVE.getId());
                }
                case 4: {
                    return Icon.getIcon((ResourceLocation)ItemRegistration.PARALYZE_HEAL.getId());
                }
                case 3: {
                    return Icon.getIcon((ResourceLocation)ItemRegistration.RAZZ_BERRY.getId());
                }
                case 6: {
                    return Icon.getIcon((ResourceLocation)ItemRegistration.ESCAPE_ROPE.getId());
                }
            }
            return null;
        }).create());
        config.addItemStack("customItem", this.customItem, v -> {
            this.customItem = v;
        }, ((ReviveItem)ItemRegistration.REVIVE.get()).getDefaultInstance(), true, false);
    }

    public static enum ItemType {
        ANY(new Item[0]),
        POTION((Item)ItemRegistration.POTION.get(), (Item)ItemRegistration.SUPER_POTION.get(), (Item)ItemRegistration.HYPER_POTION.get(), (Item)ItemRegistration.MAX_POTION.get(), (Item)ItemRegistration.MOOMOO_MILK.get(), (Item)ItemRegistration.FULL_RESTORE.get(), (Item)ItemRegistration.LAVA_COOKIE.get(), (Item)ItemRegistration.ENERGY_POWDER.get(), (Item)ItemRegistration.ENERGY_ROOT.get(), (Item)ItemRegistration.LEMONADE.get(), (Item)ItemRegistration.SODA_POP.get(), (Item)ItemRegistration.FRESH_WATER.get(), (Item)ItemRegistration.KOMALA_COFFEE.get(), (Item)ItemRegistration.TAPU_COCOA.get(), (Item)ItemRegistration.PINAP_JUICE.get(), (Item)ItemRegistration.ROSERADE_TEA.get(), (Item)ItemRegistration.SKITTY_SMOOTHIE.get()),
        REVIVE((Item)ItemRegistration.REVIVE.get(), (Item)ItemRegistration.MAX_REVIVE.get(), (Item)ItemRegistration.REVIVAL_HERB.get()),
        BERRY((Item)ItemRegistration.CHERI_BERRY.get(), (Item)ItemRegistration.CHESTO_BERRY.get(), (Item)ItemRegistration.PECHA_BERRY.get(), (Item)ItemRegistration.RAWST_BERRY.get(), (Item)ItemRegistration.ASPEAR_BERRY.get(), (Item)ItemRegistration.LEPPA_BERRY.get(), (Item)ItemRegistration.PERSIM_BERRY.get(), (Item)ItemRegistration.ORAN_BERRY.get(), (Item)ItemRegistration.LUM_BERRY.get(), (Item)ItemRegistration.SITRUS_BERRY.get(), (Item)ItemRegistration.FIGY_BERRY.get(), (Item)ItemRegistration.WIKI_BERRY.get(), (Item)ItemRegistration.MAGO_BERRY.get(), (Item)ItemRegistration.IAPAPA_BERRY.get()),
        STATUS_HEAL((Item)ItemRegistration.HEAL_POWDER.get(), (Item)ItemRegistration.BURN_HEAL.get(), (Item)ItemRegistration.FULL_HEAL.get(), (Item)ItemRegistration.FULL_RESTORE.get(), (Item)ItemRegistration.ICE_HEAL.get(), (Item)ItemRegistration.PARALYZE_HEAL.get(), (Item)ItemRegistration.ANTIDOTE.get(), (Item)ItemRegistration.AWAKENING.get(), (Item)ItemRegistration.RAGE_CANDY_BAR.get(), (Item)ItemRegistration.LAVA_COOKIE.get(), (Item)ItemRegistration.OLD_GATEAU.get(), (Item)ItemRegistration.CASTELIACONE.get(), (Item)ItemRegistration.LUMIOSE_GALETTE.get(), (Item)ItemRegistration.SHALOUR_SABLE.get(), (Item)ItemRegistration.BIG_MALASADA.get(), (Item)ItemRegistration.CHERI_BERRY.get(), (Item)ItemRegistration.CHESTO_BERRY.get(), (Item)ItemRegistration.PECHA_BERRY.get(), (Item)ItemRegistration.RAWST_BERRY.get(), (Item)ItemRegistration.ASPEAR_BERRY.get(), (Item)ItemRegistration.PERSIM_BERRY.get(), (Item)ItemRegistration.LUM_BERRY.get()),
        BOOST((Item)ItemRegistration.X_ACCURACY.get(), (Item)ItemRegistration.X_ATTACK.get(), (Item)ItemRegistration.X_SPECIAL_ATTACK.get(), (Item)ItemRegistration.X_DEFENSE.get(), (Item)ItemRegistration.X_SPECIAL_DEFENSE.get(), (Item)ItemRegistration.X_SPEED.get(), (Item)ItemRegistration.DIRE_HIT.get(), (Item)ItemRegistration.GUARD_SPEC.get(), (Item)ItemRegistration.RED_FLUTE.get(), (Item)ItemRegistration.BLUE_FLUTE.get(), (Item)ItemRegistration.GREEN_FLUTE.get(), (Item)ItemRegistration.YELLOW_FLUTE.get()),
        ESCAPE((Item)ItemRegistration.ESCAPE_ROPE.get(), (Item)ItemRegistration.FLUFFY_TAIL.get()),
        HERB((Item)ItemRegistration.ENERGY_POWDER.get(), (Item)ItemRegistration.ENERGY_ROOT.get(), (Item)ItemRegistration.REVIVAL_HERB.get(), (Item)ItemRegistration.HEAL_POWDER.get()),
        CUSTOM(new Item[0]);

        private Item[] items;
        private Set<Item> itemSet;

        private ItemType(Item ... items) {
            this.items = items;
            this.itemSet = new HashSet<Item>(Arrays.asList(items));
        }

        public boolean contains(Item item) {
            return this.itemSet.contains(item);
        }
    }
}

