/*
 * Decompiled with CFR 0.152.
 */
package com.strangeone101.pixeltweaks.integration.ftbquests.tasks;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTask;
import com.strangeone101.pixeltweaks.integration.ftbquests.PokemonTaskTypes;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CatchTask
extends PokemonTask {
    public GetType getType = GetType.ANY_EXCEPT_COMMANDS;

    public CatchTask(long id, Quest q) {
        super(id, q);
    }

    public TaskType getType() {
        return PokemonTaskTypes.CATCH_POKEMON;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putByte("catchType", (byte)this.getType.ordinal());
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.getType = GetType.values()[nbt.getByte("catchType")];
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeByte(this.getType.ordinal());
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.getType = GetType.values()[buffer.readByte()];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("type", (Object)this.getType, v -> {
            this.getType = v;
        }, NameMap.of((Object)((Object)GetType.ANY_EXCEPT_COMMANDS), (Object[])GetType.values()).nameKey(v -> "pixeltweaks.catch_type." + v.name().toLowerCase()).create());
    }

    public void catchPokemon(TeamData team, Pokemon pokemon) {
        if (!(team.isCompleted((QuestObject)this) || this.cachedSpec != null && !this.cachedSpec.matches((Object)pokemon) || this.getType != GetType.CATCH && this.getType != GetType.CATCH_OR_RAID && this.getType != GetType.ANY && this.getType != GetType.ANY_EXCEPT_COMMANDS)) {
            team.addProgress((Task)this, 1L);
        }
    }

    public void catchRaidPokemon(TeamData team, Pokemon pokemon) {
        if (!(team.isCompleted((QuestObject)this) || this.cachedSpec != null && this.cachedSpec.matches((Object)pokemon) == this.invert || this.getType != GetType.CATCH_OR_RAID && this.getType != GetType.RAID && this.getType != GetType.ANY && this.getType != GetType.ANY_EXCEPT_COMMANDS)) {
            team.addProgress((Task)this, 1L);
        }
    }

    public void onCommand(TeamData team, Pokemon pokemon) {
        if (!(team.isCompleted((QuestObject)this) || this.cachedSpec != null && this.cachedSpec.matches((Object)pokemon) == this.invert || this.getType != GetType.COMMAND && this.getType != GetType.ANY)) {
            team.addProgress((Task)this, 1L);
        }
    }

    public void onChristmas(TeamData team, Pokemon pokemon) {
        if (!(team.isCompleted((QuestObject)this) || this.cachedSpec != null && this.cachedSpec.matches((Object)pokemon) == this.invert || this.getType != GetType.CHRISTMAS && this.getType != GetType.ANY && this.getType != GetType.ANY_EXCEPT_COMMANDS)) {
            team.addProgress((Task)this, 1L);
        }
    }

    public void onFossil(TeamData team, Pokemon pokemon) {
        if (!(team.isCompleted((QuestObject)this) || this.cachedSpec != null && this.cachedSpec.matches((Object)pokemon) == this.invert || this.getType != GetType.FOSSIL && this.getType != GetType.ANY && this.getType != GetType.ANY_EXCEPT_COMMANDS)) {
            team.addProgress((Task)this, 1L);
        }
    }

    public void onEggHatch(TeamData team, Pokemon pokemon) {
        if (!(team.isCompleted((QuestObject)this) || this.cachedSpec != null && this.cachedSpec.matches((Object)pokemon) == this.invert || this.getType != GetType.ANY && this.getType != GetType.ANY_EXCEPT_COMMANDS)) {
            team.addProgress((Task)this, 1L);
        }
    }

    public static enum GetType {
        ANY,
        ANY_EXCEPT_COMMANDS,
        CATCH,
        RAID,
        CATCH_OR_RAID,
        FOSSIL,
        CHRISTMAS,
        COMMAND;

    }
}

